/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleSelectionList;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.StringHolder;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PackConfigScreen
extends Screen {
    private static final String MOD_TEXT = I18n.func_135052_a((String)"screen.config.mod", (Object[])new Object[0]);
    private static final String CLOSE_TEXT = I18n.func_135052_a((String)"screen.config.close", (Object[])new Object[0]);
    private static final String FEATURES_TEXT = I18n.func_135052_a((String)"screen.config.features", (Object[])new Object[0]);
    private static final String PACK_ID_TEXT = I18n.func_135052_a((String)"config.pack_id", (Object[])new Object[0]);
    private static final String PARTNER_ID_TEXT = I18n.func_135052_a((String)"config.partner_id", (Object[])new Object[0]);
    private static final String PACK_EDIT_MODE_TEXT = I18n.func_135052_a((String)"config.pack_edit_mode", (Object[])new Object[0]);
    public static final float SPLIT = 0.3f;
    private Screen parent;
    private ModuleSelectionList moduleSelectionList;
    private TextConfigEditBox packIdEditBox;
    private TextConfigEditBox partnerIdEditBox;
    private TickBoxConfigComponent enableConfigScreenTickButton;
    public static boolean hasChanged;

    public PackConfigScreen(Screen parent) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"screen.config.pack.title", (Object[])new Object[0])));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int splitWidth = (int)((float)this.width * 0.3f);
        this.moduleSelectionList = new ModuleSelectionList(this, this.minecraft, this.width - splitWidth, this.height, 45, this.height - 8, 30);
        for (IModule module : ModRoot.get().modules.getAll()) {
            this.moduleSelectionList.addPackEntry(module);
        }
        this.moduleSelectionList.setLeftPos(splitWidth);
        this.children.add(this.moduleSelectionList);
        int boxWidth = 100;
        this.packIdEditBox = new TextConfigEditBox(new StringHolder(GlobalConfigs.packId), this.font, (splitWidth - boxWidth) / 2, 75, boxWidth, 20, PACK_ID_TEXT);
        this.addButton((Widget)this.packIdEditBox);
        this.partnerIdEditBox = new TextConfigEditBox(new StringHolder(GlobalConfigs.partnerId), this.font, (splitWidth - boxWidth) / 2, 125, boxWidth, 20, PARTNER_ID_TEXT);
        this.addButton((Widget)this.partnerIdEditBox);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        this.enableConfigScreenTickButton = new TickBoxConfigComponent(new BooleanHolder(GlobalConfigs.packEditMode), splitWidth / 2 - 10, this.height - 55, 20, 20);
        this.addButton((Widget)this.enableConfigScreenTickButton);
        this.addButton((Widget)new Button((splitWidth - buttonWidth) / 2, this.height - 28, buttonWidth, 20, CLOSE_TEXT, btn -> this.onClose()));
    }

    public void render(int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.width * 0.3f);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        this.renderBackground();
        this.moduleSelectionList.render(mouseX, mouseY, delta);
        super.render(mouseX, mouseY, delta);
        this.drawCenteredString(this.font, MOD_TEXT, this.width / 2, 10, 0xFFFFFF);
        this.drawCenteredString(this.font, FEATURES_TEXT, (this.width + splitWidth) / 2, 30, 0xFFFFFF);
        this.drawCenteredString(this.font, PACK_ID_TEXT, splitWidth / 2, 60, 0xFFFFFF);
        this.drawCenteredString(this.font, PARTNER_ID_TEXT, splitWidth / 2, 110, 0xFFFFFF);
        int n = splitWidth / 2;
        this.font.getClass();
        this.drawCenteredString(this.font, PACK_EDIT_MODE_TEXT, n, this.height - 57 - 9, 0xFFFFFF);
    }

    public void tick() {
        this.packIdEditBox.func_146178_a();
        this.partnerIdEditBox.func_146178_a();
    }

    public void onClose() {
        this.packIdEditBox.save();
        this.partnerIdEditBox.save();
        this.enableConfigScreenTickButton.save();
        this.moduleSelectionList.saveAll();
        if (hasChanged) {
            GlobalConfigs.reloadConfigs();
            hasChanged = false;
        }
        this.minecraft.func_147108_a(this.parent);
    }
}

