/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleSelectionList;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class UserConfigScreen
extends Screen {
    private static final Supplier<String> TITLE_TEXT = () -> I18n.func_135052_a((String)"screen.config.user.title", (Object[])new Object[0]);
    private static final Supplier<String> CLOSE_TEXT = () -> I18n.func_135052_a((String)"screen.config.close", (Object[])new Object[0]);
    private static final Supplier<String> FEATURES_TEXT = () -> I18n.func_135052_a((String)"screen.config.features", (Object[])new Object[0]);
    public static final float SPLIT = 0.3f;
    private Screen parent;
    private ModuleSelectionList moduleSelectionList;
    public static boolean hasChanged;

    public UserConfigScreen(Screen parent) {
        super((ITextComponent)new StringTextComponent(TITLE_TEXT.get()));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.moduleSelectionList = new ModuleSelectionList(this, this.minecraft, this.width, this.height, 45, this.height - 36, 30);
        for (IModule module : ModRoot.get().modules.getAll()) {
            this.moduleSelectionList.addUserEntry(module);
        }
        this.children.add(this.moduleSelectionList);
        Button closeButton = new Button(this.width / 2 - 100, this.height - 28, 200, 20, CLOSE_TEXT.get(), btn -> this.onClose());
        this.addButton((Widget)closeButton);
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        this.moduleSelectionList.render(mouseX, mouseY, delta);
        super.render(mouseX, mouseY, delta);
        this.drawCenteredString(this.font, TITLE_TEXT.get(), this.width / 2, 10, 0xFFFFFF);
        this.drawCenteredString(this.font, FEATURES_TEXT.get(), this.width / 2, 30, 0xFFFFFF);
    }

    public void onClose() {
        this.moduleSelectionList.saveAll();
        if (hasChanged) {
            GlobalConfigs.reloadConfigs();
            hasChanged = false;
        }
        this.minecraft.func_147108_a(this.parent);
    }
}

