/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.config.IConfigurable;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.StringUtils;

public class ModuleConfigList
extends ExtendedList<Entry> {
    private ModuleConfigScreen screen;

    public ModuleConfigList(ModuleConfigScreen screen, Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.screen = screen;
    }

    public void saveAll() {
        for (Entry entry : this.children()) {
            entry.save();
        }
    }

    public void populateModuleConfigList(BiConsumer<ModuleConfigList, Consumer<Entry>> populator) {
        populator.accept(this, arg_0 -> ((ModuleConfigList)this).addEntry(arg_0));
    }

    public void render(int mouseX, int mouseY, float delta) {
        super.render(mouseX, mouseY, delta);
        Entry entry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
        if (mouseX < this.width / 2 && entry != null && !entry.comments.isEmpty()) {
            this.screen.renderTooltip(entry.comments, mouseX, mouseY);
        }
    }

    public int getRowWidth() {
        return this.width - 40;
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public static class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
        private final ModuleConfigList parent;
        private final List<String> comments = new ArrayList<String>();
        private final String text;
        private final Widget configButton;
        private final List<Widget> children;

        public Entry(ModuleConfigList parent, String comments, String text, Widget button) {
            this.parent = parent;
            if (!StringUtils.func_151246_b((String)comments)) {
                this.comments.addAll(Arrays.asList(comments.split("\n")));
            }
            this.text = text;
            this.configButton = button;
            this.children = Lists.newArrayList((Object[])new Widget[]{this.configButton});
        }

        public void render(int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.configButton.x = left + width / 2 + 10;
            this.configButton.y = top + (innerHeight - this.configButton.getHeight()) / 2;
            this.configButton.setWidth(width / 2 - 10);
            this.configButton.render(mouseX, mouseY, delta);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            float f = left;
            float f2 = top;
            font.getClass();
            font.func_211126_b(this.text, f, f2 + (float)(innerHeight - 9) / 2.0f, 0xFFFFFF);
        }

        public void save() {
            if (this.configButton instanceof IConfigurable) {
                ((IConfigurable)this.configButton).save();
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (Widget child : this.children) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public boolean charTyped(char key, int code) {
            for (Widget child : this.children) {
                if (!child.charTyped(key, code)) continue;
                return true;
            }
            return false;
        }

        public boolean keyPressed(int keycode, int scancode, int modifiers) {
            for (Widget child : this.children) {
                if (!child.keyPressed(keycode, scancode, modifiers)) continue;
                return true;
            }
            return false;
        }
    }
}

