/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.bisecthosting.mods.bhmenu.config.components.ConfigButtonComponent;
import com.bisecthosting.mods.bhmenu.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;

public class ModuleSelectionList
extends ExtendedList<Entry> {
    private Screen parent;

    public ModuleSelectionList(Screen parent, Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.parent = parent;
    }

    public int addEntry(Entry entry) {
        return super.addEntry((AbstractList.AbstractListEntry)entry);
    }

    public int addPackEntry(IModule module) {
        return this.addEntry(new PackEntry(module));
    }

    public int addUserEntry(IModule module) {
        return this.addEntry(new UserEntry(module));
    }

    public void saveAll() {
        for (Entry entry : this.children()) {
            entry.save();
        }
    }

    public void render(int p_93448_, int p_93449_, float p_93450_) {
        super.render(p_93448_, p_93449_, p_93450_);
    }

    protected int getScrollbarPosition() {
        return this.x1 - 6;
    }

    public int getRowWidth() {
        return Math.min(this.width - 40, 260);
    }

    public class UserEntry
    extends Entry {
        private final AbstractButton configButton;
        private final List<AbstractButton> children;

        public UserEntry(IModule module) {
            this.configButton = new Button(0, 0, 0, 20, I18n.func_135052_a((String)("screen.config.modules." + module.getId() + ".name"), (Object[])new Object[0]), btn -> Minecraft.func_71410_x().func_147108_a((Screen)new ModuleConfigScreen(ModuleSelectionList.this.parent, module, module::populateUserConfigs)));
            if (!module.hasUserConfigs()) {
                this.configButton.active = false;
            }
            this.children = Lists.newArrayList((Object[])new AbstractButton[]{this.configButton});
        }

        public void render(int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.configButton.x = left;
            this.configButton.setWidth(width);
            this.configButton.y = top;
            this.configButton.render(mouseX, mouseY, delta);
        }

        @Override
        public void save() {
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (AbstractButton child : this.children) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    public class PackEntry
    extends Entry {
        private final IModule module;
        private final ConfigButtonComponent toggle;
        private final AbstractButton configButton;
        private final List<AbstractButton> children;

        public PackEntry(IModule module) {
            this.module = module;
            this.toggle = new TickBoxConfigComponent(new BooleanHolder(ModRoot.get().modules.getEnabledValue(module.getId())), 0, 0, 20, 20);
            this.configButton = new Button(0, 0, 0, 20, I18n.func_135052_a((String)("screen.config.modules." + module.getId() + ".name"), (Object[])new Object[0]), btn -> Minecraft.func_71410_x().func_147108_a((Screen)new ModuleConfigScreen(ModuleSelectionList.this.parent, module, module::populatePackConfigs)));
            if (!module.hasPackConfigs()) {
                this.configButton.active = false;
            }
            this.children = Lists.newArrayList((Object[])new AbstractButton[]{this.toggle, this.configButton});
        }

        public void render(int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.toggle.x = left;
            this.configButton.x = left + 30;
            this.configButton.setWidth(width - 30);
            this.children.forEach(child -> {
                child.y = top;
                child.render(mouseX, mouseY, delta);
            });
        }

        @Override
        public void save() {
            this.toggle.save();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (AbstractButton child : this.children) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
        public abstract void save();
    }
}

