/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.CustomButton;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.components.text.IntegerConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.BooleanConfigButton;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.IntegerHolder;
import com.bisecthosting.mods.bhmenu.modules.BaseModule;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerLoadingScreen;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublicServerList
extends BaseModule {
    private static final ResourceLocation OPEN_SCREEN_TEX = ModRef.res("textures/publicserverlist/gui/open_screen_button.png");
    private static final Supplier<String> OPEN_SCREEN_TOOLTIP = () -> I18n.func_135052_a((String)"modules.public_server_list.open_screen.tooltip", (Object[])new Object[0]);
    private static final Supplier<String> OPEN_SCREEN_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.open_screen.text", (Object[])new Object[0]);
    public static final Logger LOGGER = LogManager.getLogger();
    public ForgeConfigSpec.IntValue buttonX;
    public ForgeConfigSpec.IntValue buttonY;
    public ForgeConfigSpec.IntValue buttonWidth;
    public ForgeConfigSpec.BooleanValue vanillaButton;

    public PublicServerList() {
        super("public_server_list");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void addPublicServerWidget(GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.isEnabled() && event.getGui() instanceof MultiplayerScreen) {
            MultiplayerScreen screen = (MultiplayerScreen)event.getGui();
            int buttonX = screen.width / 2 + 160;
            if ((Integer)this.buttonX.get() > -1) {
                buttonX = (Integer)this.buttonX.get();
            }
            int buttonWidth = Math.min(100, screen.width - buttonX - 4);
            if ((Integer)this.buttonWidth.get() > 0) {
                buttonWidth = (Integer)this.buttonWidth.get();
            }
            int buttonY = screen.height - 52;
            if ((Integer)this.buttonY.get() > -1) {
                buttonY = (Integer)this.buttonY.get();
            }
            Object button = (Boolean)this.vanillaButton.get() != false ? new Button(buttonX, buttonY, buttonWidth, 20, OPEN_SCREEN_TEXT.get(), btn -> Minecraft.func_71410_x().func_147108_a((Screen)new PublicServerLoadingScreen((Screen)screen))) : new CustomButton(buttonX, buttonY, buttonWidth, 20, OPEN_SCREEN_TEXT.get(), btn -> Minecraft.func_71410_x().func_147108_a((Screen)new PublicServerLoadingScreen((Screen)screen)));
            event.addWidget((Widget)button);
        }
    }

    @Override
    public void buildConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("Modpack Configs").push("pack");
        builder.comment("Open Public Screen List Button").push("open_screen_button");
        this.buttonX = builder.comment(new String[]{"The position of the button from the left of the screen.", "Set to -1 to default."}).defineInRange("x", -1, -1, Integer.MAX_VALUE);
        this.buttonY = builder.comment(new String[]{"The position of the button from the top of the screen.", "Set to -1 to default."}).defineInRange("y", -1, -1, Integer.MAX_VALUE);
        this.buttonWidth = builder.comment(new String[]{"The width of the button.", "Set to 0 to default."}).defineInRange("width", 0, 0, 400);
        this.vanillaButton = builder.comment(new String[]{"Turn the Public Server List button into a vanilla styled one.", "Causes default vanilla graphics and might help with compatibility with other mods."}).define("vanillaButton", false);
        builder.pop();
        builder.pop();
    }

    @Override
    public boolean hasPackConfigs() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void populatePackConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
        String text = I18n.func_135052_a((String)"modules.public_server_list.config.button_x", (Object[])new Object[0]);
        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.buttonX.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), text, (Widget)new IntegerConfigEditBox(new IntegerHolder(this.buttonX), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.public_server_list.config.button_y", (Object[])new Object[0]);
        valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.buttonY.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), text, (Widget)new IntegerConfigEditBox(new IntegerHolder(this.buttonY), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.public_server_list.config.button_width", (Object[])new Object[0]);
        valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.buttonWidth.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), text, (Widget)new IntegerConfigEditBox(new IntegerHolder(this.buttonWidth), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.public_server_list.config.vanilla_button", (Object[])new Object[0]);
        valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.vanillaButton.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), text, (Widget)new BooleanConfigButton(new BooleanHolder(this.vanillaButton), 0, 0, 0, 20)));
    }
}

