/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.api.PublicServerApiData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServersScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PublicServerLoadingScreen
extends Screen {
    private static final String BACK_TEXT = I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]);
    private static final String LOADING_TEXT = I18n.func_135052_a((String)"modules.public_server_list.loading.loading", (Object[])new Object[0]);
    private static final String FAILED_TO_LOAD_TEXT = I18n.func_135052_a((String)"modules.public_server_list.loading.failed", (Object[])new Object[0]);
    private CompletableFuture<List<ServerData>> task;
    private List<ServerData> publicServers = new ArrayList<ServerData>();
    private MultiplayerScreen parent;
    private String errorMessage;

    public PublicServerLoadingScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("modules.public_server_list.loading.title", new Object[0]));
        this.parent = (MultiplayerScreen)parent;
        this.task = PublicServerApiData.reloadData((String)GlobalConfigs.packId.get()).whenComplete((v, e) -> {
            if (e != null) {
                this.errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                return;
            }
            this.publicServers.addAll((Collection<ServerData>)v);
        });
    }

    protected void init() {
        super.init();
        this.addButton((Widget)new Button((this.width - 100) / 2, this.height - 40, 100, 20, BACK_TEXT, b -> this.onClose()));
    }

    public void tick() {
        if (this.task.isDone()) {
            this.minecraft.func_147108_a((Screen)new PublicServersScreen(this.parent, this.publicServers));
        }
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        super.render(mouseX, mouseY, delta);
        if (!this.task.isDone()) {
            String s;
            this.font.func_211126_b(LOADING_TEXT, (float)(this.width / 2 - this.font.func_78256_a(LOADING_TEXT) / 2), (float)this.height / 2.0f - 25.0f, 0xFFFFFF);
            switch ((int)(Util.func_211177_b() / 300L % 4L)) {
                default: {
                    s = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    s = "o O o";
                    break;
                }
                case 2: {
                    s = "o o O";
                }
            }
            this.font.func_211126_b(s, (float)(this.width / 2 - this.font.func_78256_a(s) / 2), (float)this.height / 2.0f - 10.0f, 0xFFFFFF);
        } else if (this.task.isCompletedExceptionally()) {
            this.font.func_211126_b(FAILED_TO_LOAD_TEXT, (float)(this.width / 2 - this.font.func_78256_a(FAILED_TO_LOAD_TEXT) / 2), (float)this.height / 2.0f - 25.0f, 0xFFFFFF);
            int i = 0;
            for (String text : this.font.func_78271_c(this.errorMessage, 200)) {
                float f = this.width / 2 - this.font.func_78256_a(text) / 2;
                float f2 = (float)this.height / 2.0f;
                this.font.getClass();
                this.font.func_211126_b(text, f, f2 + (float)((i + 2) * 9), 0xFFFFFF);
                ++i;
            }
        }
    }

    public void onClose() {
        if (!this.task.isDone()) {
            this.task.cancel(true);
        }
        this.minecraft.func_147108_a((Screen)this.parent);
    }
}

