/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.TickBoxButton;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerLoadingScreen;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerSelectionList;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.AddServerScreen;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.ServerPinger;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PublicServersScreen
extends Screen {
    private static final Supplier<String> JOIN_SERVER_TEXT = () -> I18n.func_135052_a((String)"selectServer.select", (Object[])new Object[0]);
    private static final Supplier<String> ADD_SERVER_TEXT = () -> I18n.func_135052_a((String)"selectServer.add", (Object[])new Object[0]);
    private static final Supplier<String> BACK_TEXT = () -> I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]);
    private static final Supplier<String> REFRESH_TEXT = () -> I18n.func_135052_a((String)"selectServer.refresh", (Object[])new Object[0]);
    private static final ITextComponent TITLE_TEXT = new TranslationTextComponent("modules.public_server_list.title", new Object[0]);
    private static final Supplier<String> HOW_TO_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.how_to", (Object[])new Object[0]);
    private static final Supplier<String> NAME_FILTER_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.filter.name", (Object[])new Object[0]);
    private static final Supplier<String> PING_SORT_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.sort.ping", (Object[])new Object[0]);
    private static final Supplier<String> PLAYER_COUNT_SORT_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.sort.player_count", (Object[])new Object[0]);
    private static final URI HOW_TO_URI = URI.create("https://www.bisecthosting.com/clients/index.php?rp=/knowledgebase/348/How-to-add-a-modpack-server-to-the-public-server-list.html");
    private final ServerPinger pinger = new ServerPinger();
    private PublicServerSelectionList serverSelectionList;
    private ServerListData servers;
    private Button addButton;
    private Button joinButton;
    private Button howTobutton;
    private TextFieldWidget searchBar;
    private TickBoxButton pingSort;
    private TickBoxButton playerCountSort;
    public static final float SPLIT = 0.4f;
    private List<String> tooltip;
    private boolean openedLink;
    public final MultiplayerScreen multiplayerScreen;
    private boolean hasInit;

    public PublicServersScreen(MultiplayerScreen multiplayerScreen, List<ServerData> servers) {
        super(TITLE_TEXT);
        this.multiplayerScreen = multiplayerScreen;
        this.servers = new ServerListData(servers);
    }

    protected void init() {
        int splitWidth = (int)((float)this.width * 0.4f);
        if (this.hasInit) {
            this.serverSelectionList.updateSize(this.width - splitWidth, this.height, 32, this.height - 8);
            this.serverSelectionList.setLeftPos(splitWidth);
        } else {
            this.hasInit = true;
            this.serverSelectionList = new PublicServerSelectionList(this, this.minecraft, this.width - splitWidth, this.height, 32, this.height - 8, 36);
            this.serverSelectionList.setLeftPos(splitWidth);
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.children.add(this.serverSelectionList);
        this.searchBar = new TextFieldWidget(this.getMinecraft().field_71466_p, 10, 52, splitWidth - 20, 20, this.searchBar, "");
        this.searchBar.func_212954_a(this.serverSelectionList::setNameFilter);
        this.addButton((Widget)this.searchBar);
        this.pingSort = new TickBoxButton(splitWidth - 40, 90, this.pingSort, this.serverSelectionList::togglePingSort);
        this.addButton((Widget)this.pingSort);
        this.playerCountSort = new TickBoxButton(splitWidth - 40, 124, this.playerCountSort, this.serverSelectionList::togglePlayerCountSort);
        this.addButton((Widget)this.playerCountSort);
        int buttonWidth = Math.min(100, splitWidth / 2 - 4);
        this.addButton((Widget)new Button(splitWidth / 2 - buttonWidth - 2, this.height - 28, buttonWidth, 20, REFRESH_TEXT.get(), btn -> this.minecraft.func_147108_a((Screen)new PublicServerLoadingScreen((Screen)this.multiplayerScreen))));
        this.addButton((Widget)new Button(splitWidth / 2 + 2, this.height - 28, buttonWidth, 20, BACK_TEXT.get(), btn -> this.onClose()));
        this.howTobutton = (Button)this.addButton((Widget)new Button(splitWidth / 2 - buttonWidth - 2, this.height - 76, buttonWidth * 2 + 4, 20, HOW_TO_TEXT.get(), btn -> this.openHowToPage()));
        this.joinButton = (Button)this.addButton((Widget)new Button(splitWidth / 2 - buttonWidth - 2, this.height - 52, buttonWidth, 20, JOIN_SERVER_TEXT.get(), btn -> this.joinSelectedServer()));
        this.joinButton.active = false;
        this.addButton = (Button)this.addButton((Widget)new Button(splitWidth / 2 + 2, this.height - 52, buttonWidth, 20, ADD_SERVER_TEXT.get(), btn -> this.addSelectedServer()));
        this.addButton.active = false;
    }

    public void tick() {
        super.tick();
        this.pinger.func_147223_a();
        this.searchBar.func_146178_a();
        this.serverSelectionList.tick();
        if (this.openedLink) {
            this.howTobutton.changeFocus(false);
            this.openedLink = false;
        }
    }

    public void render(int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.width * 0.4f);
        this.tooltip = null;
        this.renderBackground();
        this.serverSelectionList.render(mouseX, mouseY, delta);
        super.render(mouseX, mouseY, delta);
        this.font.getClass();
        float fontHeight = 9.0f;
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 10, -1);
        if (this.tooltip != null) {
            this.renderTooltip(this.tooltip, mouseX, mouseY);
        }
        this.drawCenteredString(this.font, NAME_FILTER_TEXT.get(), splitWidth / 2, 32, -1);
        this.drawString(this.font, PING_SORT_TEXT.get(), 20, 90 + (int)((20.0f - fontHeight) / 2.0f), -1);
        this.drawString(this.font, PLAYER_COUNT_SORT_TEXT.get(), 20, 124 + (int)((20.0f - fontHeight) / 2.0f), -1);
    }

    public void joinSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.join((PublicServerSelectionList.ServerEntry)entry);
        }
    }

    public void join(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setLastJoined(entry);
        this.join(entry.getServerData());
    }

    private void join(ServerData server) {
        this.minecraft.func_147108_a((Screen)new ConnectingScreen((Screen)this, this.minecraft, server));
    }

    public void addSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            PublicServerSelectionList.ServerEntry serverEntry = (PublicServerSelectionList.ServerEntry)entry;
            ServerData data = serverEntry.getServerData();
            this.multiplayerScreen.field_146811_z = new ServerData(data.field_78847_a, data.field_78845_b, false);
            this.minecraft.func_147108_a((Screen)new AddServerScreen(arg_0 -> ((MultiplayerScreen)this.multiplayerScreen).func_214284_c(arg_0), this.multiplayerScreen.field_146811_z));
        }
    }

    public void openHowToPage() {
        ModRef.LOGGER.info("Opening knowledgebase " + HOW_TO_URI);
        Util.func_110647_a().func_195642_a(HOW_TO_URI);
        this.openedLink = true;
    }

    public void setSelected(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setSelected(entry);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.joinButton.active = false;
        this.addButton.active = false;
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.joinButton.active = true;
            this.addButton.active = true;
        }
    }

    public void removed() {
        this.pinger.func_147226_b();
        this.serverSelectionList.stopPingingServer();
    }

    public void onClose() {
        if (!this.searchBar.getMessage().isEmpty()) {
            this.searchBar.setMessage("");
        } else {
            this.minecraft.func_147108_a((Screen)this.multiplayerScreen);
        }
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public ServerPinger getPinger() {
        return this.pinger;
    }

    public ServerListData getServers() {
        return this.servers;
    }
}

