/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens;

import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.LoadPlansStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BHOrderScreen
extends Screen {
    public final Screen parent;
    private final OrderData orderData = new OrderData();
    private ProcessStep currentStep;
    private CompletableFuture<Void> task;
    private boolean firstTick = true;

    public BHOrderScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("bhorder.title", new Object[0]));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        if (this.currentStep != null) {
            this.currentStep.init(this, this::addChild);
        }
    }

    public void addChild(IGuiEventListener child) {
        if (child instanceof Widget) {
            this.addButton((Widget)child);
        } else {
            this.children.add(child);
        }
    }

    public void tick() {
        if (this.firstTick) {
            this.task = ApiData.reloadData().whenComplete((v, e) -> {
                if (e == null) {
                    this.setStep(new PlayerCountStep(this.orderData));
                }
            });
            this.setStep(new LoadPlansStep(this.task, this.orderData));
            this.firstTick = false;
        } else if (this.currentStep != null) {
            this.currentStep.tick(this);
        }
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        this.renderBackground();
        if (this.currentStep != null) {
            this.currentStep.render(this, this.font, mouseX, mouseY, pTicks);
        }
        super.render(mouseX, mouseY, pTicks);
        if (this.currentStep != null) {
            this.currentStep.renderLast(this, this.font, mouseX, mouseY, pTicks);
        }
    }

    public void setStep(ProcessStep step) {
        this.buttons.clear();
        this.children.clear();
        this.currentStep = step;
        if (this.currentStep != null) {
            this.currentStep.init(this, this::addChild);
        }
    }

    public void onClose() {
        if (this.currentStep != null) {
            this.currentStep.onClose(this);
        } else {
            this.minecraft.func_147108_a(this.parent);
        }
    }
}

