/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.RecommendJarStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectJarStep;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiSlider;

public class PlayerCountStep
extends ProcessStep {
    private final Supplier<String> question = () -> I18n.func_135052_a((String)"step.player_count.question", (Object[])new Object[0]);

    public PlayerCountStep(OrderData data) {
        super(data);
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<IGuiEventListener> children) {
        super.init(screen, children);
        children.accept((IGuiEventListener)new GuiSlider((screen.width - 250) / 2, screen.height / 2 - 30, 250, 20, "", "", 0.0, 100.0, (double)this.orderData.playerCount, false, true, b -> {}, s -> {
            int val = s.getValueInt();
            String stringVal = val > 99 ? "99+" : String.valueOf(val);
            s.setMessage(stringVal);
            this.orderData.playerCount = val;
        }));
        children.accept((IGuiEventListener)new Button(screen.width / 2 - 50, screen.height / 2 + 10, 100, 20, I18n.func_135052_a((String)"step.player_count.next", (Object[])new Object[0]), b -> {
            JarGroupData.JarData recommendedJar = PlayerCountStep.getRecommendedJarData();
            if (recommendedJar == null) {
                screen.setStep(new SelectJarStep(this.orderData));
            } else {
                screen.setStep(new RecommendJarStep(recommendedJar, this.orderData));
            }
        }));
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        font.func_211126_b(this.question.get(), (float)(screen.width - font.func_78256_a(this.question.get())) / 2.0f, (float)screen.height / 2.0f - 50.0f, 0xFFFFFF);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.getMinecraft().func_147108_a(screen.parent);
    }

    private static JarGroupData.JarData getRecommendedJarData() {
        if (((String)GlobalConfigs.packId.get()).isEmpty()) {
            return null;
        }
        JarGroupData.JarData recommendedJar = ApiData.AVAILABLE_JARS.get(GlobalConfigs.packId.get());
        if (recommendedJar == null) {
            ModRef.LOGGER.warn("Invalid pack id {}", GlobalConfigs.packId.get());
            return null;
        }
        return recommendedJar;
    }
}

