/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.BisectOnePlan;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.Currency;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectJarStep;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiSlider;

public class SelectBisectOnePlan
extends ProcessStep {
    private final Supplier<String> perfectPlan = () -> I18n.func_135052_a((String)"step.select_package.plan", (Object[])new Object[0]);
    private final Supplier<String> moveSlider = () -> I18n.func_135052_a((String)"step.select_package.slider", (Object[])new Object[0]);
    private GuiSlider slider;
    private int packageIndex = this.getPackagePlanIndexFromRecommendations();

    public SelectBisectOnePlan(OrderData orderData) {
        super(orderData);
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<IGuiEventListener> children) {
        super.init(screen, children);
        int y = MathHelper.func_76125_a((int)(screen.height / 2 - 10), (int)120, (int)(screen.height - 50));
        this.slider = new GuiSlider(screen.width / 2 - 100, y, 200, 20, "", "", 0.0, (double)(ApiData.BISECT_ONE_PLANS.size() - 1), (double)this.packageIndex, false, false, b -> {}, slider -> {
            this.packageIndex = slider.getValueInt();
        });
        children.accept((IGuiEventListener)new Button(screen.width / 2 - 50, y + 30, 100, 20, I18n.func_135052_a((String)"step.select_package.order_plan", (Object[])new Object[0]), b -> {
            this.orderData.packageId = this.getCurrentPlan().getId();
            this.openOrderUrl();
            screen.getMinecraft().func_147108_a(screen.parent);
        }));
        children.accept((IGuiEventListener)this.slider);
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        BisectOnePlan currentPlan = this.getCurrentPlan();
        font.func_211126_b(this.perfectPlan.get(), (float)(screen.width - font.func_78256_a(this.perfectPlan.get())) / 2.0f, (float)(this.slider.y - 77), 0xFFFFFF);
        String plan = currentPlan.getName();
        font.func_211126_b(plan, (float)(screen.width - font.func_78256_a(plan)) / 2.0f, (float)(this.slider.y - 50), 0xFFFFFF);
        String price = I18n.func_135052_a((String)"step.select_package.price", (Object[])new Object[]{currentPlan.getPrice(Currency.USD)});
        font.func_211126_b(price, (float)(screen.width - font.func_78256_a(price)) / 2.0f, (float)(this.slider.y - 40), 0xFFFFFF);
        font.func_211126_b(this.moveSlider.get(), (float)(screen.width - font.func_78256_a(this.moveSlider.get())) / 2.0f, (float)(this.slider.y - 15), 0xFFFFFF);
    }

    private void openOrderUrl() {
        StringBuilder urlBuilder = new StringBuilder().append("https://bisecthosting.com/modredirect.php").append("?pid=").append(this.orderData.packageId).append("&configoption[2553]=25893").append("&configoption[29]=").append(this.orderData.getJarId()).append("&source=mod");
        String partnerId = (String)GlobalConfigs.partnerId.get();
        if (!partnerId.isEmpty()) {
            urlBuilder.append("&aid=");
            urlBuilder.append(partnerId);
        }
        ModRef.LOGGER.info("Setting up order link " + urlBuilder);
        Util.func_110647_a().func_195640_a(urlBuilder.toString());
    }

    private BisectOnePlan getCurrentPlan() {
        return ApiData.BISECT_ONE_PLANS.get(this.packageIndex);
    }

    private int getPackagePlanIndexFromRecommendations() {
        BisectOnePlan plan;
        int planIndex;
        int recommendedRam = ApiData.RAM_RECOMMENDATIONS.get(this.orderData.getJarId()).getRamForPlayers(this.orderData.playerCount);
        for (planIndex = 0; planIndex < ApiData.BISECT_ONE_PLANS.size() && (plan = ApiData.BISECT_ONE_PLANS.get(planIndex)).getRam() / 1024 < recommendedRam; ++planIndex) {
        }
        return planIndex;
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.setStep(new SelectJarStep(this.orderData));
    }
}

