/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarGroupListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectBisectOnePlan;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.resources.I18n;

public class SelectJarStep
extends ProcessStep {
    private JarGroupListWidget.JarGroupEntry selectedGroup = null;
    private JarListWidget.JarEntry selectedJar = null;
    private final Supplier<String> nameFilter = () -> I18n.func_135052_a((String)"step.select_jar.name_filter", (Object[])new Object[0]);
    private final Supplier<String> platformFilter = () -> I18n.func_135052_a((String)"step.select_jar.platform_filter", (Object[])new Object[0]);
    private final Supplier<String> selectPack = () -> I18n.func_135052_a((String)"step.select_jar.select_pack", (Object[])new Object[0]);
    private JarGroupListWidget jarGroupList;
    private JarListWidget jarList;
    private TextFieldWidget searchBar;
    private Button selectButton;

    public SelectJarStep(OrderData orderData) {
        super(orderData);
        orderData.jar = null;
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<IGuiEventListener> children) {
        int y0 = 80;
        int y1 = screen.height - 80;
        List<JarGroupData> jarGroupIds = ApiData.AVAILABLE_GROUPS.values().stream().sorted().filter(group -> !group.ignore).collect(Collectors.toList());
        this.jarGroupList = new JarGroupListWidget(this, screen.getMinecraft(), screen.width / 3, screen.height, y0 + 44, y1, jarGroupIds);
        this.jarGroupList.setLeftPos(6);
        this.jarList = new JarListWidget(this, screen.getMinecraft(), screen.width - this.jarGroupList.getWidth() - this.jarGroupList.getRight() - 16, screen.height, y0, y1);
        this.jarList.setLeftPos(this.jarGroupList.getRight() + this.jarGroupList.getWidth() + 10);
        this.searchBar = new TextFieldWidget(screen.getMinecraft().field_71466_p, this.jarGroupList.getRight(), this.jarGroupList.getTop() - 43, this.jarGroupList.getWidth(), 15, this.searchBar, "");
        this.searchBar.func_212954_a(s -> this.filterJars());
        this.selectButton = new Button(this.jarList.getRight() + (this.jarList.getWidth() - 150) / 2, this.jarList.getBottom() + 7, 150, 20, I18n.func_135052_a((String)"step.select_jar.select", (Object[])new Object[0]), b -> screen.setStep(new SelectBisectOnePlan(this.orderData)));
        children.accept((IGuiEventListener)this.jarGroupList);
        children.accept((IGuiEventListener)this.jarList);
        children.accept((IGuiEventListener)this.searchBar);
        children.accept((IGuiEventListener)this.selectButton);
        this.filterJars();
        super.init(screen, children);
    }

    @Override
    public void tick(BHOrderScreen screen) {
        this.searchBar.func_146178_a();
        this.jarGroupList.setSelected((AbstractList.AbstractListEntry)this.selectedGroup);
        this.jarList.setSelected((AbstractList.AbstractListEntry)this.selectedJar);
        this.selectButton.active = this.orderData.jar != null;
    }

    public void setSelectedGroup(@Nullable JarGroupListWidget.JarGroupEntry selectedGroup) {
        this.selectedGroup = selectedGroup == this.selectedGroup ? null : selectedGroup;
        this.filterJars();
    }

    public void setSelectedJar(@Nullable JarListWidget.JarEntry selectedJar) {
        this.selectedJar = selectedJar == this.selectedJar ? null : selectedJar;
        this.orderData.jar = this.selectedJar == null ? null : selectedJar.data;
    }

    public void filterJars() {
        this.jarList.setScrollAmount(0.0);
        Stream<JarGroupData.JarData> jarStream = ApiData.AVAILABLE_JARS.values().stream().sorted();
        if (this.selectedGroup != null) {
            jarStream = jarStream.filter(jar -> this.selectedGroup.data.premiumJars.containsKey(jar.premiumJarId));
        }
        if (!this.searchBar.func_146179_b().isEmpty()) {
            jarStream = jarStream.filter(jar -> jar.name.toLowerCase(Locale.ROOT).contains(this.searchBar.func_146179_b().toLowerCase(Locale.ROOT)));
        }
        List<JarGroupData.JarData> jars = jarStream.collect(Collectors.toList());
        this.jarList.buildJarList(jars);
        this.setSelectedJar((JarListWidget.JarEntry)this.jarList.getSelected());
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        this.jarGroupList.render(mouseX, mouseY, partialTicks);
        this.jarList.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderLast(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        super.renderLast(screen, font, mouseX, mouseY, partialTicks);
        font.func_211126_b(this.nameFilter.get(), (float)this.searchBar.x + (float)(this.searchBar.getWidth() - font.func_78256_a(this.nameFilter.get())) / 2.0f, (float)(this.searchBar.y - 15), 0xFFFFFF);
        font.func_211126_b(this.platformFilter.get(), (float)this.jarGroupList.getRight() + (float)(this.jarGroupList.getWidth() - font.func_78256_a(this.platformFilter.get())) / 2.0f, (float)(this.jarGroupList.getTop() - 15), 0xFFFFFF);
        font.func_211126_b(this.selectPack.get(), (float)this.jarList.getRight() + (float)(this.jarList.getWidth() - font.func_78256_a(this.selectPack.get())) / 2.0f, (float)(this.jarList.getTop() - 15), 0xFFFFFF);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        if (!this.searchBar.func_146179_b().isEmpty()) {
            this.searchBar.func_146180_a("");
        } else if (this.selectedGroup != null) {
            this.selectedGroup = null;
        } else {
            screen.setStep(new PlayerCountStep(this.orderData));
        }
    }
}

