/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.config.IConfigurable;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;

public class ModuleConfigList
extends ContainerObjectSelectionList<Entry> {
    private ModuleConfigScreen screen;

    public ModuleConfigList(ModuleConfigScreen screen, Minecraft mc, int width, int height, int y0, int itemHeight) {
        super(mc, width, height, y0, itemHeight);
        this.screen = screen;
    }

    public void saveAll() {
        for (Entry entry : this.children()) {
            entry.save();
        }
    }

    public void populateModuleConfigList(BiConsumer<ModuleConfigList, Consumer<Entry>> populator) {
        populator.accept(this, x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        Entry entry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
        if (mouseX < this.width / 2 && entry != null && !entry.comments.isEmpty()) {
            graphics.renderTooltip(this.minecraft.font, entry.comments, Optional.empty(), mouseX, mouseY);
        }
    }

    public int getRowWidth() {
        return this.width - 40;
    }

    protected int scrollBarX() {
        return this.width - 6;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final ModuleConfigList parent;
        private final List<Component> comments = new ArrayList<Component>();
        private final Component text;
        private final AbstractWidget configButton;
        private final List<AbstractWidget> children;

        public Entry(ModuleConfigList parent, String comments, Component text, AbstractWidget button) {
            this.parent = parent;
            if (!StringUtil.isNullOrEmpty((String)comments)) {
                for (String comment : comments.split("\n")) {
                    this.comments.add((Component)Component.literal((String)comment));
                }
            }
            this.text = text;
            this.configButton = button;
            this.children = Lists.newArrayList((Object[])new AbstractWidget[]{this.configButton});
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.configButton.setX(left + width / 2 + 10);
            this.configButton.setY(top + (innerHeight - this.configButton.getHeight()) / 2);
            this.configButton.setWidth(width / 2 - 10);
            this.configButton.render(graphics, mouseX, mouseY, delta);
            Font font = Minecraft.getInstance().font;
            Objects.requireNonNull(font);
            graphics.drawString(font, this.text, left, top + (innerHeight - 9) / 2, 0xFFFFFF);
        }

        public void save() {
            AbstractWidget abstractWidget = this.configButton;
            if (abstractWidget instanceof IConfigurable) {
                IConfigurable config = (IConfigurable)abstractWidget;
                config.save();
            }
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }
    }
}

