/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.TickBoxButton;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerLoadingScreen;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerSelectionList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class PublicServersScreen
extends Screen {
    private static final Component JOIN_SERVER_TEXT = Component.translatable((String)"selectServer.select");
    private static final Component ADD_SERVER_TEXT = Component.translatable((String)"selectServer.add");
    private static final Component BACK_TEXT = CommonComponents.GUI_BACK;
    private static final Component REFRESH_TEXT = Component.translatable((String)"selectServer.refresh");
    private static final Component TITLE_TEXT = Component.translatable((String)"modules.public_server_list.title");
    private static final Component HOW_TO_TEXT = Component.translatable((String)"modules.public_server_list.how_to");
    private static final Component NAME_FILTER_TEXT = Component.translatable((String)"modules.public_server_list.filter.name");
    private static final Component PING_SORT_TEXT = Component.translatable((String)"modules.public_server_list.sort.ping");
    private static final Component PLAYER_COUNT_SORT_TEXT = Component.translatable((String)"modules.public_server_list.sort.player_count");
    private static final URI HOW_TO_URI = URI.create("https://www.bisecthosting.com/clients/index.php?rp=/knowledgebase/348/How-to-add-a-modpack-server-to-the-public-server-list.html");
    private final ServerStatusPinger pinger = new ServerStatusPinger();
    private PublicServerSelectionList serverSelectionList;
    private ServerListData servers;
    private Button addButton;
    private Button joinButton;
    private Button howTobutton;
    private EditBox searchBar;
    private TickBoxButton pingSort;
    private TickBoxButton playerCountSort;
    public static final float SPLIT = 0.4f;
    private List<Component> tooltip;
    private boolean openedLink;
    public final JoinMultiplayerScreen multiplayerScreen;
    private boolean hasInit;

    public PublicServersScreen(JoinMultiplayerScreen multiplayerScreen, List<ServerData> servers) {
        super(TITLE_TEXT);
        this.multiplayerScreen = multiplayerScreen;
        this.servers = new ServerListData(servers);
    }

    protected void init() {
        int splitWidth = (int)((float)this.width * 0.4f);
        if (this.hasInit) {
            this.serverSelectionList.setWidth(this.width - splitWidth);
            this.serverSelectionList.setHeight(this.height - 40);
            this.serverSelectionList.setY(32);
            this.serverSelectionList.setX(splitWidth);
        } else {
            this.hasInit = true;
            this.serverSelectionList = new PublicServerSelectionList(this, this.minecraft, this.width - splitWidth, this.height - 40, 32, 36);
            this.serverSelectionList.setX(splitWidth);
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.addWidget((GuiEventListener)this.serverSelectionList);
        this.searchBar = new EditBox(this.getMinecraft().font, 10, 52, splitWidth - 20, 20, this.searchBar, (Component)Component.literal((String)""));
        this.searchBar.setResponder(this.serverSelectionList::setNameFilter);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.pingSort = new TickBoxButton(splitWidth - 40, 90, this.pingSort, this.serverSelectionList::togglePingSort);
        this.addRenderableWidget((GuiEventListener)this.pingSort);
        this.playerCountSort = new TickBoxButton(splitWidth - 40, 124, this.playerCountSort, this.serverSelectionList::togglePlayerCountSort);
        this.addRenderableWidget((GuiEventListener)this.playerCountSort);
        int buttonWidth = Math.min(100, splitWidth / 2 - 4);
        Button refreshButton = Button.builder((Component)REFRESH_TEXT, btn -> this.minecraft.setScreen((Screen)new PublicServerLoadingScreen((Screen)this.multiplayerScreen))).pos(splitWidth / 2 - buttonWidth - 2, this.height - 28).width(buttonWidth).build();
        Button backButton = Button.builder((Component)BACK_TEXT, btn -> this.onClose()).pos(splitWidth / 2 + 2, this.height - 28).width(buttonWidth).build();
        this.howTobutton = Button.builder((Component)HOW_TO_TEXT, btn -> this.openHowToPage()).pos(splitWidth / 2 - buttonWidth - 2, this.height - 76).width(buttonWidth * 2 + 4).build();
        this.joinButton = Button.builder((Component)JOIN_SERVER_TEXT, btn -> this.joinSelectedServer()).pos(splitWidth / 2 - buttonWidth - 2, this.height - 52).width(buttonWidth).build();
        this.joinButton.active = false;
        this.addButton = Button.builder((Component)ADD_SERVER_TEXT, btn -> this.addSelectedServer()).pos(splitWidth / 2 + 2, this.height - 52).width(buttonWidth).build();
        this.addButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.howTobutton);
        this.addRenderableWidget((GuiEventListener)refreshButton);
        this.addRenderableWidget((GuiEventListener)backButton);
        this.addRenderableWidget((GuiEventListener)this.addButton);
        this.addRenderableWidget((GuiEventListener)this.joinButton);
    }

    public void tick() {
        super.tick();
        this.pinger.tick();
        this.serverSelectionList.tick();
        if (this.openedLink) {
            this.howTobutton.setFocused(false);
            this.openedLink = false;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.width * 0.4f);
        this.tooltip = null;
        super.render(graphics, mouseX, mouseY, delta);
        this.serverSelectionList.render(graphics, mouseX, mouseY, delta);
        Objects.requireNonNull(this.font);
        float fontHeight = 9.0f;
        graphics.drawCenteredString(this.font, this.getTitle(), this.width / 2, 10, -1);
        if (this.tooltip != null) {
            graphics.renderComponentTooltip(this.font, this.tooltip, mouseX, mouseY);
        }
        graphics.drawCenteredString(this.font, NAME_FILTER_TEXT, splitWidth / 2, 32, -1);
        graphics.drawString(this.font, PING_SORT_TEXT, 20, 90 + (int)((20.0f - fontHeight) / 2.0f), -1);
        graphics.drawString(this.font, PLAYER_COUNT_SORT_TEXT, 20, 124 + (int)((20.0f - fontHeight) / 2.0f), -1);
    }

    public void joinSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            PublicServerSelectionList.ServerEntry serverEntry = (PublicServerSelectionList.ServerEntry)entry;
            this.join(serverEntry);
        }
    }

    public void join(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setLastJoined(entry);
        this.join(entry.getServerData());
    }

    private void join(ServerData server) {
        ConnectScreen.startConnecting((Screen)this, (Minecraft)this.minecraft, (ServerAddress)ServerAddress.parseString((String)server.ip), (ServerData)server, (boolean)false, null);
    }

    public void addSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            PublicServerSelectionList.ServerEntry serverEntry = (PublicServerSelectionList.ServerEntry)entry;
            ServerData data = serverEntry.getServerData();
            this.multiplayerScreen.editingServer = new ServerData(data.name, data.ip, ServerData.Type.OTHER);
            this.minecraft.setScreen((Screen)new EditServerScreen((Screen)this, add -> this.multiplayerScreen.addServerCallback(add), this.multiplayerScreen.editingServer));
        }
    }

    public void openHowToPage() {
        ModRef.LOGGER.info("Opening knowledgebase " + String.valueOf(HOW_TO_URI));
        Util.getPlatform().openUri(HOW_TO_URI);
        this.openedLink = true;
    }

    public void setSelected(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setSelected(entry);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.joinButton.active = false;
        this.addButton.active = false;
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.joinButton.active = true;
            this.addButton.active = true;
        }
    }

    public void removed() {
        this.pinger.removeAll();
        this.serverSelectionList.stopPingingServer();
    }

    public void onClose() {
        if (!this.searchBar.getValue().isEmpty()) {
            this.searchBar.setValue("");
        } else {
            this.minecraft.setScreen((Screen)this.multiplayerScreen);
        }
    }

    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public ServerStatusPinger getPinger() {
        return this.pinger;
    }

    public ServerListData getServers() {
        return this.servers;
    }
}

