/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public class EditBoxComponent
extends class_339 {
    public static final int BACKWARDS = -1;
    public static final int FORWARDS = 1;
    private static final int CURSOR_INSERT_WIDTH = 1;
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    public static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    private static final int BORDER_COLOR_FOCUSED = -1;
    private static final int BORDER_COLOR = -6250336;
    private static final int BACKGROUND_COLOR = -16777216;
    private final class_327 textRenderer;
    private String value = "";
    private int maxLength = Integer.MAX_VALUE;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    private String suggestion;
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> formatter = (p_94147_, p_94148_) -> class_5481.method_30747((String)p_94147_, (class_2583)class_2583.field_24360);
    private class_2561 hint;

    public EditBoxComponent(class_327 textRenderer, int x, int y, int width, int height, class_2561 message) {
        this(textRenderer, x, y, width, height, null, message);
    }

    public EditBoxComponent(class_327 textRenderer, int x, int y, int width, int height, EditBoxComponent copy, class_2561 message) {
        super(x, y, width, height, message);
        this.textRenderer = textRenderer;
        if (copy != null) {
            this.setValue(copy.getValue());
        }
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFormatter(BiFunction<String, Integer, class_5481> formatter) {
        this.formatter = formatter;
    }

    public void tick() {
        ++this.frame;
    }

    protected class_5250 createNarrationMessage() {
        class_2561 component = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            this.value = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    public void insertText(String text) {
        String s1;
        String s;
        int l;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (s = class_3544.method_57180((String)text)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.filter.test(s1 = new StringBuilder(this.value).replace(i, j, s).toString())) {
            this.value = s1;
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String p_94175_) {
        if (this.responder != null) {
            this.responder.accept(p_94175_);
        }
    }

    private void deleteText(int p_94218_) {
        if (class_437.method_25441()) {
            this.deleteWords(p_94218_);
        } else {
            this.deleteChars(p_94218_);
        }
    }

    public void deleteWords(int p_94177_) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(p_94177_) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int p_94181_) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(p_94181_);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(s = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = s;
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int p_94185_) {
        return this.getWordPosition(p_94185_, this.getCursorPosition());
    }

    private int getWordPosition(int p_94129_, int p_94130_) {
        return this.getWordPosition(p_94129_, p_94130_, true);
    }

    private int getWordPosition(int offset, int current, boolean p_94143_) {
        int pos = current;
        boolean isBackwards = offset < 0;
        int distance = Math.abs(offset);
        for (int k = 0; k < distance; ++k) {
            if (!isBackwards) {
                int l = this.value.length();
                if ((pos = this.value.indexOf(32, pos)) == -1) {
                    pos = l;
                    continue;
                }
                while (p_94143_ && pos < l && this.value.charAt(pos) == ' ') {
                    ++pos;
                }
                continue;
            }
            while (p_94143_ && pos > 0 && this.value.charAt(pos - 1) == ' ') {
                --pos;
            }
            while (pos > 0 && this.value.charAt(pos - 1) != ' ') {
                --pos;
            }
        }
        return pos;
    }

    public void moveCursor(int p_94189_) {
        this.moveCursorTo(this.getCursorPos(p_94189_));
    }

    private int getCursorPos(int p_94221_) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)p_94221_);
    }

    public void moveCursorTo(int p_94193_) {
        this.setCursorPosition(p_94193_);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int p_94197_) {
        this.cursorPos = class_3532.method_15340((int)p_94197_, (int)0, (int)this.value.length());
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean method_25404(int p_94132_, int p_94133_, int p_94134_) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25439((int)p_94132_)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (class_437.method_25438((int)p_94132_)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (class_437.method_25437((int)p_94132_)) {
            if (this.isEditable) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)p_94132_)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (p_94132_) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (class_3544.method_57175((char)typedChar)) {
            if (this.isEditable) {
                this.insertText(Character.toString(typedChar));
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean flag;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        if (this.canLoseFocus) {
            this.setFocus(flag);
        }
        if (this.method_25370() && flag && button == 0) {
            int i = class_3532.method_15357((double)mouseX) - this.method_46426();
            if (this.bordered) {
                i -= 4;
            }
            String s = this.textRenderer.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.textRenderer.method_27523(s, i).length() + this.displayPos);
            return true;
        }
        return false;
    }

    public void setFocus(boolean p_94179_) {
        this.method_25365(p_94179_);
    }

    public void method_48579(class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            if (this.isBordered()) {
                int i = this.method_25370() ? -1 : -6250336;
                ctx.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, i);
                ctx.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
            }
            int i2 = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.cursorPos - this.displayPos;
            int k = this.highlightPos - this.displayPos;
            String s = this.textRenderer.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.method_25370() && this.frame / 6 % 2 == 0 && flag;
            int l = this.bordered ? this.method_46426() + 4 : this.method_46426();
            int i1 = this.bordered ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = ctx.method_35720(this.textRenderer, this.formatter.apply(s1, this.displayPos), l, i1, i2);
            }
            boolean flag2 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.field_22758 : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                ctx.method_35720(this.textRenderer, this.formatter.apply(s.substring(j), this.cursorPos), j1, i1, i2);
            }
            if (this.hint != null && s.isEmpty() && !this.method_25370()) {
                ctx.method_27535(this.textRenderer, this.hint, j1, i1, i2);
            }
            if (!flag2 && this.suggestion != null) {
                ctx.method_25303(this.textRenderer, this.suggestion, k1 - 1, i1, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    ctx.method_25294(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    ctx.method_25303(this.textRenderer, CURSOR_APPEND_CHARACTER, k1, i1, i2);
                }
            }
            if (k != j) {
                int l1 = l + this.textRenderer.method_1727(s.substring(0, k));
                this.renderHighlight(ctx, k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void renderHighlight(class_332 ctx, int p_265338_, int p_265693_, int p_265618_, int p_265584_) {
        if (p_265338_ < p_265618_) {
            int i = p_265338_;
            p_265338_ = p_265618_;
            p_265618_ = i;
        }
        if (p_265693_ < p_265584_) {
            int j = p_265693_;
            p_265693_ = p_265584_;
            p_265584_ = j;
        }
        if (p_265618_ > this.method_46426() + this.field_22758) {
            p_265618_ = this.method_46426() + this.field_22758;
        }
        if (p_265338_ > this.method_46426() + this.field_22758) {
            p_265338_ = this.method_46426() + this.field_22758;
        }
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        ctx.method_25294(p_265338_, p_265693_, p_265618_, p_265584_, -16776961);
        RenderSystem.disableColorLogicOp();
    }

    public void setMaxLength(int p_94200_) {
        this.maxLength = p_94200_;
        if (this.value.length() > p_94200_) {
            this.value = this.value.substring(0, p_94200_);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean p_94183_) {
        this.bordered = p_94183_;
    }

    public void setTextColor(int p_94203_) {
        this.textColor = p_94203_;
    }

    public void setTextColorUneditable(int p_94206_) {
        this.textColorUneditable = p_94206_;
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        return this.field_22764 && this.isEditable ? super.method_48205(navigation) : null;
    }

    public boolean method_25405(double p_94157_, double p_94158_) {
        return this.field_22764 && p_94157_ >= (double)this.method_46426() && p_94157_ < (double)(this.method_46426() + this.field_22758) && p_94158_ >= (double)this.method_46427() && p_94158_ < (double)(this.method_46427() + this.field_22759);
    }

    protected void onFocusedChanged(boolean p_94170_) {
        if (p_94170_) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean p_94187_) {
        this.isEditable = p_94187_;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setHighlightPos(int p_94209_) {
        int i = this.value.length();
        this.highlightPos = class_3532.method_15340((int)p_94209_, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.getInnerWidth();
            String s = this.textRenderer.method_27523(this.value.substring(this.displayPos), j);
            int k = s.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.textRenderer.method_27524(this.value, j, true).length();
            }
            if (this.highlightPos > k) {
                this.displayPos += this.highlightPos - k;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)i);
        }
    }

    public void setCanLoseFocus(boolean p_94191_) {
        this.canLoseFocus = p_94191_;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean p_94195_) {
        this.field_22764 = p_94195_;
    }

    public void setSuggestion(@Nullable String p_94168_) {
        this.suggestion = p_94168_;
    }

    public int getScreenX(int p_94212_) {
        return p_94212_ > this.value.length() ? this.method_46426() : this.method_46426() + this.textRenderer.method_1727(this.value.substring(0, p_94212_));
    }

    protected void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.createNarrationMessage());
    }

    public void setHint(class_2561 hint) {
        this.hint = hint;
    }
}

