/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.bhdata.OrderData;
import com.bisecthosting.mods.bhmenu.bhdata.api.ApiData;
import com.bisecthosting.mods.bhmenu.bhdata.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarGroupListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectBisectOnePlan;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class SelectJarStep
extends ProcessStep {
    private JarGroupListWidget.JarGroupEntry selectedGroup = null;
    private JarListWidget.JarEntry selectedJar = null;
    private static final Supplier<String> NAME_FILTER = () -> class_1074.method_4662((String)"step.select_jar.name_filter", (Object[])new Object[0]);
    private static final Supplier<String> PLATFORM_FILTER = () -> class_1074.method_4662((String)"step.select_jar.platform_filter", (Object[])new Object[0]);
    private static final Supplier<String> SELECT_PACK = () -> class_1074.method_4662((String)"step.select_jar.select_pack", (Object[])new Object[0]);
    private JarGroupListWidget jarGroupList;
    private JarListWidget jarList;
    private class_342 searchBar;
    private class_4185 selectButton;

    public SelectJarStep(OrderData orderData) {
        super(orderData);
        orderData.jar = null;
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<class_364> children) {
        int y0 = 80;
        int y1 = screen.height - 80;
        List<JarGroupData> jarGroupIds = ApiData.AVAILABLE_GROUPS.values().stream().sorted().filter(group -> !group.ignore).collect(Collectors.toList());
        this.jarGroupList = new JarGroupListWidget(this, screen.getMinecraft(), screen.width / 3, screen.height, y0 + 44, y1, jarGroupIds);
        this.jarGroupList.setLeftPos(6);
        this.jarList = new JarListWidget(this, screen.getMinecraft(), screen.width - this.jarGroupList.getRowWidth() - this.jarGroupList.getRowLeft() - 16, screen.height, y0, y1);
        this.jarList.setLeftPos(this.jarGroupList.getRowLeft() + this.jarGroupList.getRowWidth() + 10);
        this.searchBar = new class_342(screen.getMinecraft().field_1772, this.jarGroupList.getRowLeft(), this.jarGroupList.getTop() - 43, this.jarGroupList.getRowWidth(), 15, this.searchBar, "");
        this.searchBar.method_1863(s -> this.filterJars());
        this.selectButton = new class_4185(this.jarList.getRowLeft() + (this.jarList.getRowWidth() - 150) / 2, this.jarList.getBottom() + 7, 150, 20, class_1074.method_4662((String)"step.select_jar.select", (Object[])new Object[0]), b -> screen.setStep(new SelectBisectOnePlan(this.orderData)));
        children.accept((class_364)this.jarGroupList);
        children.accept((class_364)this.jarList);
        children.accept((class_364)this.searchBar);
        children.accept((class_364)this.selectButton);
        this.filterJars();
        super.init(screen, children);
    }

    @Override
    public void tick(BHOrderScreen screen) {
        this.searchBar.method_1865();
        this.jarGroupList.setSelected((class_350.class_351)this.selectedGroup);
        this.jarList.setSelected((class_350.class_351)this.selectedJar);
        this.selectButton.active = this.orderData.jar != null;
    }

    public void setSelectedGroup(@Nullable JarGroupListWidget.JarGroupEntry selectedGroup) {
        this.selectedGroup = selectedGroup == this.selectedGroup ? null : selectedGroup;
        this.filterJars();
    }

    public void setSelectedJar(@Nullable JarListWidget.JarEntry selectedJar) {
        this.selectedJar = selectedJar == this.selectedJar ? null : selectedJar;
        this.orderData.jar = this.selectedJar == null ? null : selectedJar.data;
    }

    public void filterJars() {
        this.jarList.setScrollAmount(0.0);
        Stream<JarGroupData.JarData> jarStream = ApiData.AVAILABLE_JARS.values().stream().sorted();
        if (this.selectedGroup != null) {
            jarStream = jarStream.filter(jar -> this.selectedGroup.data.premiumJars.containsKey(jar.premiumJarId));
        }
        if (!this.searchBar.method_1882().isEmpty()) {
            jarStream = jarStream.filter(jar -> jar.name.toLowerCase(Locale.ROOT).contains(this.searchBar.method_1882().toLowerCase(Locale.ROOT)));
        }
        List<JarGroupData.JarData> jars = jarStream.collect(Collectors.toList());
        this.jarList.buildJarList(jars);
        this.setSelectedJar((JarListWidget.JarEntry)this.jarList.getSelected());
    }

    @Override
    public void render(BHOrderScreen screen, class_327 font, int mouseX, int mouseY, float partialTicks) {
        this.jarGroupList.render(mouseX, mouseY, partialTicks);
        this.jarList.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderLast(BHOrderScreen screen, class_327 font, int mouseX, int mouseY, float partialTicks) {
        super.renderLast(screen, font, mouseX, mouseY, partialTicks);
        font.method_1729(NAME_FILTER.get(), (float)this.searchBar.x + (float)(this.searchBar.getWidth() - font.method_1727(NAME_FILTER.get())) / 2.0f, (float)(this.searchBar.y - 15), 0xFFFFFF);
        font.method_1729(PLATFORM_FILTER.get(), (float)this.jarGroupList.getRowLeft() + (float)(this.jarGroupList.getRowWidth() - font.method_1727(PLATFORM_FILTER.get())) / 2.0f, (float)(this.jarGroupList.getTop() - 15), 0xFFFFFF);
        font.method_1729(SELECT_PACK.get(), (float)this.jarList.getRowLeft() + (float)(this.jarList.getRowWidth() - font.method_1727(SELECT_PACK.get())) / 2.0f, this.jarList.getTop() - 15.0f, 0xFFFFFF);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        if (!this.searchBar.method_1882().isEmpty()) {
            this.searchBar.method_1852("");
        } else if (this.selectedGroup != null) {
            this.selectedGroup = null;
        } else {
            screen.setStep(new PlayerCountStep(this.orderData));
        }
    }
}

