/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.screen.config;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.bisecthosting.mods.bhmenu.screen.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.screen.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.screen.config.lists.ModuleSelectionList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class PackConfigScreen
extends class_437 {
    private static final Supplier<String> MOD_TEXT = () -> class_1074.method_4662((String)"screen.config.mod", (Object[])new Object[0]);
    private static final Supplier<String> CLOSE_TEXT = () -> class_1074.method_4662((String)"screen.config.close", (Object[])new Object[0]);
    private static final Supplier<String> FEATURES_TEXT = () -> class_1074.method_4662((String)"screen.config.features", (Object[])new Object[0]);
    private static final Supplier<String> PACK_ID_TEXT = () -> class_1074.method_4662((String)"config.pack_id", (Object[])new Object[0]);
    private static final Supplier<String> PARTNER_ID_TEXT = () -> class_1074.method_4662((String)"config.partner_id", (Object[])new Object[0]);
    private static final Supplier<String> PACK_EDIT_MODE_TEXT = () -> class_1074.method_4662((String)"config.pack_edit_mode", (Object[])new Object[0]);
    public static final float SPLIT = 0.3f;
    private class_437 parent;
    private ModuleSelectionList moduleSelectionList;
    private TextConfigEditBox packIdEditBox;
    private TextConfigEditBox partnerIdEditBox;
    private TickBoxConfigComponent enableConfigScreenTickButton;
    public static boolean hasChanged;

    public PackConfigScreen(class_437 parent) {
        super((class_2561)new class_2588("screen.config.pack.title", new Object[0]));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int splitWidth = (int)((float)this.width * 0.3f);
        this.moduleSelectionList = new ModuleSelectionList(this, this.minecraft, this.width - splitWidth, this.height, 45, this.height - 8, 30);
        for (IModule module : ModRoot.INSTANCE.modules.getAll()) {
            this.moduleSelectionList.addPackEntry(module);
        }
        this.moduleSelectionList.setLeftPos(splitWidth);
        this.children.add(this.moduleSelectionList);
        GlobalConfigs configs = ModRoot.INSTANCE.configs;
        int boxWidth = 100;
        this.packIdEditBox = new TextConfigEditBox(configs.packId, this.font, (splitWidth - boxWidth) / 2, 75, boxWidth, 20, "");
        this.addButton(this.packIdEditBox);
        this.partnerIdEditBox = new TextConfigEditBox(configs.partnerId, this.font, (splitWidth - boxWidth) / 2, 125, boxWidth, 20, "");
        this.addButton(this.partnerIdEditBox);
        this.partnerIdEditBox.setCanLoseFocus(true);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        this.enableConfigScreenTickButton = new TickBoxConfigComponent(configs.packEditMode, splitWidth / 2 - 10, this.height - 55, 20, 20, b -> {});
        this.addButton((class_339)this.enableConfigScreenTickButton);
        class_4185 closeButton = new class_4185((splitWidth - buttonWidth) / 2, this.height - 28, buttonWidth, 20, CLOSE_TEXT.get(), btn -> this.onClose());
        this.addButton((class_339)closeButton);
        this.children.add(this.moduleSelectionList);
    }

    public void render(int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.width * 0.3f);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        this.renderBackground();
        this.moduleSelectionList.render(mouseX, mouseY, delta);
        super.render(mouseX, mouseY, delta);
        this.drawCenteredString(this.font, MOD_TEXT.get(), this.width / 2, 10, 0xFFFFFF);
        this.drawCenteredString(this.font, FEATURES_TEXT.get(), (this.width + splitWidth) / 2, 30, 0xFFFFFF);
        this.drawCenteredString(this.font, PACK_ID_TEXT.get(), splitWidth / 2, 60, 0xFFFFFF);
        this.drawCenteredString(this.font, PARTNER_ID_TEXT.get(), splitWidth / 2, 110, 0xFFFFFF);
        int n = splitWidth / 2;
        Objects.requireNonNull(this.font);
        this.drawCenteredString(this.font, PACK_EDIT_MODE_TEXT.get(), n, this.height - 57 - 9, 0xFFFFFF);
    }

    public void onClose() {
        this.packIdEditBox.save();
        this.partnerIdEditBox.save();
        this.enableConfigScreenTickButton.save();
        this.moduleSelectionList.saveAll();
        if (hasChanged) {
            ModRoot.INSTANCE.configs.save();
            ModRoot.INSTANCE.modules.reload();
            hasChanged = false;
        }
        this.minecraft.method_1507(this.parent);
    }
}

