/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.bisecthosting.mods.bhmenu.config.components.ConfigButtonComponent;
import com.bisecthosting.mods.bhmenu.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModuleSelectionList
extends ContainerObjectSelectionList<Entry> {
    public ModuleSelectionList(Minecraft mc, int width, int height, int y0, int itemHeight) {
        super(mc, width, height, y0, itemHeight);
    }

    public int addEntry(Entry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void saveAll() {
        for (Entry entry : this.children()) {
            entry.save();
        }
    }

    protected int getScrollbarPosition() {
        return this.getX() - 6;
    }

    public int getRowWidth() {
        return Math.min(this.width - 40, 260);
    }

    protected int getDefaultScrollbarPosition() {
        return this.getRight() - 4;
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public abstract void save();
    }

    public static class UserEntry
    extends Entry {
        private final AbstractWidget configButton;
        private final List<AbstractWidget> children;

        public UserEntry(IModule module) {
            this.configButton = Button.builder((Component)Component.translatable((String)("screen.config.modules." + module.getId() + ".name")), btn -> Minecraft.getInstance().pushGuiLayer((Screen)new ModuleConfigScreen(module, module::populateUserConfigs))).width(0).build();
            if (!module.hasUserConfigs()) {
                this.configButton.active = false;
            }
            this.children = Lists.newArrayList((Object[])new AbstractWidget[]{this.configButton});
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.configButton.setX(left);
            this.configButton.setWidth(width);
            this.configButton.setY(top);
            this.configButton.render(graphics, mouseX, mouseY, delta);
        }

        @Override
        public void save() {
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }
    }

    public static class PackEntry
    extends Entry {
        private final IModule module;
        private final ConfigButtonComponent toggle;
        private final AbstractWidget configButton;
        private final List<AbstractWidget> children;

        public PackEntry(IModule module) {
            this.module = module;
            this.toggle = new TickBoxConfigComponent(new BooleanHolder(ModRoot.get().modules.getEnabledValue(module.getId())), 0, 0, 20, 20);
            this.configButton = Button.builder((Component)Component.translatable((String)("screen.config.modules." + module.getId() + ".name")), btn -> Minecraft.getInstance().pushGuiLayer((Screen)new ModuleConfigScreen(module, module::populatePackConfigs))).width(0).build();
            if (!module.hasPackConfigs()) {
                this.configButton.active = false;
            }
            this.children = Lists.newArrayList((Object[])new AbstractWidget[]{this.toggle, this.configButton});
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.toggle.setX(left);
            this.configButton.setX(left + 30);
            this.configButton.setWidth(width - 30);
            this.children.forEach(child -> {
                child.setY(top);
                child.render(graphics, mouseX, mouseY, delta);
            });
        }

        @Override
        public void save() {
            this.toggle.save();
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }
    }
}

