/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens;

import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectJarStep;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class JarListWidget
extends ObjectSelectionList<JarEntry> {
    private final SelectJarStep parent;
    private List<JarGroupData.JarData> jars;

    public JarListWidget(SelectJarStep parent, Minecraft mc, int width, int height, int top) {
        Objects.requireNonNull(mc.font);
        super(mc, width, height, top, 9 * 2 + 8);
        this.parent = parent;
    }

    protected int getDefaultScrollbarPosition() {
        return this.getRight() - 4;
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 6;
    }

    public void buildJarList(List<JarGroupData.JarData> jars) {
        JarEntry lastEntry = (JarEntry)this.getSelected();
        this.clearEntries();
        this.jars = jars;
        for (JarGroupData.JarData jar : this.jars) {
            JarEntry newEntry = new JarEntry(this.minecraft, jar);
            this.addEntry((AbstractSelectionList.Entry)newEntry);
            if (lastEntry == null || lastEntry.data != newEntry.data) continue;
            this.setSelected((AbstractSelectionList.Entry)newEntry);
        }
    }

    public class JarEntry
    extends ObjectSelectionList.Entry<JarEntry> {
        private final Minecraft mc;
        public final JarGroupData.JarData data;

        public JarEntry(Minecraft mc, JarGroupData.JarData data) {
            this.mc = mc;
            this.data = data;
        }

        public void render(GuiGraphics graphics, int entry, int top, int left, int width, int unused, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = this.mc.font;
            String string = this.data.name;
            int n = left + (width - font.width(this.data.name)) / 2;
            int n2 = JarListWidget.this.itemHeight;
            Objects.requireNonNull(font);
            graphics.drawString(font, string, n, top + (n2 - 9) / 2 - 2, 0xFFFFFF);
        }

        public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
            JarListWidget.this.parent.setSelectedJar(this);
            JarListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public Component getNarration() {
            return Component.literal((String)this.data.name);
        }
    }
}

