/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.bhdata.api.ApiData;
import com.bisecthosting.mods.bhmenu.bhdata.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.config.Config;
import com.bisecthosting.mods.bhmenu.config.values.BooleanValue;
import com.bisecthosting.mods.bhmenu.config.values.StringValue;
import com.bisecthosting.mods.bhmenu.modules.BaseModule;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHMultiplayerScreen;
import com.bisecthosting.mods.bhmenu.screen.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.screen.config.components.toggle.BooleanConfigButton;
import com.bisecthosting.mods.bhmenu.screen.config.lists.ModuleConfigList;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCreatorBanner
extends BaseModule {
    public static final Logger LOGGER = LogManager.getLogger();
    public StringValue title;
    public StringValue description;
    public BooleanValue useLanguageFiles;

    public ServerCreatorBanner() {
        super("server_creator_banner");
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!this.isEnabled()) {
                return;
            }
            if (screen != null && screen.getClass() == class_500.class) {
                class_310.method_1551().method_1507((class_437)new BHMultiplayerScreen((class_437)new class_442()));
            }
        });
    }

    @Override
    public void buildConfigs(Config config) {
        config.getComments().append("Server Creator Banner Configs").append("\n");
        this.title = config.defineString("title", "Need a server?", "The title to display at the top of the entry.");
        this.description = config.defineString("description", "Click me to get your own server!", "The description to display below the title.");
        this.useLanguageFiles = config.defineBoolean("use_language_files", false, "Set this to true to use specific language translation keys.", "This requires a custom mod that adds resource files, such as OpenLoader.", "Use 'server_entry.title' key for the Title;", "Use 'server_entry.description' key for the Description.");
    }

    @Override
    public boolean hasPackConfigs() {
        return true;
    }

    @Override
    public void populatePackConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
        class_310 client = class_310.method_1551();
        class_2588 text = new class_2588("modules.server_creator_banner.config.title");
        entries.accept(new ModuleConfigList.Entry(configs, this.title.getComments(), (class_2561)text, new TextConfigEditBox(this.title, client.field_1772, 0, 0, 150, 20, (class_2561)text)));
        text = new class_2588("modules.server_creator_banner.config.description");
        entries.accept(new ModuleConfigList.Entry(configs, this.description.getComments(), (class_2561)text, new TextConfigEditBox(this.description, client.field_1772, 0, 0, 150, 20, (class_2561)text)));
        text = new class_2588("modules.server_creator_banner.config.use_language_files");
        entries.accept(new ModuleConfigList.Entry(configs, this.useLanguageFiles.getComments(), (class_2561)text, (class_339)new BooleanConfigButton(this.useLanguageFiles, 0, 0, 150, 20)));
    }

    public class_2561 getTitle() {
        return (Boolean)this.useLanguageFiles.getValue() != false ? new class_2588("server_entry.title") : new class_2585((String)this.title.getValue());
    }

    public class_2561 getDescription() {
        return (Boolean)this.useLanguageFiles.getValue() != false ? new class_2588("server_entry.description") : new class_2585((String)this.description.getValue());
    }

    public JarGroupData.JarData getRecommendedJarData() {
        String packId = (String)ModRoot.INSTANCE.configs.packId.getValue();
        if (packId.isEmpty()) {
            return null;
        }
        JarGroupData.JarData recommendedJar = ApiData.AVAILABLE_JARS.get(packId);
        if (recommendedJar == null) {
            ModRef.LOGGER.warn("Invalid pack id {}", (Object)packId);
            return null;
        }
        return recommendedJar;
    }
}

