/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

public class EditBoxComponent
extends class_339 {
    public static final int BACKWARDS = -1;
    public static final int FORWARDS = 1;
    private static final int CURSOR_INSERT_WIDTH = 1;
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    public static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    private static final int BORDER_COLOR_FOCUSED = -1;
    private static final int BORDER_COLOR = -6250336;
    private static final int BACKGROUND_COLOR = -16777216;
    private final class_327 textRenderer;
    private String value = "";
    private int maxLength = Integer.MAX_VALUE;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> formatter = (p_94147_, p_94148_) -> class_5481.method_30747((String)p_94147_, (class_2583)class_2583.field_24360);
    @Nullable
    private class_2561 hint;

    public EditBoxComponent(class_327 textRenderer, int x, int y, int width, int height, class_2561 message) {
        this(textRenderer, x, y, width, height, null, message);
    }

    public EditBoxComponent(class_327 textRenderer, int x, int y, int width, int height, @Nullable EditBoxComponent copy, class_2561 message) {
        super(x, y, width, height, message);
        this.textRenderer = textRenderer;
        if (copy != null) {
            this.setValue(copy.getValue());
        }
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFormatter(BiFunction<String, Integer, class_5481> formatter) {
        this.formatter = formatter;
    }

    public void tick() {
        ++this.frame;
    }

    protected class_5250 createNarrationMessage() {
        class_2561 component = this.method_25369();
        return new class_2588("gui.narrate.editBox", new Object[]{component, this.value});
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            this.value = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    public void insertText(String text) {
        String s1;
        String s;
        int l;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (s = class_155.method_644((String)text)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.filter.test(s1 = new StringBuilder(this.value).replace(i, j, s).toString())) {
            this.value = s1;
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String p_94175_) {
        if (this.responder != null) {
            this.responder.accept(p_94175_);
        }
    }

    private void deleteText(int p_94218_) {
        if (class_437.method_25441()) {
            this.deleteWords(p_94218_);
        } else {
            this.deleteChars(p_94218_);
        }
    }

    public void deleteWords(int p_94177_) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(p_94177_) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int p_94181_) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(p_94181_);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(s = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = s;
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int p_94185_) {
        return this.getWordPosition(p_94185_, this.getCursorPosition());
    }

    private int getWordPosition(int p_94129_, int p_94130_) {
        return this.getWordPosition(p_94129_, p_94130_, true);
    }

    private int getWordPosition(int p_94141_, int p_94142_, boolean p_94143_) {
        int i = p_94142_;
        boolean flag = p_94141_ < 0;
        int j = Math.abs(p_94141_);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.value.length();
                if ((i = this.value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (p_94143_ && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (p_94143_ && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int p_94189_) {
        this.moveCursorTo(this.getCursorPos(p_94189_));
    }

    private int getCursorPos(int p_94221_) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)p_94221_);
    }

    public void moveCursorTo(int p_94193_) {
        this.setCursorPosition(p_94193_);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int p_94197_) {
        this.cursorPos = class_3532.method_15340((int)p_94197_, (int)0, (int)this.value.length());
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean method_25404(int p_94132_, int p_94133_, int p_94134_) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25439((int)p_94132_)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (class_437.method_25438((int)p_94132_)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (class_437.method_25437((int)p_94132_)) {
            if (this.isEditable) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)p_94132_)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (p_94132_) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (class_155.method_643((char)typedChar)) {
            if (this.isEditable) {
                this.insertText(Character.toString(typedChar));
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean flag;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
        if (this.canLoseFocus) {
            this.setFocus(flag);
        }
        if (this.method_25370() && flag && button == 0) {
            int i = class_3532.method_15357((double)mouseX) - this.field_22760;
            if (this.bordered) {
                i -= 4;
            }
            String s = this.textRenderer.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.textRenderer.method_27523(s, i).length() + this.displayPos);
            return true;
        }
        return false;
    }

    public void setFocus(boolean p_94179_) {
        this.method_25365(p_94179_);
    }

    public void method_25359(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            if (this.isBordered()) {
                int i = this.method_25370() ? -1 : -6250336;
                EditBoxComponent.method_25294((class_4587)matrix, (int)(this.field_22760 - 1), (int)(this.field_22761 - 1), (int)(this.field_22760 + this.field_22758 + 1), (int)(this.field_22761 + this.field_22759 + 1), (int)i);
                EditBoxComponent.method_25294((class_4587)matrix, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)-16777216);
            }
            int i2 = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.cursorPos - this.displayPos;
            int k = this.highlightPos - this.displayPos;
            String s = this.textRenderer.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.method_25370() && this.frame / 6 % 2 == 0 && flag;
            int l = this.bordered ? this.field_22760 + 4 : this.field_22760;
            int i1 = this.bordered ? this.field_22761 + (this.field_22759 - 8) / 2 : this.field_22761;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.textRenderer.method_27517(matrix, this.formatter.apply(s1, this.displayPos), (float)l, (float)i1, i2);
            }
            boolean flag2 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.field_22758 : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                this.textRenderer.method_27517(matrix, this.formatter.apply(s.substring(j), this.cursorPos), (float)j1, (float)i1, i2);
            }
            if (this.hint != null && s.isEmpty() && !this.method_25370()) {
                this.textRenderer.method_30881(matrix, this.hint, (float)j1, (float)i1, i2);
            }
            if (!flag2 && this.suggestion != null) {
                this.textRenderer.method_1720(matrix, this.suggestion, (float)(k1 - 1), (float)i1, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    EditBoxComponent.method_25294((class_4587)matrix, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
                } else {
                    this.textRenderer.method_1720(matrix, CURSOR_APPEND_CHARACTER, (float)k1, (float)i1, i2);
                }
            }
            if (k != j) {
                int l1 = l + this.textRenderer.method_1727(s.substring(0, k));
                this.renderHighlight(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void renderHighlight(int p_94136_, int p_94137_, int p_94138_, int p_94139_) {
        if (p_94136_ < p_94138_) {
            int i = p_94136_;
            p_94136_ = p_94138_;
            p_94138_ = i;
        }
        if (p_94137_ < p_94139_) {
            int j = p_94137_;
            p_94137_ = p_94139_;
            p_94139_ = j;
        }
        if (p_94138_ > this.field_22760 + this.field_22758) {
            p_94138_ = this.field_22760 + this.field_22758;
        }
        if (p_94136_ > this.field_22760 + this.field_22758) {
            p_94136_ = this.field_22760 + this.field_22758;
        }
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferbuilder.method_22912((double)p_94136_, (double)p_94139_, 0.0).method_1344();
        bufferbuilder.method_22912((double)p_94138_, (double)p_94139_, 0.0).method_1344();
        bufferbuilder.method_22912((double)p_94138_, (double)p_94137_, 0.0).method_1344();
        bufferbuilder.method_22912((double)p_94136_, (double)p_94137_, 0.0).method_1344();
        tesselator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void setMaxLength(int p_94200_) {
        this.maxLength = p_94200_;
        if (this.value.length() > p_94200_) {
            this.value = this.value.substring(0, p_94200_);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean p_94183_) {
        this.bordered = p_94183_;
    }

    public void setTextColor(int p_94203_) {
        this.textColor = p_94203_;
    }

    public void setTextColorUneditable(int p_94206_) {
        this.textColorUneditable = p_94206_;
    }

    public boolean method_25407(boolean p_94172_) {
        return this.field_22764 && this.isEditable ? super.method_25407(p_94172_) : false;
    }

    public boolean method_25405(double p_94157_, double p_94158_) {
        return this.field_22764 && p_94157_ >= (double)this.field_22760 && p_94157_ < (double)(this.field_22760 + this.field_22758) && p_94158_ >= (double)this.field_22761 && p_94158_ < (double)(this.field_22761 + this.field_22759);
    }

    protected void method_25363(boolean p_94170_) {
        if (p_94170_) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean p_94187_) {
        this.isEditable = p_94187_;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setHighlightPos(int p_94209_) {
        int i = this.value.length();
        this.highlightPos = class_3532.method_15340((int)p_94209_, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.getInnerWidth();
            String s = this.textRenderer.method_27523(this.value.substring(this.displayPos), j);
            int k = s.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.textRenderer.method_27524(this.value, j, true).length();
            }
            if (this.highlightPos > k) {
                this.displayPos += this.highlightPos - k;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)i);
        }
    }

    public void setCanLoseFocus(boolean p_94191_) {
        this.canLoseFocus = p_94191_;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean p_94195_) {
        this.field_22764 = p_94195_;
    }

    public void setSuggestion(@Nullable String p_94168_) {
        this.suggestion = p_94168_;
    }

    public int getScreenX(int p_94212_) {
        return p_94212_ > this.value.length() ? this.field_22760 : this.field_22760 + this.textRenderer.method_1727(this.value.substring(0, p_94212_));
    }

    public void setHint(class_2561 hint) {
        this.hint = hint;
    }

    public void method_37020(class_6382 builder) {
    }
}

