/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarGroupListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.JarListWidget;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectBisectOnePlan;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SelectJarStep
extends ProcessStep {
    private JarGroupListWidget.JarGroupEntry selectedGroup = null;
    private JarListWidget.JarEntry selectedJar = null;
    private final Component nameFilter = Component.m_237115_((String)"step.select_jar.name_filter");
    private final Component platformFilter = Component.m_237115_((String)"step.select_jar.platform_filter");
    private final Component selectPack = Component.m_237115_((String)"step.select_jar.select_pack");
    private JarGroupListWidget jarGroupList;
    private JarListWidget jarList;
    private EditBox searchBar;
    private Button selectButton;

    public SelectJarStep(OrderData orderData) {
        super(orderData);
        orderData.jar = null;
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiEventListener> children) {
        int y0 = 80;
        int y1 = screen.f_96544_ - 80;
        List<JarGroupData> jarGroupIds = ApiData.AVAILABLE_GROUPS.values().stream().sorted().filter(group -> !group.ignore).collect(Collectors.toList());
        this.jarGroupList = new JarGroupListWidget(this, screen.getMinecraft(), screen.f_96543_ / 3, screen.f_96544_, y0 + 44, y1, jarGroupIds);
        this.jarGroupList.m_93507_(6);
        this.jarList = new JarListWidget(this, screen.getMinecraft(), screen.f_96543_ - this.jarGroupList.getWidth() - this.jarGroupList.getLeft() - 16, screen.f_96544_, y0, y1);
        this.jarList.m_93507_(this.jarGroupList.getLeft() + this.jarGroupList.getWidth() + 10);
        this.searchBar = new EditBox(screen.getMinecraft().f_91062_, this.jarGroupList.getLeft(), this.jarGroupList.getTop() - 43, this.jarGroupList.getWidth(), 15, this.searchBar, (Component)Component.m_237113_((String)""));
        this.searchBar.m_94151_(s -> this.filterJars());
        this.selectButton = new Button(this.jarList.getLeft() + (this.jarList.getWidth() - 150) / 2, this.jarList.getBottom() + 7, 150, 20, (Component)Component.m_237115_((String)"step.select_jar.select"), b -> screen.setStep(new SelectBisectOnePlan(this.orderData)));
        children.accept((GuiEventListener)this.jarGroupList);
        children.accept((GuiEventListener)this.jarList);
        children.accept((GuiEventListener)this.searchBar);
        children.accept((GuiEventListener)this.selectButton);
        this.filterJars();
        super.init(screen, children);
    }

    @Override
    public void tick(BHOrderScreen screen) {
        this.searchBar.m_94120_();
        this.jarGroupList.m_6987_((AbstractSelectionList.Entry)this.selectedGroup);
        this.jarList.m_6987_((AbstractSelectionList.Entry)this.selectedJar);
        this.selectButton.f_93623_ = this.orderData.jar != null;
    }

    public void setSelectedGroup(@Nullable JarGroupListWidget.JarGroupEntry selectedGroup) {
        this.selectedGroup = selectedGroup == this.selectedGroup ? null : selectedGroup;
        this.filterJars();
    }

    public void setSelectedJar(@Nullable JarListWidget.JarEntry selectedJar) {
        this.selectedJar = selectedJar == this.selectedJar ? null : selectedJar;
        this.orderData.jar = this.selectedJar == null ? null : selectedJar.data;
    }

    public void filterJars() {
        this.jarList.m_93410_(0.0);
        Stream<JarGroupData.JarData> jarStream = ApiData.AVAILABLE_JARS.values().stream().sorted();
        if (this.selectedGroup != null) {
            jarStream = jarStream.filter(jar -> this.selectedGroup.data.premiumJars.containsKey(jar.premiumJarId));
        }
        if (!this.searchBar.m_94155_().isEmpty()) {
            jarStream = jarStream.filter(jar -> jar.name.toLowerCase(Locale.ROOT).contains(this.searchBar.m_94155_().toLowerCase(Locale.ROOT)));
        }
        List<JarGroupData.JarData> jars = jarStream.collect(Collectors.toList());
        this.jarList.buildJarList(jars);
        this.setSelectedJar((JarListWidget.JarEntry)this.jarList.m_93511_());
    }

    @Override
    public void renderLast(BHOrderScreen screen, Font font, PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.renderLast(screen, font, ms, mouseX, mouseY, partialTicks);
        font.m_92889_(ms, this.nameFilter, (float)this.searchBar.f_93620_ + (float)(this.searchBar.m_5711_() - font.m_92852_((FormattedText)this.nameFilter)) / 2.0f, (float)(this.searchBar.f_93621_ - 15), 0xFFFFFF);
        font.m_92889_(ms, this.platformFilter, (float)this.jarGroupList.getLeft() + (float)(this.jarGroupList.getWidth() - font.m_92852_((FormattedText)this.platformFilter)) / 2.0f, (float)(this.jarGroupList.getTop() - 15), 0xFFFFFF);
        font.m_92889_(ms, this.selectPack, (float)this.jarList.getLeft() + (float)(this.jarList.getWidth() - font.m_92852_((FormattedText)this.selectPack)) / 2.0f, (float)(this.jarList.getTop() - 15), 0xFFFFFF);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        if (!this.searchBar.m_94155_().isEmpty()) {
            this.searchBar.m_94144_("");
        } else if (this.selectedGroup != null) {
            this.selectedGroup = null;
        } else {
            screen.setStep(new PlayerCountStep(this.orderData));
        }
    }
}

