/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Util;

public class PageNumberWidget
extends AbstractWidget {
    private final Font font;
    private final Consumer<Integer> onPageChange;
    private final int anchorX;
    private Component text;
    private Component hoverText;
    private Component beforeCursor;
    private Component afterCursor;
    public long lastSwitchFocusTime;
    private String input;

    public PageNumberWidget(Consumer<Integer> onPageChange, int x, int y, Font font) {
        Objects.requireNonNull(font);
        super(x, y, 0, 9, (Component)Component.empty());
        this.lastSwitchFocusTime = Util.getMillis();
        this.input = "";
        this.onPageChange = onPageChange;
        this.anchorX = x;
        this.font = font;
        this.text = Component.empty();
        this.hoverText = Component.empty();
        this.beforeCursor = Component.empty();
        this.afterCursor = Component.empty();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
        if (this.isFocused()) {
            int x = this.getX() + this.width;
            graphics.drawString(this.font, this.afterCursor, x -= this.font.width((FormattedText)this.afterCursor), this.getY(), -16777216, false);
            int cursorX = x;
            graphics.drawString(this.font, this.input, x -= this.font.width(this.input), this.getY(), -16777216, false);
            graphics.drawString(this.font, this.beforeCursor, x -= this.font.width((FormattedText)this.beforeCursor), this.getY(), -16777216, false);
            if ((Util.getMillis() - this.lastSwitchFocusTime) / 300L % 2L == 0L) {
                int n = this.getY() - 1;
                int n2 = this.getY() + 1;
                Objects.requireNonNull(this.font);
                graphics.fill(cursorX, n, cursorX + 1, n2 + 9, -16777216);
            }
        } else {
            Component text = this.isHovered() ? this.hoverText : this.text;
            int textWidth = this.font.width((FormattedText)text);
            graphics.drawString(this.font, text, this.getX() + this.width - textWidth, this.getY(), -16777216, false);
        }
        if (this.isHovered()) {
            graphics.requestCursor(CursorTypes.IBEAM);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public boolean charTyped(CharacterEvent event) {
        if (event.modifiers() != 0) {
            return false;
        }
        if (event.codepoint() < 48 || event.codepoint() > 57) {
            return false;
        }
        if (!(this.input.length() < 2 || this.input.equals("10") && event.codepoint() == 48)) {
            return false;
        }
        this.input = this.input + event.codepointAsString();
        return true;
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (focused) {
            this.lastSwitchFocusTime = Util.getMillis();
            this.input = "";
        }
    }

    public void onClick(MouseButtonEvent mouseButtonEvent, boolean bl) {
        this.setFocused(true);
    }

    public boolean keyPressed(KeyEvent event) {
        if (!this.isFocused()) {
            return super.keyPressed(event);
        }
        if (!this.input.isEmpty() && event.key() == 259) {
            this.input = event.hasControlDown() ? "" : this.input.substring(0, this.input.length() - 1);
            return true;
        }
        if (event.key() == 257 || event.key() == 335) {
            if (!this.input.isEmpty()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                this.onPageChange.accept(Integer.parseInt(this.input));
            }
            this.setFocused(false);
            return true;
        }
        if (event.key() == 256) {
            this.setFocused(false);
            return true;
        }
        if (event.key() == 263 || event.key() == 262) {
            return true;
        }
        return super.keyPressed(event);
    }

    public void playDownSound(SoundManager soundManager) {
    }

    public void setPageNumber(int page, int total) {
        this.text = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{page, total});
        this.hoverText = ComponentUtils.mergeStyles((MutableComponent)this.text.copy(), (Style)Style.EMPTY.withUnderlined(Boolean.valueOf(true)));
        MutableComponent indicator = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{"--INDICATOR--", total});
        String[] parts = indicator.getString().split("--INDICATOR--", 2);
        Style gray = Style.EMPTY.withColor(ChatFormatting.DARK_GRAY);
        this.beforeCursor = Component.literal((String)parts[0]).setStyle(gray);
        this.afterCursor = parts.length > 1 ? Component.literal((String)parts[1]).setStyle(gray) : Component.empty();
        this.width = this.font.width((FormattedText)this.text);
        this.setX(this.anchorX - this.width);
    }
}

