/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui.button;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;

public class ColorSwatchWidget
extends AbstractButton {
    private final ChatFormatting color;
    private final Runnable onClick;
    private boolean toggled;

    public ColorSwatchWidget(Component tooltip, ChatFormatting color, Runnable onClick, int x, int y, int width, int height, boolean toggled) {
        super(x, y, width, height, tooltip);
        this.setTooltip(Tooltip.create((Component)tooltip));
        this.color = color;
        this.onClick = onClick;
        this.toggled = toggled;
    }

    protected void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Integer color;
        if (this.isHoveredOrFocused() || this.toggled) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.isHoveredOrFocused() ? -1 : -6250336);
        }
        if ((color = this.color.getColor()) == null) {
            return;
        }
        color = color | 0xFF000000;
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, color.intValue());
    }

    public boolean shouldTakeFocusAfterInteraction() {
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.toggled = true;
        this.onClick.run();
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }
}

