/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui.edit;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.gui.edit.RichMultiLineTextField;
import me.chrr.scribble.history.command.EditCommand;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RichEditBoxWidget
extends MultiLineEditBox {
    @Nullable
    private final Runnable onInvalidateFormat;
    @Nullable
    private final Consumer<EditCommand> onHistoryPush;
    @Nullable
    public ChatFormatting color = ChatFormatting.BLACK;
    public Set<ChatFormatting> modifiers = new HashSet<ChatFormatting>();

    private RichEditBoxWidget(Font font, int x, int y, int width, int height, Component placeholder, Component message, int textColor, boolean textShadow, int cursorColor, boolean hasBackground, boolean hasOverlay, @Nullable Runnable onInvalidateFormat, @Nullable Consumer<EditCommand> onHistoryPush) {
        super(font, x, y, width, height, placeholder, message, textColor, textShadow, cursorColor, hasBackground, hasOverlay);
        this.onInvalidateFormat = onInvalidateFormat;
        this.onHistoryPush = onHistoryPush;
        this.textField = new RichMultiLineTextField(font, width - this.totalInnerPadding(), () -> new Tuple((Object)Optional.ofNullable(this.color).orElse(ChatFormatting.BLACK), this.modifiers), (color, modifiers) -> {
            this.color = color;
            this.modifiers = new HashSet<ChatFormatting>((Collection<ChatFormatting>)modifiers);
            this.notifyInvalidateFormat();
        });
    }

    private void notifyInvalidateFormat() {
        if (this.onInvalidateFormat != null) {
            this.onInvalidateFormat.run();
        }
    }

    private void pushHistory(EditCommand command) {
        if (this.onHistoryPush != null) {
            this.onHistoryPush.accept(command);
        }
    }

    public void applyFormatting(ChatFormatting formatting, boolean active) {
        RichMultiLineTextField editBox = this.getRichTextField();
        if (editBox.hasSelection()) {
            EditCommand command = new EditCommand(editBox, box -> box.applyFormatting(formatting, active));
            command.executeEdit(editBox);
            this.pushHistory(command);
        } else {
            if (formatting.isFormat()) {
                if (active) {
                    this.modifiers.add(formatting);
                } else {
                    this.modifiers.remove(formatting);
                }
            } else {
                this.color = formatting;
            }
            this.notifyInvalidateFormat();
        }
    }

    private int getCursorColor() {
        if (this.color == null) {
            return -16777216;
        }
        return 0xFF000000 | this.color.getColor();
    }

    protected void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
        RichText text = this.getRichTextField().getRichText();
        if (text.isEmpty() && !this.isFocused()) {
            graphics.drawWordWrap(this.font, (FormattedText)this.placeholder, this.getInnerLeft(), this.getInnerTop(), this.width - this.totalInnerPadding(), -857677600);
            return;
        }
        int cursor = this.textField.cursor();
        boolean blink = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L;
        boolean cursorInText = cursor < text.getLength();
        int lastX = 0;
        int lastY = 0;
        int y = this.getInnerTop();
        boolean hasDrawnCursor = false;
        for (MultilineTextField.StringView line : this.textField.iterateLines()) {
            Objects.requireNonNull(this.font);
            boolean visible = this.withinContentAreaTopBottom(y, y + 9);
            int x = this.getInnerLeft();
            if (blink && cursorInText && cursor >= line.beginIndex() && cursor <= line.endIndex()) {
                if (visible) {
                    lineText = text.subText(line.beginIndex(), line.endIndex());
                    graphics.drawString(this.font, (Component)lineText.getAsMutableComponent(), x, y, this.textColor, this.textShadow);
                    RichText beforeCursor = text.subText(line.beginIndex(), cursor);
                    lastX = x + this.font.width((FormattedText)beforeCursor);
                    if (!hasDrawnCursor) {
                        Objects.requireNonNull(this.font);
                        graphics.fill(lastX, y - 1, lastX + 1, y + 1 + 9, this.getCursorColor());
                        hasDrawnCursor = true;
                    }
                }
            } else {
                if (visible) {
                    lineText = text.subText(line.beginIndex(), line.endIndex());
                    graphics.drawString(this.font, (Component)lineText.getAsMutableComponent(), x, y, this.textColor, this.textShadow);
                    lastX = x + this.font.width((FormattedText)lineText) - 1;
                }
                lastY = y;
            }
            Objects.requireNonNull(this.font);
            y += 9;
        }
        if (blink && !cursorInText) {
            Objects.requireNonNull(this.font);
            if (this.withinContentAreaTopBottom(lastY, lastY + 9)) {
                graphics.drawString(this.font, "_", lastX + 1, lastY, this.getCursorColor(), this.textShadow);
            }
        }
        if (this.textField.hasSelection()) {
            MultilineTextField.StringView selection = this.textField.getSelected();
            int x = this.getInnerLeft();
            y = this.getInnerTop();
            for (MultilineTextField.StringView line : this.textField.iterateLines()) {
                if (selection.beginIndex() <= line.endIndex()) {
                    if (line.beginIndex() > selection.endIndex()) break;
                    Objects.requireNonNull(this.font);
                    if (this.withinContentAreaTopBottom(y, y + 9)) {
                        int start = this.font.width((FormattedText)text.subText(line.beginIndex(), Math.max(selection.beginIndex(), line.beginIndex())));
                        int end = selection.endIndex() > line.endIndex() ? this.width - this.innerPadding() : this.font.width((FormattedText)text.subText(line.beginIndex(), selection.endIndex()));
                        Objects.requireNonNull(this.font);
                        graphics.textHighlight(x + start, y, x + end, y + 9, true);
                    }
                }
                Objects.requireNonNull(this.font);
                y += 9;
            }
        }
        if (this.isHovered()) {
            graphics.requestCursor(CursorTypes.IBEAM);
        }
    }

    public boolean charTyped(CharacterEvent event) {
        if (this.visible && this.isFocused() && event.isAllowedChatCharacter()) {
            EditCommand command = new EditCommand(this.getRichTextField(), editBox -> editBox.insertText(event.codepointAsString()));
            command.executeEdit(this.getRichTextField());
            this.pushHistory(command);
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.hasControlDown() && !event.hasShiftDown() && !event.hasAltDown()) {
            ChatFormatting modifier;
            switch (event.key()) {
                case 66: {
                    ChatFormatting chatFormatting = ChatFormatting.BOLD;
                    break;
                }
                case 73: {
                    ChatFormatting chatFormatting = ChatFormatting.ITALIC;
                    break;
                }
                case 85: {
                    ChatFormatting chatFormatting = ChatFormatting.UNDERLINE;
                    break;
                }
                case 45: {
                    ChatFormatting chatFormatting = ChatFormatting.STRIKETHROUGH;
                    break;
                }
                case 75: {
                    ChatFormatting chatFormatting = ChatFormatting.OBFUSCATED;
                    break;
                }
                default: {
                    ChatFormatting chatFormatting = modifier = null;
                }
            }
            if (modifier != null) {
                this.applyFormatting(modifier, !this.modifiers.contains(modifier));
                return true;
            }
        }
        if (event.isCut() || event.isPaste() || List.of(Integer.valueOf(257), Integer.valueOf(335), Integer.valueOf(259), Integer.valueOf(261)).contains(event.key())) {
            EditCommand command = new EditCommand(this.getRichTextField(), editBox -> editBox.keyPressed(event));
            command.executeEdit(this.getRichTextField());
            this.pushHistory(command);
            return true;
        }
        return super.keyPressed(event);
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"gui.narrate.editBox", (Object[])new Object[]{this.getMessage(), this.getRichTextField().getRichText().getPlainText()}));
    }

    public RichMultiLineTextField getRichTextField() {
        return (RichMultiLineTextField)this.textField;
    }

    public static class Builder
    extends MultiLineEditBox.Builder {
        @Nullable
        private Runnable onInvalidateFormat = null;
        @Nullable
        private Consumer<EditCommand> onHistoryPush = null;

        public Builder onInvalidateFormat(Runnable onInvalidateFormat) {
            this.onInvalidateFormat = onInvalidateFormat;
            return this;
        }

        public Builder onHistoryPush(Consumer<EditCommand> onHistoryPush) {
            this.onHistoryPush = onHistoryPush;
            return this;
        }

        @NotNull
        public MultiLineEditBox build(Font font, int width, int height, Component message) {
            return new RichEditBoxWidget(font, this.x, this.y, width, height, this.placeholder, message, this.textColor, this.textShadow, this.cursorColor, this.showBackground, this.showDecorations, this.onInvalidateFormat, this.onHistoryPush);
        }
    }
}

