/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui.edit;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.chrr.scribble.KeyboardUtil;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.RichText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RichMultiLineTextField
extends MultilineTextField {
    private final Supplier<Tuple<ChatFormatting, Set<ChatFormatting>>> formatSupplier;
    private final BiConsumer<@Nullable ChatFormatting, Set<ChatFormatting>> formatListener;
    private RichText richText;

    public RichMultiLineTextField(Font font, int width, Supplier<Tuple<ChatFormatting, Set<ChatFormatting>>> formatSupplier, BiConsumer<@Nullable ChatFormatting, Set<ChatFormatting>> formatListener) {
        super(font, width);
        this.formatSupplier = formatSupplier;
        this.formatListener = formatListener;
    }

    public void setValueListener(Consumer<String> valueListener) {
        super.setValueListener(text -> valueListener.accept(this.value()));
    }

    public void sendUpdateFormat() {
        if (this.formatListener != null) {
            MultilineTextField.StringView selection = this.getSelected();
            Tuple<@Nullable ChatFormatting, Set<ChatFormatting>> format = this.richText.getCommonFormat(selection.beginIndex(), selection.endIndex());
            this.formatListener.accept((ChatFormatting)format.getA(), (Set)format.getB());
        }
    }

    public void applyFormatting(ChatFormatting formatting, boolean active) {
        MultilineTextField.StringView selection = this.getSelected();
        int start = selection.beginIndex();
        int end = selection.endIndex();
        RichText result = formatting.isFormat() ? (active ? this.richText.applyFormatting(start, end, null, Set.of(formatting), Set.of()) : this.richText.applyFormatting(start, end, null, Set.of(), Set.of(formatting))) : this.richText.applyFormatting(start, end, formatting, Set.of(), Set.of());
        if (!this.overflowsLineLimit(result)) {
            this.richText = result;
            this.value = this.richText.getPlainText();
            this.onValueChange();
            this.sendUpdateFormat();
        }
    }

    public void setValue(String text, boolean allowOverflow) {
        String truncated = this.truncateFullText(text);
        RichText richText = RichText.fromFormattedString(truncated);
        if (allowOverflow || !this.overflowsLineLimit(richText)) {
            this.richText = richText;
            this.value = richText.getPlainText();
            this.selectCursor = this.cursor = this.value.length();
            this.onValueChange();
            this.sendUpdateFormat();
        }
    }

    @NotNull
    public String value() {
        return this.richText.getAsFormattedString();
    }

    public void setRichTextWithoutUpdating(RichText richText) {
        this.richText = richText;
        this.value = richText.getPlainText();
    }

    public void insertText(String string) {
        RichText result;
        if ((string = string.replaceAll(ChatFormatting.RESET.toString(), "")).isEmpty() && !this.hasSelection()) {
            return;
        }
        Tuple<ChatFormatting, Set<ChatFormatting>> style = this.formatSupplier.get();
        RichText replacement = ChatFormatting.stripFormatting((String)string).equals(string) ? new RichText(string, (ChatFormatting)style.getA(), (Set)style.getB()) : RichText.fromFormattedString(string);
        MultilineTextField.StringView substring = this.getSelected();
        int start = substring.beginIndex();
        int end = substring.endIndex();
        RichText richText = result = this.hasSelection() ? this.richText.replace(start, end, replacement) : this.richText.insert(start, replacement);
        if (!this.overflowsLineLimit(result)) {
            this.richText = result;
            this.value = this.richText.getPlainText();
            this.selectCursor = this.cursor = start + replacement.getLength();
            this.onValueChange();
            this.sendUpdateFormat();
        }
    }

    public void seekCursorLine(int offset) {
        if (offset != 0) {
            int cursorX = this.font.width((FormattedText)this.richText.subText(this.getCursorLineView().beginIndex(), this.cursor)) + 2;
            MultilineTextField.StringView substring = this.getCursorLineView(offset);
            int col = this.font.substrByWidth((FormattedText)this.richText.subText(substring.beginIndex(), substring.endIndex()), cursorX).getString().length();
            this.seekCursor(Whence.ABSOLUTE, substring.beginIndex() + col);
        }
    }

    public void seekCursorToPoint(double x, double y) {
        int cursorX = Mth.floor((double)x);
        Objects.requireNonNull(this.font);
        int line = Mth.floor((double)(y / 9.0));
        MultilineTextField.StringView substring = (MultilineTextField.StringView)this.displayLines.get(Mth.clamp((int)line, (int)0, (int)(this.displayLines.size() - 1)));
        int col = this.font.substrByWidth((FormattedText)this.richText.subText(substring.beginIndex(), substring.endIndex()), cursorX).getString().length();
        this.seekCursor(Whence.ABSOLUTE, substring.beginIndex() + col);
    }

    public void seekCursor(Whence whence, int amount) {
        super.seekCursor(whence, amount);
        this.sendUpdateFormat();
    }

    public boolean keyPressed(KeyEvent event) {
        boolean ctrlNoAlt;
        boolean keepFormatting = Scribble.CONFIG_MANAGER.getConfig().copyFormattingCodes ^ event.hasShiftDown();
        boolean bl = ctrlNoAlt = event.hasControlDown() && !event.hasAltDown();
        if (ctrlNoAlt && (KeyboardUtil.isKey(event.key(), "C") || KeyboardUtil.isKey(event.key(), "X"))) {
            String text = this.getSelectedText();
            if (!keepFormatting) {
                text = ChatFormatting.stripFormatting((String)text);
            }
            Minecraft.getInstance().keyboardHandler.setClipboard(text);
            if (KeyboardUtil.isKey(event.key(), "X")) {
                this.insertText("");
            }
            return true;
        }
        if (ctrlNoAlt && KeyboardUtil.isKey(event.key(), "V")) {
            String text = Minecraft.getInstance().keyboardHandler.getClipboard();
            if (!keepFormatting) {
                text = ChatFormatting.stripFormatting((String)text);
            }
            this.insertText(text);
            return true;
        }
        if (event.isSelectAll()) {
            boolean handled = super.keyPressed(event);
            this.sendUpdateFormat();
            return handled;
        }
        return super.keyPressed(event);
    }

    protected void reflowDisplayLines() {
        this.displayLines.clear();
        if (this.value.isEmpty()) {
            this.displayLines.add(new MultilineTextField.StringView(0, 0));
            return;
        }
        MutableInt current = new MutableInt();
        this.font.getSplitter().splitLines((FormattedText)this.richText, this.width, Style.EMPTY, (line, continued) -> {
            String content = line.getString();
            int start = ((Number)current.get()).intValue();
            int end = start + content.length();
            this.displayLines.add(new MultilineTextField.StringView(start, end));
            if (this.value.length() > end) {
                char c;
                end += (c = this.value.charAt(end)) == '\n' || c == ' ' ? 1 : 0;
            }
            current.setValue(end);
        });
    }

    @NotNull
    public String getSelectedText() {
        MultilineTextField.StringView substring = this.getSelected();
        return this.richText.subText(substring.beginIndex(), substring.endIndex()).getAsFormattedString();
    }

    private boolean overflowsLineLimit(RichText text) {
        return this.hasLineLimit() && this.font.getSplitter().splitLines((FormattedText)text, this.width, Style.EMPTY).size() > this.lineLimit;
    }

    public RichText getRichText() {
        return this.richText;
    }
}

