/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus;

import java.nio.file.Path;
import msmp.plus.Config;
import msmp.plus.command.DynamicCommandRegistry;
import msmp.plus.command.EnhancedMSMPCommand;
import msmp.plus.command.MSMCommand;
import msmp.plus.config.ConfigManager;
import msmp.plus.events.EventBroadcaster;
import msmp.plus.events.EventProcessor;
import msmp.plus.management.ModIncomingRpcMethods;
import msmp.plus.management.ModOutgoingRpcMethods;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsmplusMod
implements ModInitializer {
    public static final String MOD_ID = "msmplus";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"msmplus");
    private static Config config;

    public void onInitialize() {
        LOGGER.info("Initializing MSMPlus...");
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("msmpenhanced.json");
        config = Config.load(configPath);
        ConfigManager.initialize();
        ModIncomingRpcMethods.initialize();
        ModOutgoingRpcMethods.initialize();
        CommandRegistrationCallback.EVENT.register(MSMCommand::register);
        CommandRegistrationCallback.EVENT.register(EnhancedMSMPCommand::register);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            DynamicCommandRegistry.initialize(server);
            EventBroadcaster.initialize(server);
            EventProcessor.initialize();
            LOGGER.info("Dynamic command registry initialized");
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            EventProcessor.shutdown();
            LOGGER.info("Event processor shutdown");
        });
        LOGGER.info("MSMPlus initialized successfully");
    }

    public static Config getConfig() {
        return config;
    }
}

