/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import msmp.plus.command.CommandTemplate;
import msmp.plus.command.DynamicCommandRegistry;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class BroadcastCommandTemplate
extends CommandTemplate {
    public BroadcastCommandTemplate() {
        super("broadcast", "Broadcast message to all players", List.of(new CommandTemplate.CommandParameter("message", "string", true, null, "Message to broadcast"), new CommandTemplate.CommandParameter("prefix", "string", false, "[Server]", "Message prefix"), new CommandTemplate.CommandParameter("color", "string", false, "yellow", "Message color")));
    }

    @Override
    public void configureCommand(LiteralArgumentBuilder<class_2168> builder, Map<String, Object> parameters) {
        builder.then((ArgumentBuilder)class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()));
    }

    @Override
    public DynamicCommandRegistry.CommandExecutor createExecutor(Map<String, Object> parameters) {
        String prefix = this.getStringParameter(parameters, "prefix", "[Server]");
        String color = this.getStringParameter(parameters, "color", "yellow");
        return context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            String colorCode = this.getColorCode(color);
            class_5250 broadcastText = class_2561.method_43470((String)(colorCode + prefix + " \u00a7r" + message));
            for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                player.method_64398((class_2561)broadcastText);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aBroadcasted message to all players"), true);
            return ((class_2168)context.getSource()).method_9211().method_3760().method_14571().size();
        };
    }

    private String getColorCode(String color) {
        return switch (color.toLowerCase()) {
            case "red" -> "\u00a7c";
            case "green" -> "\u00a7a";
            case "blue" -> "\u00a79";
            case "yellow" -> "\u00a7e";
            case "gold" -> "\u00a76";
            case "aqua" -> "\u00a7b";
            case "white" -> "\u00a7f";
            case "gray" -> "\u00a77";
            case "dark_red" -> "\u00a74";
            case "dark_green" -> "\u00a72";
            case "dark_blue" -> "\u00a71";
            case "dark_aqua" -> "\u00a73";
            case "dark_gray" -> "\u00a78";
            case "black" -> "\u00a70";
            case "light_purple" -> "\u00a7d";
            case "dark_purple" -> "\u00a75";
            default -> "\u00a7e";
        };
    }
}

