/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import msmp.plus.command.DynamicCommandRegistry;
import net.minecraft.class_2168;

public abstract class CommandTemplate {
    private final String name;
    private final String description;
    private final List<CommandParameter> parameters;

    public CommandTemplate(String name, String description, List<CommandParameter> parameters) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
    }

    public abstract void configureCommand(LiteralArgumentBuilder<class_2168> var1, Map<String, Object> var2);

    public abstract DynamicCommandRegistry.CommandExecutor createExecutor(Map<String, Object> var1);

    public DynamicCommandRegistry.ValidationResult validateParameters(Map<String, Object> providedParams) {
        for (CommandParameter commandParameter : this.parameters) {
            if (!commandParameter.isRequired() || providedParams.containsKey(commandParameter.getName())) continue;
            return DynamicCommandRegistry.ValidationResult.invalid("Missing required parameter: " + commandParameter.getName());
        }
        for (Map.Entry entry : providedParams.entrySet()) {
            String paramName = (String)entry.getKey();
            Object value = entry.getValue();
            CommandParameter param = this.getParameter(paramName);
            if (param == null) {
                return DynamicCommandRegistry.ValidationResult.invalid("Unknown parameter: " + paramName);
            }
            if (this.isValidType(value, param.getType())) continue;
            return DynamicCommandRegistry.ValidationResult.invalid("Invalid type for parameter " + paramName + ": expected " + param.getType() + ", got " + value.getClass().getSimpleName());
        }
        return DynamicCommandRegistry.ValidationResult.valid();
    }

    private CommandParameter getParameter(String name) {
        return this.parameters.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    private boolean isValidType(Object value, String expectedType) {
        return switch (expectedType.toLowerCase()) {
            case "string" -> value instanceof String;
            case "int", "integer" -> value instanceof Number;
            case "double", "float", "number" -> value instanceof Number;
            case "boolean", "bool" -> value instanceof Boolean;
            default -> true;
        };
    }

    protected Object getParameter(Map<String, Object> parameters, String name, Object defaultValue) {
        return parameters.getOrDefault(name, defaultValue);
    }

    protected String getStringParameter(Map<String, Object> parameters, String name, String defaultValue) {
        Object value = parameters.get(name);
        return value instanceof String ? (String)value : defaultValue;
    }

    protected int getIntParameter(Map<String, Object> parameters, String name, int defaultValue) {
        Object value = parameters.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    protected double getDoubleParameter(Map<String, Object> parameters, String name, double defaultValue) {
        Object value = parameters.get(name);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return defaultValue;
    }

    protected boolean getBooleanParameter(Map<String, Object> parameters, String name, boolean defaultValue) {
        Object value = parameters.get(name);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public List<CommandParameter> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static class CommandParameter {
        private final String name;
        private final String type;
        private final boolean required;
        private final Object defaultValue;
        private final String description;

        public CommandParameter(String name, String type, boolean required, Object defaultValue, String description) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

