/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import msmp.plus.command.CommandTemplate;
import msmp.plus.command.DynamicCommandRegistry;
import msmp.plus.management.handler.NotificationBroadcaster;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class CustomActionCommandTemplate
extends CommandTemplate {
    public CustomActionCommandTemplate() {
        super("custom_action", "Execute custom action with parameters", List.of(new CommandTemplate.CommandParameter("action", "string", true, null, "Action name"), new CommandTemplate.CommandParameter("notifyOnExecute", "boolean", false, true, "Send notification when executed")));
    }

    @Override
    public void configureCommand(LiteralArgumentBuilder<class_2168> builder, Map<String, Object> parameters) {
        String action = this.getStringParameter(parameters, "action", "unknown");
        builder.then(class_2170.method_9244((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String args = StringArgumentType.getString((CommandContext)context, (String)"arguments");
            return this.executeAction((class_2168)context.getSource(), action, args, parameters);
        }));
        builder.executes(context -> this.executeAction((class_2168)context.getSource(), action, "", parameters));
    }

    @Override
    public DynamicCommandRegistry.CommandExecutor createExecutor(Map<String, Object> parameters) {
        String action = this.getStringParameter(parameters, "action", "unknown");
        return context -> this.executeAction((class_2168)context.getSource(), action, "", parameters);
    }

    private int executeAction(class_2168 source, String action, String args, Map<String, Object> parameters) {
        boolean notifyOnExecute = this.getBooleanParameter(parameters, "notifyOnExecute", true);
        JsonObject actionData = new JsonObject();
        actionData.addProperty("action", action);
        actionData.addProperty("arguments", args);
        actionData.addProperty("executor", source.method_9214());
        actionData.addProperty("timestamp", (Number)System.currentTimeMillis());
        if (notifyOnExecute) {
            NotificationBroadcaster.broadcastDynamicNotification(actionData.toString(), "custom_action");
        }
        source.method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aExecuted action: %s", action)), false);
        return 1;
    }
}

