/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import msmp.plus.MsmplusMod;
import msmp.plus.command.BroadcastCommandTemplate;
import msmp.plus.command.CommandTemplate;
import msmp.plus.command.CustomActionCommandTemplate;
import msmp.plus.command.EventToggleCommandTemplate;
import msmp.plus.command.NotificationCommandTemplate;
import msmp.plus.command.ServerStatusCommandTemplate;
import msmp.plus.config.ConfigManager;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class DynamicCommandRegistry {
    private static final Map<String, RegisteredCommand> commands = new ConcurrentHashMap<String, RegisteredCommand>();
    private static final Map<String, CommandTemplate> templates = new ConcurrentHashMap<String, CommandTemplate>();
    private static final Path COMMANDS_FILE = FabricLoader.getInstance().getConfigDir().resolve("msmplus_commands.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static MinecraftServer currentServer;

    public static void initialize(MinecraftServer server) {
        currentServer = server;
        DynamicCommandRegistry.registerDefaultTemplates();
        DynamicCommandRegistry.loadCommandsFromFile();
        MsmplusMod.LOGGER.info("Dynamic command registry initialized");
    }

    private static void registerDefaultTemplates() {
        DynamicCommandRegistry.registerTemplate(new NotificationCommandTemplate());
        DynamicCommandRegistry.registerTemplate(new BroadcastCommandTemplate());
        DynamicCommandRegistry.registerTemplate(new ServerStatusCommandTemplate());
        DynamicCommandRegistry.registerTemplate(new EventToggleCommandTemplate());
        DynamicCommandRegistry.registerTemplate(new CustomActionCommandTemplate());
    }

    public static void registerTemplate(CommandTemplate template) {
        templates.put(template.getName(), template);
        MsmplusMod.LOGGER.debug("Registered command template: {}", (Object)template.getName());
    }

    public static CommandTemplate getTemplate(String name) {
        return templates.get(name);
    }

    public static List<CommandTemplate> listTemplates() {
        return new ArrayList<CommandTemplate>(templates.values());
    }

    public static CommandRegistrationResult registerCommand(CommandRegistrationRequest request) {
        try {
            if (commands.containsKey(request.name())) {
                return CommandRegistrationResult.failure("Command already exists: " + request.name());
            }
            if (!ConfigManager.getConfig().commands().enableDynamicRegistration()) {
                return CommandRegistrationResult.failure("Dynamic command registration is disabled");
            }
            if (commands.size() >= ConfigManager.getConfig().commands().maxRegisteredCommands()) {
                return CommandRegistrationResult.failure("Maximum number of registered commands reached");
            }
            CommandTemplate template = templates.get(request.templateName());
            if (template == null) {
                return CommandRegistrationResult.failure("Unknown template: " + request.templateName());
            }
            ValidationResult validation = template.validateParameters(request.parameters());
            if (!validation.isValid()) {
                return CommandRegistrationResult.failure("Invalid parameters: " + validation.getError());
            }
            CommandExecutor executor = template.createExecutor(request.parameters());
            RegisteredCommand command = new RegisteredCommand(request.name(), request.description(), request.permissionLevel(), executor, request.templateName(), request.parameters(), true, request.source());
            commands.put(request.name(), command);
            if (currentServer != null) {
                DynamicCommandRegistry.reregisterCommands();
            }
            if (ConfigManager.getConfig().commands().persistCommands()) {
                DynamicCommandRegistry.saveCommandsToFile();
            }
            MsmplusMod.LOGGER.info("Registered command '{}' from source '{}'", (Object)request.name(), (Object)request.source());
            return CommandRegistrationResult.success(command);
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to register command '{}'", (Object)request.name(), (Object)e);
            return CommandRegistrationResult.failure(e.getMessage());
        }
    }

    public static CommandRegistrationResult unregisterCommand(String name) {
        RegisteredCommand removed = commands.remove(name);
        if (removed != null) {
            if (currentServer != null) {
                DynamicCommandRegistry.reregisterCommands();
            }
            if (ConfigManager.getConfig().commands().persistCommands()) {
                DynamicCommandRegistry.saveCommandsToFile();
            }
            MsmplusMod.LOGGER.info("Unregistered command '{}'", (Object)name);
            return CommandRegistrationResult.success(removed);
        }
        return CommandRegistrationResult.failure("Command not found: " + name);
    }

    public static List<RegisteredCommand> listCommands() {
        return new ArrayList<RegisteredCommand>(commands.values());
    }

    public static List<RegisteredCommand> listCommandsBySource(String source) {
        return commands.values().stream().filter(cmd -> cmd.getRegistrationSource().equals(source)).toList();
    }

    public static Optional<RegisteredCommand> getCommand(String name) {
        return Optional.ofNullable(commands.get(name));
    }

    public static void enableCommand(String name) {
        RegisteredCommand command = commands.get(name);
        if (command != null) {
            RegisteredCommand updated = new RegisteredCommand(command.name, command.description, command.permissionLevel, command.executor, command.templateName, command.parameters, true, command.registrationSource);
            commands.put(name, updated);
            DynamicCommandRegistry.reregisterCommands();
        }
    }

    public static void disableCommand(String name) {
        RegisteredCommand command = commands.get(name);
        if (command != null) {
            RegisteredCommand updated = new RegisteredCommand(command.name, command.description, command.permissionLevel, command.executor, command.templateName, command.parameters, false, command.registrationSource);
            commands.put(name, updated);
            DynamicCommandRegistry.reregisterCommands();
        }
    }

    public static void reregisterCommands() {
        if (currentServer == null) {
            return;
        }
        CommandDispatcher dispatcher = currentServer.method_3734().method_9235();
        for (RegisteredCommand command : commands.values()) {
            if (!command.isEnabled()) continue;
            DynamicCommandRegistry.registerWithDispatcher((CommandDispatcher<class_2168>)dispatcher, command);
        }
        MsmplusMod.LOGGER.debug("Reregistered {} dynamic commands", (Object)commands.size());
    }

    private static void registerWithDispatcher(CommandDispatcher<class_2168> dispatcher, RegisteredCommand command) {
        try {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)command.getName()).requires(command::canExecute);
            CommandTemplate template = templates.get(command.getTemplateName());
            if (template != null) {
                template.configureCommand((LiteralArgumentBuilder<class_2168>)builder, command.getParameters());
            }
            builder.executes(context -> {
                try {
                    return command.getExecutor().execute((CommandContext<class_2168>)context);
                }
                catch (Exception e) {
                    MsmplusMod.LOGGER.error("Error executing command '{}'", (Object)command.getName(), (Object)e);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Command execution failed: " + e.getMessage())));
                    return 0;
                }
            });
            dispatcher.register(builder);
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to register command '{}' with dispatcher", (Object)command.getName(), (Object)e);
        }
    }

    public static void loadCommandsFromFile() {
        if (!Files.exists(COMMANDS_FILE, new LinkOption[0])) {
            return;
        }
        try {
            String json = Files.readString(COMMANDS_FILE);
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            JsonArray commandsArray = root.getAsJsonArray("commands");
            int loaded = 0;
            for (JsonElement element : commandsArray) {
                JsonObject cmdObj = element.getAsJsonObject();
                try {
                    CommandRegistrationRequest request = new CommandRegistrationRequest(cmdObj.get("name").getAsString(), cmdObj.get("description").getAsString(), cmdObj.get("permissionLevel").getAsInt(), cmdObj.get("templateName").getAsString(), DynamicCommandRegistry.parseParameters(cmdObj.getAsJsonObject("parameters")), cmdObj.get("source").getAsString());
                    CommandRegistrationResult result = DynamicCommandRegistry.registerCommand(request);
                    if (result.isSuccess()) {
                        ++loaded;
                        continue;
                    }
                    MsmplusMod.LOGGER.warn("Failed to load command '{}': {}", (Object)request.name(), (Object)result.getError());
                }
                catch (Exception e) {
                    MsmplusMod.LOGGER.error("Error loading command from file", (Throwable)e);
                }
            }
            MsmplusMod.LOGGER.info("Loaded {} commands from file", (Object)loaded);
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to load commands from file", (Throwable)e);
        }
    }

    public static void saveCommandsToFile() {
        try {
            JsonObject root = new JsonObject();
            JsonArray commandsArray = new JsonArray();
            for (RegisteredCommand command : commands.values()) {
                JsonObject cmdObj = new JsonObject();
                cmdObj.addProperty("name", command.getName());
                cmdObj.addProperty("description", command.getDescription());
                cmdObj.addProperty("permissionLevel", (Number)command.getPermissionLevel());
                cmdObj.addProperty("templateName", command.getTemplateName());
                cmdObj.addProperty("source", command.getRegistrationSource());
                JsonObject params = new JsonObject();
                for (Map.Entry<String, Object> entry : command.getParameters().entrySet()) {
                    if (entry.getValue() instanceof String) {
                        params.addProperty(entry.getKey(), (String)entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Number) {
                        params.addProperty(entry.getKey(), (Number)entry.getValue());
                        continue;
                    }
                    if (!(entry.getValue() instanceof Boolean)) continue;
                    params.addProperty(entry.getKey(), (Boolean)entry.getValue());
                }
                cmdObj.add("parameters", (JsonElement)params);
                commandsArray.add((JsonElement)cmdObj);
            }
            root.add("commands", (JsonElement)commandsArray);
            Files.writeString(COMMANDS_FILE, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to save commands to file", (Throwable)e);
        }
    }

    private static Map<String, Object> parseParameters(JsonObject params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : params.entrySet()) {
            JsonElement value = (JsonElement)entry.getValue();
            if (!value.isJsonPrimitive()) continue;
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            if (primitive.isString()) {
                result.put((String)entry.getKey(), primitive.getAsString());
                continue;
            }
            if (primitive.isNumber()) {
                result.put((String)entry.getKey(), primitive.getAsDouble());
                continue;
            }
            if (!primitive.isBoolean()) continue;
            result.put((String)entry.getKey(), primitive.getAsBoolean());
        }
        return result;
    }

    public record CommandRegistrationRequest(String name, String description, int permissionLevel, String templateName, Map<String, Object> parameters, String source) {
    }

    public record CommandRegistrationResult(boolean success, RegisteredCommand command, String error) {
        public static CommandRegistrationResult success(RegisteredCommand command) {
            return new CommandRegistrationResult(true, command, null);
        }

        public static CommandRegistrationResult failure(String error) {
            return new CommandRegistrationResult(false, null, error);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getError() {
            return this.error;
        }
    }

    public record ValidationResult(boolean isValid, String error) {
        public static ValidationResult valid() {
            return new ValidationResult(true, null);
        }

        public static ValidationResult invalid(String error) {
            return new ValidationResult(false, error);
        }

        public String getError() {
            return this.error;
        }
    }

    @FunctionalInterface
    public static interface CommandExecutor {
        public int execute(CommandContext<class_2168> var1) throws CommandSyntaxException;
    }

    public static class RegisteredCommand {
        private final String name;
        private final String description;
        private final int permissionLevel;
        private final CommandExecutor executor;
        private final String templateName;
        private final Map<String, Object> parameters;
        private final boolean enabled;
        private final long registrationTime;
        private final String registrationSource;

        public RegisteredCommand(String name, String description, int permissionLevel, CommandExecutor executor, String templateName, Map<String, Object> parameters, boolean enabled, String registrationSource) {
            this.name = name;
            this.description = description;
            this.permissionLevel = permissionLevel;
            this.executor = executor;
            this.templateName = templateName;
            this.parameters = new HashMap<String, Object>(parameters);
            this.enabled = enabled;
            this.registrationTime = System.currentTimeMillis();
            this.registrationSource = registrationSource;
        }

        public boolean canExecute(class_2168 source) {
            return this.enabled && source.method_9259(this.permissionLevel);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getPermissionLevel() {
            return this.permissionLevel;
        }

        public CommandExecutor getExecutor() {
            return this.executor;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public long getRegistrationTime() {
            return this.registrationTime;
        }

        public String getRegistrationSource() {
            return this.registrationSource;
        }
    }
}

