/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import msmp.plus.command.CommandTemplate;
import msmp.plus.command.DynamicCommandRegistry;
import msmp.plus.config.ConfigManager;
import msmp.plus.events.EventCategory;
import msmp.plus.events.EventMetrics;
import msmp.plus.events.EventProcessor;
import msmp.plus.events.EventType;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class EnhancedMSMPCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msmp").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"events").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(EnhancedMSMPCommand::executeEventsList)).then(class_2170.method_9244((String)"category", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (EventCategory category : EventCategory.values()) {
                builder.suggest(category.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(EnhancedMSMPCommand::executeEventsListByCategory)))).then(class_2170.method_9247((String)"status").executes(EnhancedMSMPCommand::executeEventsStatus))).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"event_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (EventType type : EventType.values()) {
                builder.suggest(type.getEventName());
            }
            return builder.buildFuture();
        }).executes(EnhancedMSMPCommand::executeEventEnable)))).then(class_2170.method_9247((String)"disable").then(class_2170.method_9244((String)"event_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (EventType type : EventType.values()) {
                builder.suggest(type.getEventName());
            }
            return builder.buildFuture();
        }).executes(EnhancedMSMPCommand::executeEventDisable)))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"event_type", (ArgumentType)StringArgumentType.string()).executes(EnhancedMSMPCommand::executePlayerEventEnable)))).then(class_2170.method_9247((String)"disable").then(class_2170.method_9244((String)"event_type", (ArgumentType)StringArgumentType.string()).executes(EnhancedMSMPCommand::executePlayerEventDisable)))).then(class_2170.method_9247((String)"list").executes(EnhancedMSMPCommand::executePlayerEventList))).then(class_2170.method_9247((String)"clear").executes(EnhancedMSMPCommand::executePlayerEventClear))))).then(class_2170.method_9247((String)"reload").executes(EnhancedMSMPCommand::executeEventsReload)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"commands").then(class_2170.method_9247((String)"list").executes(EnhancedMSMPCommand::executeCommandsList))).then(class_2170.method_9247((String)"register").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"template", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (CommandTemplate template : DynamicCommandRegistry.listTemplates()) {
                builder.suggest(template.getName());
            }
            return builder.buildFuture();
        }).executes(EnhancedMSMPCommand::executeCommandRegister))))).then(class_2170.method_9247((String)"unregister").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DynamicCommandRegistry.RegisteredCommand cmd : DynamicCommandRegistry.listCommands()) {
                builder.suggest(cmd.getName());
            }
            return builder.buildFuture();
        }).executes(EnhancedMSMPCommand::executeCommandUnregister)))).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(EnhancedMSMPCommand::executeCommandEnable)))).then(class_2170.method_9247((String)"disable").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(EnhancedMSMPCommand::executeCommandDisable)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"templates").executes(EnhancedMSMPCommand::executeTemplatesList)).then(class_2170.method_9244((String)"template", (ArgumentType)StringArgumentType.string()).executes(EnhancedMSMPCommand::executeTemplateInfo))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"reload").executes(EnhancedMSMPCommand::executeConfigReload))).then(class_2170.method_9247((String)"show").executes(EnhancedMSMPCommand::executeConfigShow)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"metrics").executes(EnhancedMSMPCommand::executeMetrics)).then(class_2170.method_9247((String)"reset").executes(EnhancedMSMPCommand::executeMetricsReset)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"queue").then(class_2170.method_9247((String)"status").executes(EnhancedMSMPCommand::executeQueueStatus))).then(class_2170.method_9247((String)"clear").executes(EnhancedMSMPCommand::executeQueueClear))));
    }

    private static int executeEventsList(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76=== Available Events ==="), false);
        HashMap<EventCategory, List> byCategory = new HashMap<EventCategory, List>();
        for (EventType eventType : EventType.values()) {
            byCategory.computeIfAbsent(eventType.getCategory(), k -> new ArrayList()).add(eventType);
        }
        for (Enum enum_ : EventCategory.values()) {
            List events = (List)byCategory.get(enum_);
            if (events == null || events.isEmpty()) continue;
            ((class_2168)context.getSource()).method_9226(() -> EnhancedMSMPCommand.lambda$executeEventsList$8((EventCategory)enum_, events), false);
            for (EventType type : events) {
                String status = type.isEnabled() ? "\u00a7a\u2713" : "\u00a7c\u2717";
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  %s \u00a7f%s \u00a78- %s", status, type.getEventName(), type.getMsmpMethod())), false);
            }
        }
        return EventType.values().length;
    }

    private static int executeEventsListByCategory(CommandContext<class_2168> context) {
        String categoryName = StringArgumentType.getString(context, (String)"category").toUpperCase();
        try {
            EventCategory category = EventCategory.valueOf(categoryName);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76=== %s ===", category.getDisplayName())), false);
            int count = 0;
            for (EventType type : EventType.values()) {
                if (type.getCategory() != category) continue;
                String status = type.isEnabled() ? "\u00a7a\u2713" : "\u00a7c\u2717";
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  %s \u00a7f%s \u00a78- %s", status, type.getEventName(), type.getMsmpMethod())), false);
                ++count;
            }
            return count;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cUnknown category: " + categoryName)));
            return 0;
        }
    }

    private static int executeEventsStatus(CommandContext<class_2168> context) {
        EventMetrics.EventMetricsSnapshot metrics = EventMetrics.getSnapshot();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76=== Event System Status ==="), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Total Events Processed: \u00a7f%d", metrics.totalEventsProcessed())), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Events Dropped: \u00a7c%d", metrics.getTotalDropped())), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Events Failed: \u00a7c%d", metrics.getTotalFailed())), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Success Rate: \u00a7a%.2f%%", metrics.getOverallSuccessRate() * 100.0)), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Average Batch Size: \u00a7f%.2f", metrics.getAverageBatchSize())), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Average Batch Time: \u00a7f%.2fms", metrics.getAverageBatchProcessingTime())), false);
        return 1;
    }

    private static int executeEventEnable(CommandContext<class_2168> context) {
        String eventType = StringArgumentType.getString(context, (String)"event_type");
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aEnabled event: %s", eventType)), true);
        return 1;
    }

    private static int executeEventDisable(CommandContext<class_2168> context) {
        String eventType = StringArgumentType.getString(context, (String)"event_type");
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7cDisabled event: %s", eventType)), true);
        return 1;
    }

    private static int executePlayerEventEnable(CommandContext<class_2168> context) {
        try {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            String eventType = StringArgumentType.getString(context, (String)"event_type");
            ConfigManager.setEventEnabledForPlayer(player.method_5845(), eventType, true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aEnabled event %s for player %s", eventType, player.method_5477().getString())), true);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cError: " + e.getMessage())));
            return 0;
        }
    }

    private static int executePlayerEventDisable(CommandContext<class_2168> context) {
        try {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            String eventType = StringArgumentType.getString(context, (String)"event_type");
            ConfigManager.setEventEnabledForPlayer(player.method_5845(), eventType, false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7cDisabled event %s for player %s", eventType, player.method_5477().getString())), true);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cError: " + e.getMessage())));
            return 0;
        }
    }

    private static int executePlayerEventList(CommandContext<class_2168> context) {
        try {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            Map<String, Boolean> overrides = ConfigManager.getPlayerEventOverrides(player.method_5845());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76=== Event Overrides for %s ===", player.method_5477().getString())), false);
            if (overrides.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77No overrides configured (using global settings)"), false);
            } else {
                for (Map.Entry<String, Boolean> entry : overrides.entrySet()) {
                    String status = entry.getValue() != false ? "\u00a7aEnabled" : "\u00a7cDisabled";
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  %s: %s", entry.getKey(), status)), false);
                }
            }
            return overrides.size();
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cError: " + e.getMessage())));
            return 0;
        }
    }

    private static int executePlayerEventClear(CommandContext<class_2168> context) {
        try {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            ConfigManager.clearPlayerEventOverrides(player.method_5845());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aCleared event overrides for %s", player.method_5477().getString())), true);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cError: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeEventsReload(CommandContext<class_2168> context) {
        ConfigManager.reloadConfiguration();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aConfiguration reloaded"), true);
        return 1;
    }

    private static int executeCommandsList(CommandContext<class_2168> context) {
        List<DynamicCommandRegistry.RegisteredCommand> commands = DynamicCommandRegistry.listCommands();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76=== Registered Commands: %d ===", commands.size())), false);
        for (DynamicCommandRegistry.RegisteredCommand command : commands) {
            String status = command.isEnabled() ? "\u00a7a\u2713" : "\u00a7c\u2717";
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  %s \u00a7f%s \u00a77[%s] \u00a78(Level %d) - %s", status, command.getName(), command.getTemplateName(), command.getPermissionLevel(), command.getDescription())), false);
        }
        return commands.size();
    }

    private static int executeCommandRegister(CommandContext<class_2168> context) {
        String templateName;
        String name = StringArgumentType.getString(context, (String)"name");
        DynamicCommandRegistry.CommandRegistrationRequest request = new DynamicCommandRegistry.CommandRegistrationRequest(name, "Command registered via /msmp", 2, templateName = StringArgumentType.getString(context, (String)"template"), Map.of(), "console");
        DynamicCommandRegistry.CommandRegistrationResult result = DynamicCommandRegistry.registerCommand(request);
        if (result.isSuccess()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aSuccessfully registered command '%s' using template '%s'", name, templateName)), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to register command: " + result.getError())));
        return 0;
    }

    private static int executeCommandUnregister(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        DynamicCommandRegistry.CommandRegistrationResult result = DynamicCommandRegistry.unregisterCommand(name);
        if (result.isSuccess()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aSuccessfully unregistered command '%s'", name)), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to unregister command: " + result.getError())));
        return 0;
    }

    private static int executeCommandEnable(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        DynamicCommandRegistry.enableCommand(name);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aEnabled command: %s", name)), true);
        return 1;
    }

    private static int executeCommandDisable(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        DynamicCommandRegistry.disableCommand(name);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7cDisabled command: %s", name)), true);
        return 1;
    }

    private static int executeTemplatesList(CommandContext<class_2168> context) {
        List<CommandTemplate> templates = DynamicCommandRegistry.listTemplates();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76=== Available Command Templates: %d ===", templates.size())), false);
        for (CommandTemplate template : templates) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  \u00a7f%s \u00a77- %s", template.getName(), template.getDescription())), false);
        }
        return templates.size();
    }

    private static int executeTemplateInfo(CommandContext<class_2168> context) {
        String templateName = StringArgumentType.getString(context, (String)"template");
        CommandTemplate template = DynamicCommandRegistry.getTemplate(templateName);
        if (template == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cTemplate not found: " + templateName)));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76=== Template: %s ===", template.getName())), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Description: \u00a7f%s", template.getDescription())), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Parameters:"), false);
        for (CommandTemplate.CommandParameter param : template.getParameters()) {
            String required = param.isRequired() ? "\u00a7c*" : "\u00a77";
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  %s%s \u00a78(%s) \u00a77- %s", required, param.getName(), param.getType(), param.getDescription())), false);
        }
        return 1;
    }

    private static int executeConfigReload(CommandContext<class_2168> context) {
        ConfigManager.reloadConfiguration();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aConfiguration reloaded from file"), true);
        return 1;
    }

    private static int executeConfigShow(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76=== Configuration Summary ==="), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77See config file for details: config/msmplus.json"), false);
        return 1;
    }

    private static int executeMetrics(CommandContext<class_2168> context) {
        return EnhancedMSMPCommand.executeEventsStatus(context);
    }

    private static int executeMetricsReset(CommandContext<class_2168> context) {
        EventMetrics.reset();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aMetrics reset"), true);
        return 1;
    }

    private static int executeQueueStatus(CommandContext<class_2168> context) {
        int totalQueueSize = EventProcessor.getTotalQueueSize();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76=== Event Queue Status ===\n\u00a77Total queued: \u00a7f%d", totalQueueSize)), false);
        Map<EventType, Integer> queueSizes = EventProcessor.getQueueSizes();
        for (Map.Entry<EventType, Integer> entry : queueSizes.entrySet()) {
            if (entry.getValue() <= 0) continue;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  \u00a7f%s: \u00a77%d", ((EventType)((Object)((Object)entry.getKey()))).getEventName(), entry.getValue())), false);
        }
        return totalQueueSize;
    }

    private static int executeQueueClear(CommandContext<class_2168> context) {
        EventProcessor.clearAllQueues();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aCleared all event queues"), true);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$executeEventsList$8(EventCategory category, List events) {
        return class_2561.method_43470((String)String.format("\n\u00a7e%s\u00a77 (%d events):", category.getDisplayName(), events.size()));
    }
}

