/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Map;
import msmp.plus.command.CommandTemplate;
import msmp.plus.command.DynamicCommandRegistry;
import msmp.plus.management.handler.NotificationBroadcaster;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class NotificationCommandTemplate
extends CommandTemplate {
    public NotificationCommandTemplate() {
        super("notification", "Send notifications via MSMP", List.of(new CommandTemplate.CommandParameter("message", "string", true, null, "Message to send"), new CommandTemplate.CommandParameter("level", "string", false, "info", "Notification level"), new CommandTemplate.CommandParameter("target", "string", false, "all", "Target audience")));
    }

    @Override
    public void configureCommand(LiteralArgumentBuilder<class_2168> builder, Map<String, Object> parameters) {
        builder.then((ArgumentBuilder)class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()));
        String level = this.getStringParameter(parameters, "level", "info");
        if (!level.equals("info")) {
            builder.then((ArgumentBuilder)class_2170.method_9244((String)"level", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> {
                class_2172.method_9253((String[])new String[]{"info", "warning", "error"}, (SuggestionsBuilder)suggestionsBuilder);
                return suggestionsBuilder.buildFuture();
            }));
        }
    }

    @Override
    public DynamicCommandRegistry.CommandExecutor createExecutor(Map<String, Object> parameters) {
        String level = this.getStringParameter(parameters, "level", "info");
        String target = this.getStringParameter(parameters, "target", "all");
        return context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            JsonObject notification = new JsonObject();
            notification.addProperty("message", message);
            notification.addProperty("level", level);
            notification.addProperty("target", target);
            notification.addProperty("source", ((class_2168)context.getSource()).method_9214());
            NotificationBroadcaster.broadcastDynamicNotification(notification.toString(), "custom_command");
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aSent %s notification: %s", level, message)), false);
            return 1;
        };
    }
}

