/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import msmp.plus.command.CommandTemplate;
import msmp.plus.command.DynamicCommandRegistry;
import msmp.plus.events.EventMetrics;
import msmp.plus.management.handler.NotificationBroadcaster;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ServerStatusCommandTemplate
extends CommandTemplate {
    public ServerStatusCommandTemplate() {
        super("server_status", "Get server status information", List.of(new CommandTemplate.CommandParameter("format", "string", false, "text", "Output format (text/json)"), new CommandTemplate.CommandParameter("details", "boolean", false, false, "Include detailed information")));
    }

    @Override
    public void configureCommand(LiteralArgumentBuilder<class_2168> builder, Map<String, Object> parameters) {
        String format;
        boolean includeDetails = this.getBooleanParameter(parameters, "details", false);
        if (includeDetails) {
            builder.then((ArgumentBuilder)class_2170.method_9247((String)"detailed"));
        }
        if (!(format = this.getStringParameter(parameters, "format", "text")).equals("text")) {
            builder.then((ArgumentBuilder)class_2170.method_9247((String)"json"));
        }
    }

    @Override
    public DynamicCommandRegistry.CommandExecutor createExecutor(Map<String, Object> parameters) {
        String format = this.getStringParameter(parameters, "format", "text");
        boolean includeDetails = this.getBooleanParameter(parameters, "details", false);
        return context -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            if (format.equals("json")) {
                JsonObject status = this.collectServerStatus(server, includeDetails);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)status.toString()), false);
                NotificationBroadcaster.broadcastDynamicNotification(status.toString(), "server_status");
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76=== Server Status ==="), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Players: \u00a7f%d/%d", server.method_3788(), server.method_3802())), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Version: \u00a7f%s", server.method_3827())), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Uptime: \u00a7fN/A (requires tracking)"), false);
                if (includeDetails) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77TPS: \u00a7f%.2f", Float.valueOf(server.method_54832()))), false);
                    Runtime runtime = Runtime.getRuntime();
                    long memUsed = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
                    long memMax = runtime.maxMemory() / 1024L / 1024L;
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Memory: \u00a7f%dMB/%dMB", memUsed, memMax)), false);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76Worlds:"), false);
                    for (class_3218 world : server.method_3738()) {
                        String worldName = world.method_27983().method_29177().toString();
                        int players = world.method_18456().size();
                        int chunks = world.method_14178().method_14151();
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("  \u00a77%s: \u00a7f%d players, %d chunks", worldName, players, chunks)), false);
                    }
                    EventMetrics.EventMetricsSnapshot metrics = EventMetrics.getSnapshot();
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a77Events Processed: \u00a7f%d", metrics.totalEventsProcessed())), false);
                }
            }
            return 1;
        };
    }

    private JsonObject collectServerStatus(MinecraftServer server, boolean includeDetails) {
        JsonObject status = new JsonObject();
        status.addProperty("running", Boolean.valueOf(true));
        status.addProperty("playerCount", (Number)server.method_3788());
        status.addProperty("maxPlayers", (Number)server.method_3802());
        status.addProperty("serverVersion", server.method_3827());
        status.addProperty("uptime", (Number)0);
        if (includeDetails) {
            status.addProperty("tps", (Number)Float.valueOf(server.method_54832()));
            Runtime runtime = Runtime.getRuntime();
            status.addProperty("memoryUsed", (Number)(runtime.totalMemory() - runtime.freeMemory()));
            status.addProperty("memoryMax", (Number)runtime.maxMemory());
            JsonArray worlds = new JsonArray();
            for (class_3218 world : server.method_3738()) {
                JsonObject worldInfo = new JsonObject();
                worldInfo.addProperty("name", world.method_27983().method_29177().toString());
                worldInfo.addProperty("players", (Number)world.method_18456().size());
                worldInfo.addProperty("loadedChunks", (Number)world.method_14178().method_14151());
                worlds.add((JsonElement)worldInfo);
            }
            status.add("worlds", (JsonElement)worlds);
            JsonObject eventSystem = new JsonObject();
            EventMetrics.EventMetricsSnapshot metrics = EventMetrics.getSnapshot();
            eventSystem.addProperty("totalEventsProcessed", (Number)metrics.totalEventsProcessed());
            eventSystem.addProperty("eventsDropped", (Number)metrics.getTotalDropped());
            eventSystem.addProperty("eventsFailed", (Number)metrics.getTotalFailed());
            status.add("eventSystem", (JsonElement)eventSystem);
        }
        return status;
    }
}

