/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.config;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import msmp.plus.MsmplusMod;
import msmp.plus.config.EnhancedConfig;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;

public class ConfigManager {
    private static volatile EnhancedConfig config;
    private static final Path CONFIG_PATH;
    private static final Path BACKUP_PATH;
    private static final ReentrantReadWriteLock configLock;
    private static final Set<ConfigChangeListener> listeners;
    private static final Map<String, Map<String, Boolean>> playerEventCache;

    public static void initialize() {
        ConfigManager.loadConfiguration();
        ConfigManager.startConfigurationWatcher();
        MsmplusMod.LOGGER.info("Configuration manager initialized");
    }

    public static EnhancedConfig getConfig() {
        configLock.readLock().lock();
        try {
            EnhancedConfig enhancedConfig = config;
            return enhancedConfig;
        }
        finally {
            configLock.readLock().unlock();
        }
    }

    public static void updateConfig(EnhancedConfig newConfig) {
        configLock.writeLock().lock();
        try {
            EnhancedConfig oldConfig = config;
            config = newConfig;
            ConfigManager.saveConfiguration();
            playerEventCache.clear();
            ConfigManager.notifyConfigurationChanged(oldConfig, newConfig);
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    public static void loadConfiguration() {
        configLock.writeLock().lock();
        try {
            config = EnhancedConfig.load(CONFIG_PATH);
            playerEventCache.clear();
            MsmplusMod.LOGGER.info("Configuration loaded from file");
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    public static void saveConfiguration() {
        configLock.readLock().lock();
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.copy(CONFIG_PATH, BACKUP_PATH, StandardCopyOption.REPLACE_EXISTING);
            }
            config.save(CONFIG_PATH);
            MsmplusMod.LOGGER.info("Configuration saved to file");
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to save configuration", (Throwable)e);
        }
        finally {
            configLock.readLock().unlock();
        }
    }

    public static void reloadConfiguration() {
        configLock.writeLock().lock();
        try {
            EnhancedConfig oldConfig = config;
            ConfigManager.loadConfiguration();
            ConfigManager.notifyConfigurationChanged(oldConfig, config);
            MsmplusMod.LOGGER.info("Configuration reloaded from file");
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    public static boolean isEventEnabled(String eventType) {
        configLock.readLock().lock();
        try {
            boolean bl = ConfigManager.getEventEnabledState(config, eventType);
            return bl;
        }
        finally {
            configLock.readLock().unlock();
        }
    }

    public static boolean isEventEnabledForPlayer(String eventType, class_3222 player) {
        return ConfigManager.isEventEnabledForPlayer(eventType, player.method_5845());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEventEnabledForPlayer(String eventType, String playerUuid) {
        configLock.readLock().lock();
        try {
            Map<String, Boolean> playerCache = playerEventCache.get(playerUuid);
            if (playerCache != null && playerCache.containsKey(eventType)) {
                boolean bl = playerCache.get(eventType);
                return bl;
            }
            EnhancedConfig.PlayerEventSettings playerSettings = config.playerEvents().playerSettings().get(playerUuid);
            if (playerSettings == null) {
                playerSettings = config.playerEvents().defaultSettings();
            }
            if (playerSettings.eventOverrides().containsKey(eventType)) {
                boolean enabled = playerSettings.eventOverrides().get(eventType);
                ConfigManager.cachePlayerEventState(playerUuid, eventType, enabled);
                boolean bl = enabled;
                return bl;
            }
            if (playerSettings.inheritGlobalSettings()) {
                boolean enabled = ConfigManager.isEventEnabled(eventType);
                ConfigManager.cachePlayerEventState(playerUuid, eventType, enabled);
                boolean bl = enabled;
                return bl;
            }
            ConfigManager.cachePlayerEventState(playerUuid, eventType, false);
            boolean bl = false;
            return bl;
        }
        finally {
            configLock.readLock().unlock();
        }
    }

    public static void setEventEnabled(String eventType, boolean enabled) {
        MsmplusMod.LOGGER.warn("setEventEnabled called for {} with enabled={}, but global event toggling requires config file changes", (Object)eventType, (Object)enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEventEnabledForPlayer(String playerUuid, String eventType, boolean enabled) {
        configLock.writeLock().lock();
        try {
            HashMap<String, EnhancedConfig.PlayerEventSettings> playerSettings = new HashMap<String, EnhancedConfig.PlayerEventSettings>(config.playerEvents().playerSettings());
            EnhancedConfig.PlayerEventSettings settings = (EnhancedConfig.PlayerEventSettings)playerSettings.get(playerUuid);
            if (settings == null) {
                settings = config.playerEvents().defaultSettings();
            }
            HashMap<String, Boolean> overrides = new HashMap<String, Boolean>(settings.eventOverrides());
            overrides.put(eventType, enabled);
            EnhancedConfig.PlayerEventSettings newSettings = new EnhancedConfig.PlayerEventSettings(overrides, settings.inheritGlobalSettings());
            playerSettings.put(playerUuid, newSettings);
            EnhancedConfig.PlayerEventConfig newPlayerEventConfig = new EnhancedConfig.PlayerEventConfig(playerSettings, config.playerEvents().defaultSettings());
            EnhancedConfig newConfig = new EnhancedConfig(config.msmp(), config.events(), config.performance(), config.commands(), config.debug(), config.security(), newPlayerEventConfig);
            ConfigManager.updateConfig(newConfig);
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPlayerEventOverrides(String playerUuid) {
        configLock.writeLock().lock();
        try {
            HashMap<String, EnhancedConfig.PlayerEventSettings> playerSettings = new HashMap<String, EnhancedConfig.PlayerEventSettings>(config.playerEvents().playerSettings());
            playerSettings.remove(playerUuid);
            EnhancedConfig.PlayerEventConfig newPlayerEventConfig = new EnhancedConfig.PlayerEventConfig(playerSettings, config.playerEvents().defaultSettings());
            EnhancedConfig newConfig = new EnhancedConfig(config.msmp(), config.events(), config.performance(), config.commands(), config.debug(), config.security(), newPlayerEventConfig);
            ConfigManager.updateConfig(newConfig);
            playerEventCache.remove(playerUuid);
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    public static Map<String, Boolean> getPlayerEventOverrides(String playerUuid) {
        configLock.readLock().lock();
        try {
            EnhancedConfig.PlayerEventSettings settings = config.playerEvents().playerSettings().get(playerUuid);
            if (settings != null) {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(settings.eventOverrides());
                return hashMap;
            }
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            return hashMap;
        }
        finally {
            configLock.readLock().unlock();
        }
    }

    private static void cachePlayerEventState(String playerUuid, String eventType, boolean enabled) {
        playerEventCache.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap()).put(eventType, enabled);
    }

    private static boolean getEventEnabledState(EnhancedConfig config, String eventType) {
        return switch (eventType) {
            case "player_chat" -> config.events().core().playerChat();
            case "player_death" -> config.events().core().playerDeath();
            case "player_advancement" -> config.events().core().playerAdvancement();
            case "player_joined" -> config.events().core().playerJoined();
            case "player_left" -> config.events().core().playerLeft();
            case "custom_notifications" -> config.events().core().customNotifications();
            case "server_starting" -> config.events().server().serverStarting();
            case "server_started" -> config.events().server().serverStarted();
            case "server_stopping" -> config.events().server().serverStopping();
            case "server_stopped" -> config.events().server().serverStopped();
            case "data_pack_reload" -> config.events().server().dataPackReload();
            case "player_respawn" -> config.events().player().playerRespawn();
            case "player_game_mode_change" -> config.events().player().playerGameModeChange();
            case "player_move" -> config.events().player().playerMovement().enabled();
            case "player_toggle_sneak" -> config.events().player().playerToggleSneak();
            case "player_toggle_sprint" -> config.events().player().playerToggleSprint();
            case "player_toggle_flight" -> config.events().player().playerToggleFlight();
            case "player_world_change" -> config.events().player().playerWorldChange();
            case "player_break_block_before" -> config.events().block().playerBreakBlock();
            case "player_break_block_after" -> config.events().block().playerBreakBlock();
            case "player_place_block_before" -> config.events().block().playerPlaceBlock();
            case "player_place_block_after" -> config.events().block().playerPlaceBlock();
            case "entity_death" -> config.events().entity().entityDeath();
            case "entity_damage" -> config.events().entity().entityDamage();
            case "entity_mount" -> config.events().entity().entityMount();
            case "entity_dismount" -> config.events().entity().entityMount();
            case "entity_breeding" -> config.events().entity().entityBreeding();
            case "world_load" -> config.events().world().worldLoad();
            case "world_unload" -> config.events().world().worldUnload();
            case "weather_change" -> config.events().world().weatherChange();
            case "time_change" -> config.events().world().weatherChange();
            case "explosion" -> config.events().world().weatherChange();
            case "player_interact_block" -> config.events().interaction().playerInteractBlock();
            case "player_interact_entity" -> config.events().interaction().playerInteractEntity();
            case "player_interact_air" -> config.events().interaction().playerInteractBlock();
            case "player_bed_enter" -> config.events().interaction().playerInteractBlock();
            case "player_bed_leave" -> config.events().interaction().playerInteractBlock();
            case "fishing_cast" -> config.events().fishing().fishingCast();
            case "fish_caught" -> config.events().fishing().fishCaught();
            case "player_fish_escape" -> config.events().fishing().fishCaught();
            case "player_fishing_reel_in" -> config.events().fishing().fishingCast();
            case "player_fish_bite" -> config.events().fishing().fishCaught();
            case "item_drop" -> config.events().item().itemDrop();
            case "item_pickup" -> config.events().item().itemPickup();
            case "player_use_item" -> config.events().item().itemDrop();
            case "player_consume_item" -> config.events().item().itemDrop();
            case "player_item_break" -> config.events().item().itemDrop();
            case "player_swap_hand_items" -> config.events().item().itemDrop();
            case "player_held_item_change" -> config.events().item().itemDrop();
            case "inventory_open" -> config.events().inventory().inventoryOpen();
            case "inventory_close" -> config.events().inventory().inventoryClose();
            case "player_inventory_click" -> config.events().inventory().inventoryOpen();
            case "player_inventory_drag" -> config.events().inventory().inventoryOpen();
            case "furnace_smelt" -> config.events().furnace().furnaceSmelt();
            case "furnace_burn" -> config.events().furnace().furnaceBurn();
            case "furnace_extract" -> config.events().furnace().furnaceSmelt();
            case "furnace_start_smelt" -> config.events().furnace().furnaceSmelt();
            case "exp_change" -> config.events().experience().expChange();
            case "level_change" -> config.events().experience().levelChange();
            case "player_kill_player" -> config.events().pvp().playerKillPlayer();
            case "player_command" -> config.events().command().playerCommand();
            case "command_message" -> config.events().command().commandMessage();
            case "player_tab_complete" -> config.events().command().playerCommand();
            case "portal_create" -> config.events().portal().portalCreate();
            case "portal_use" -> config.events().portal().portalUse();
            case "loot_generate" -> config.events().advanced().lootGenerate();
            case "redstone_update" -> config.events().advanced().redstoneUpdate();
            case "projectile_kill" -> config.events().advanced().lootGenerate();
            case "entity_heal" -> config.events().advanced().lootGenerate();
            case "merchant_interaction" -> config.events().advanced().lootGenerate();
            case "chunk_load" -> config.events().advanced().lootGenerate();
            case "chunk_unload" -> config.events().advanced().lootGenerate();
            default -> false;
        };
    }

    public static void addListener(ConfigChangeListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(ConfigChangeListener listener) {
        listeners.remove(listener);
    }

    private static void notifyConfigurationChanged(EnhancedConfig oldConfig, EnhancedConfig newConfig) {
        Set<String> changedSections = ConfigManager.detectChangedSections(oldConfig, newConfig);
        ConfigChangeEvent event = new ConfigChangeEvent(oldConfig, newConfig, changedSections, "internal");
        for (ConfigChangeListener listener : listeners) {
            try {
                listener.onConfigurationChanged(event);
            }
            catch (Exception e) {
                MsmplusMod.LOGGER.error("Error notifying config change listener", (Throwable)e);
            }
        }
    }

    private static Set<String> detectChangedSections(EnhancedConfig oldConfig, EnhancedConfig newConfig) {
        HashSet<String> changed = new HashSet<String>();
        if (!oldConfig.msmp().equals(newConfig.msmp())) {
            changed.add("msmp");
        }
        if (!oldConfig.events().equals(newConfig.events())) {
            changed.add("events");
        }
        if (!oldConfig.performance().equals(newConfig.performance())) {
            changed.add("performance");
        }
        if (!oldConfig.commands().equals(newConfig.commands())) {
            changed.add("commands");
        }
        if (!oldConfig.debug().equals(newConfig.debug())) {
            changed.add("debug");
        }
        if (!oldConfig.security().equals(newConfig.security())) {
            changed.add("security");
        }
        if (!oldConfig.playerEvents().equals(newConfig.playerEvents())) {
            changed.add("playerEvents");
        }
        return changed;
    }

    private static void startConfigurationWatcher() {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            CONFIG_PATH.getParent().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Thread watcherThread = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            WatchKey key = watchService.take();
                            for (WatchEvent<?> event : key.pollEvents()) {
                                if (!event.context().toString().equals(CONFIG_PATH.getFileName().toString())) continue;
                                Thread.sleep(500L);
                                ConfigManager.reloadConfiguration();
                            }
                            key.reset();
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        MsmplusMod.LOGGER.error("Configuration watcher error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            });
            watcherThread.setDaemon(true);
            watcherThread.setName("MSMPlus-ConfigWatcher");
            watcherThread.start();
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to start configuration watcher", (Throwable)e);
        }
    }

    static {
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("msmplus.json");
        BACKUP_PATH = FabricLoader.getInstance().getConfigDir().resolve("msmplus.json.backup");
        configLock = new ReentrantReadWriteLock();
        listeners = ConcurrentHashMap.newKeySet();
        playerEventCache = new ConcurrentHashMap<String, Map<String, Boolean>>();
    }

    public record ConfigChangeEvent(EnhancedConfig oldConfig, EnhancedConfig newConfig, Set<String> changedSections, String source) {
        public boolean hasChanged(String section) {
            return this.changedSections.contains(section);
        }

        public boolean hasEventConfigChanged() {
            return this.changedSections.contains("events");
        }

        public boolean hasPerformanceConfigChanged() {
            return this.changedSections.contains("performance");
        }

        public boolean hasPlayerEventConfigChanged() {
            return this.changedSections.contains("playerEvents");
        }
    }

    public static interface ConfigChangeListener {
        public void onConfigurationChanged(ConfigChangeEvent var1);
    }
}

