/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import msmp.plus.MsmplusMod;
import net.minecraft.class_11341;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record EnhancedConfig(MsmpConfig msmp, EventsConfig events, PerformanceConfig performance, CommandsConfig commands, DebugConfig debug, SecurityConfig security, PlayerEventConfig playerEvents) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Codec<EnhancedConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MsmpConfig.CODEC.fieldOf("msmp").forGetter(EnhancedConfig::msmp), (App)EventsConfig.CODEC.fieldOf("events").forGetter(EnhancedConfig::events), (App)PerformanceConfig.CODEC.fieldOf("performance").forGetter(EnhancedConfig::performance), (App)CommandsConfig.CODEC.fieldOf("commands").forGetter(EnhancedConfig::commands), (App)DebugConfig.CODEC.fieldOf("debug").forGetter(EnhancedConfig::debug), (App)SecurityConfig.CODEC.fieldOf("security").forGetter(EnhancedConfig::security), (App)PlayerEventConfig.CODEC.fieldOf("playerEvents").forGetter(EnhancedConfig::playerEvents)).apply((Applicative)instance, EnhancedConfig::new));

    public static EnhancedConfig getDefault() {
        return new EnhancedConfig(MsmpConfig.getDefault(), EventsConfig.getDefault(), PerformanceConfig.getDefault(), CommandsConfig.getDefault(), DebugConfig.getDefault(), SecurityConfig.getDefault(), PlayerEventConfig.getDefault());
    }

    public static EnhancedConfig load(Path configPath) {
        File file = configPath.toFile();
        EnhancedConfig config = EnhancedConfig.getDefault();
        if (file.exists()) {
            try {
                DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)class_11341.method_71360((String)Files.readString(configPath)));
                config = (EnhancedConfig)result.resultOrPartial(arg_0 -> ((Logger)MsmplusMod.LOGGER).error(arg_0)).orElseThrow();
            }
            catch (IOException e) {
                MsmplusMod.LOGGER.error("Failed to load config file", (Throwable)e);
            }
        } else if (file.getParentFile().canWrite() || file.canWrite()) {
            DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)EnhancedConfig.getDefault());
            JsonElement json = (JsonElement)result.getOrThrow();
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson(json, GSON.newJsonWriter((Writer)writer));
            }
            catch (IOException e) {
                MsmplusMod.LOGGER.error("Failed to write default config file", (Throwable)e);
            }
        } else {
            MsmplusMod.LOGGER.info("Config at {} is not writable. Using default config.", (Object)configPath);
        }
        if (config.msmp().unixSocketEnabled() && config.msmp().unixSocketPath().isEmpty()) {
            throw new IllegalArgumentException("Empty unix socket path");
        }
        return config;
    }

    public void save(Path configPath) {
        try {
            DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
            JsonElement json = (JsonElement)result.getOrThrow();
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson(json, GSON.newJsonWriter((Writer)writer));
            }
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public record MsmpConfig(boolean enabled, boolean unixSocketEnabled, @NotNull String unixSocketPath, int port, String host, boolean strictMode, int connectionTimeout, int maxConnections) {
        public static final Codec<MsmpConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(MsmpConfig::enabled), (App)Codec.BOOL.fieldOf("unixSocketEnabled").forGetter(MsmpConfig::unixSocketEnabled), (App)Codec.STRING.fieldOf("unixSocketPath").forGetter(MsmpConfig::unixSocketPath), (App)Codec.INT.fieldOf("port").forGetter(MsmpConfig::port), (App)Codec.STRING.fieldOf("host").forGetter(MsmpConfig::host), (App)Codec.BOOL.fieldOf("strictMode").forGetter(MsmpConfig::strictMode), (App)Codec.INT.fieldOf("connectionTimeout").forGetter(MsmpConfig::connectionTimeout), (App)Codec.INT.fieldOf("maxConnections").forGetter(MsmpConfig::maxConnections)).apply((Applicative)instance, MsmpConfig::new));

        public static MsmpConfig getDefault() {
            return new MsmpConfig(true, false, "msmp.sock", 25575, "localhost", false, 30000, 10);
        }
    }

    public record EventsConfig(CoreEventsConfig core, ServerEventsConfig server, PlayerEventsConfig player, BlockEventsConfig block, EntityEventsConfig entity, WorldEventsConfig world, InteractionEventsConfig interaction, FishingEventsConfig fishing, ItemEventsConfig item, InventoryEventsConfig inventory, FurnaceEventsConfig furnace, ExperienceEventsConfig experience, PvpEventsConfig pvp, CommandEventsConfig command, PortalEventsConfig portal, AdvancedEventsConfig advanced) {
        public static final Codec<EventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CoreEventsConfig.CODEC.fieldOf("core").forGetter(EventsConfig::core), (App)ServerEventsConfig.CODEC.fieldOf("server").forGetter(EventsConfig::server), (App)PlayerEventsConfig.CODEC.fieldOf("player").forGetter(EventsConfig::player), (App)BlockEventsConfig.CODEC.fieldOf("block").forGetter(EventsConfig::block), (App)EntityEventsConfig.CODEC.fieldOf("entity").forGetter(EventsConfig::entity), (App)WorldEventsConfig.CODEC.fieldOf("world").forGetter(EventsConfig::world), (App)InteractionEventsConfig.CODEC.fieldOf("interaction").forGetter(EventsConfig::interaction), (App)FishingEventsConfig.CODEC.fieldOf("fishing").forGetter(EventsConfig::fishing), (App)ItemEventsConfig.CODEC.fieldOf("item").forGetter(EventsConfig::item), (App)InventoryEventsConfig.CODEC.fieldOf("inventory").forGetter(EventsConfig::inventory), (App)FurnaceEventsConfig.CODEC.fieldOf("furnace").forGetter(EventsConfig::furnace), (App)ExperienceEventsConfig.CODEC.fieldOf("experience").forGetter(EventsConfig::experience), (App)PvpEventsConfig.CODEC.fieldOf("pvp").forGetter(EventsConfig::pvp), (App)CommandEventsConfig.CODEC.fieldOf("command").forGetter(EventsConfig::command), (App)PortalEventsConfig.CODEC.fieldOf("portal").forGetter(EventsConfig::portal), (App)AdvancedEventsConfig.CODEC.fieldOf("advanced").forGetter(EventsConfig::advanced)).apply((Applicative)instance, EventsConfig::new));

        public static EventsConfig getDefault() {
            return new EventsConfig(CoreEventsConfig.getDefault(), ServerEventsConfig.getDefault(), PlayerEventsConfig.getDefault(), BlockEventsConfig.getDefault(), EntityEventsConfig.getDefault(), WorldEventsConfig.getDefault(), InteractionEventsConfig.getDefault(), FishingEventsConfig.getDefault(), ItemEventsConfig.getDefault(), InventoryEventsConfig.getDefault(), FurnaceEventsConfig.getDefault(), ExperienceEventsConfig.getDefault(), PvpEventsConfig.getDefault(), CommandEventsConfig.getDefault(), PortalEventsConfig.getDefault(), AdvancedEventsConfig.getDefault());
        }
    }

    public record PerformanceConfig(NotificationConfig notifications, MemoryConfig memory) {
        public static final Codec<PerformanceConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NotificationConfig.CODEC.fieldOf("notifications").forGetter(PerformanceConfig::notifications), (App)MemoryConfig.CODEC.fieldOf("memory").forGetter(PerformanceConfig::memory)).apply((Applicative)instance, PerformanceConfig::new));

        public static PerformanceConfig getDefault() {
            return new PerformanceConfig(NotificationConfig.getDefault(), MemoryConfig.getDefault());
        }
    }

    public record CommandsConfig(boolean enableDynamicRegistration, int maxRegisteredCommands, boolean persistCommands) {
        public static final Codec<CommandsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enableDynamicRegistration").forGetter(CommandsConfig::enableDynamicRegistration), (App)Codec.INT.fieldOf("maxRegisteredCommands").forGetter(CommandsConfig::maxRegisteredCommands), (App)Codec.BOOL.fieldOf("persistCommands").forGetter(CommandsConfig::persistCommands)).apply((Applicative)instance, CommandsConfig::new));

        public static CommandsConfig getDefault() {
            return new CommandsConfig(true, 100, true);
        }
    }

    public record DebugConfig(boolean debugMode, boolean logEventDetails, boolean logRpcCalls, boolean logPerformanceMetrics) {
        public static final Codec<DebugConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("debugMode").forGetter(DebugConfig::debugMode), (App)Codec.BOOL.fieldOf("logEventDetails").forGetter(DebugConfig::logEventDetails), (App)Codec.BOOL.fieldOf("logRpcCalls").forGetter(DebugConfig::logRpcCalls), (App)Codec.BOOL.fieldOf("logPerformanceMetrics").forGetter(DebugConfig::logPerformanceMetrics)).apply((Applicative)instance, DebugConfig::new));

        public static DebugConfig getDefault() {
            return new DebugConfig(false, false, false, false);
        }
    }

    public record SecurityConfig(boolean enablePermissionChecks, List<String> allowedRpcSources, int maxRpcRequestsPerMinute) {
        public static final Codec<SecurityConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enablePermissionChecks").forGetter(SecurityConfig::enablePermissionChecks), (App)Codec.STRING.listOf().fieldOf("allowedRpcSources").forGetter(SecurityConfig::allowedRpcSources), (App)Codec.INT.fieldOf("maxRpcRequestsPerMinute").forGetter(SecurityConfig::maxRpcRequestsPerMinute)).apply((Applicative)instance, SecurityConfig::new));

        public static SecurityConfig getDefault() {
            return new SecurityConfig(true, new ArrayList<String>(), 100);
        }
    }

    public record PlayerEventConfig(Map<String, PlayerEventSettings> playerSettings, PlayerEventSettings defaultSettings) {
        public static final Codec<PlayerEventConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, PlayerEventSettings.CODEC).fieldOf("playerSettings").forGetter(PlayerEventConfig::playerSettings), (App)PlayerEventSettings.CODEC.fieldOf("defaultSettings").forGetter(PlayerEventConfig::defaultSettings)).apply((Applicative)instance, PlayerEventConfig::new));

        public static PlayerEventConfig getDefault() {
            return new PlayerEventConfig(new ConcurrentHashMap<String, PlayerEventSettings>(), PlayerEventSettings.getDefault());
        }
    }

    public record PlayerEventSettings(Map<String, Boolean> eventOverrides, boolean inheritGlobalSettings) {
        public static final Codec<PlayerEventSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL).fieldOf("eventOverrides").forGetter(PlayerEventSettings::eventOverrides), (App)Codec.BOOL.fieldOf("inheritGlobalSettings").forGetter(PlayerEventSettings::inheritGlobalSettings)).apply((Applicative)instance, PlayerEventSettings::new));

        public static PlayerEventSettings getDefault() {
            return new PlayerEventSettings(new ConcurrentHashMap<String, Boolean>(), true);
        }
    }

    public record MemoryConfig(int maxPoolSize, boolean enableObjectPooling, int gcThresholdPercent) {
        public static final Codec<MemoryConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("maxPoolSize").forGetter(MemoryConfig::maxPoolSize), (App)Codec.BOOL.fieldOf("enableObjectPooling").forGetter(MemoryConfig::enableObjectPooling), (App)Codec.INT.fieldOf("gcThresholdPercent").forGetter(MemoryConfig::gcThresholdPercent)).apply((Applicative)instance, MemoryConfig::new));

        public static MemoryConfig getDefault() {
            return new MemoryConfig(1000, true, 85);
        }
    }

    public record NotificationConfig(int batchSize, int batchDelayMs, int maxQueuedNotifications, boolean enableBatching) {
        public static final Codec<NotificationConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("batchSize").forGetter(NotificationConfig::batchSize), (App)Codec.INT.fieldOf("batchDelayMs").forGetter(NotificationConfig::batchDelayMs), (App)Codec.INT.fieldOf("maxQueuedNotifications").forGetter(NotificationConfig::maxQueuedNotifications), (App)Codec.BOOL.fieldOf("enableBatching").forGetter(NotificationConfig::enableBatching)).apply((Applicative)instance, NotificationConfig::new));

        public static NotificationConfig getDefault() {
            return new NotificationConfig(100, 50, 10000, true);
        }
    }

    public record AdvancedEventsConfig(boolean lootGenerate, boolean redstoneUpdate) {
        public static final Codec<AdvancedEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("lootGenerate").forGetter(AdvancedEventsConfig::lootGenerate), (App)Codec.BOOL.fieldOf("redstoneUpdate").forGetter(AdvancedEventsConfig::redstoneUpdate)).apply((Applicative)instance, AdvancedEventsConfig::new));

        public static AdvancedEventsConfig getDefault() {
            return new AdvancedEventsConfig(false, false);
        }
    }

    public record PortalEventsConfig(boolean portalCreate, boolean portalUse) {
        public static final Codec<PortalEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("portalCreate").forGetter(PortalEventsConfig::portalCreate), (App)Codec.BOOL.fieldOf("portalUse").forGetter(PortalEventsConfig::portalUse)).apply((Applicative)instance, PortalEventsConfig::new));

        public static PortalEventsConfig getDefault() {
            return new PortalEventsConfig(false, false);
        }
    }

    public record CommandEventsConfig(boolean playerCommand, boolean commandMessage) {
        public static final Codec<CommandEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("playerCommand").forGetter(CommandEventsConfig::playerCommand), (App)Codec.BOOL.fieldOf("commandMessage").forGetter(CommandEventsConfig::commandMessage)).apply((Applicative)instance, CommandEventsConfig::new));

        public static CommandEventsConfig getDefault() {
            return new CommandEventsConfig(false, false);
        }
    }

    public record PvpEventsConfig(boolean playerKillPlayer) {
        public static final Codec<PvpEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("playerKillPlayer").forGetter(PvpEventsConfig::playerKillPlayer)).apply((Applicative)instance, PvpEventsConfig::new));

        public static PvpEventsConfig getDefault() {
            return new PvpEventsConfig(false);
        }
    }

    public record ExperienceEventsConfig(boolean expChange, boolean levelChange) {
        public static final Codec<ExperienceEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("expChange").forGetter(ExperienceEventsConfig::expChange), (App)Codec.BOOL.fieldOf("levelChange").forGetter(ExperienceEventsConfig::levelChange)).apply((Applicative)instance, ExperienceEventsConfig::new));

        public static ExperienceEventsConfig getDefault() {
            return new ExperienceEventsConfig(false, false);
        }
    }

    public record FurnaceEventsConfig(boolean furnaceSmelt, boolean furnaceBurn) {
        public static final Codec<FurnaceEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("furnaceSmelt").forGetter(FurnaceEventsConfig::furnaceSmelt), (App)Codec.BOOL.fieldOf("furnaceBurn").forGetter(FurnaceEventsConfig::furnaceBurn)).apply((Applicative)instance, FurnaceEventsConfig::new));

        public static FurnaceEventsConfig getDefault() {
            return new FurnaceEventsConfig(false, false);
        }
    }

    public record InventoryEventsConfig(boolean inventoryOpen, boolean inventoryClose) {
        public static final Codec<InventoryEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("inventoryOpen").forGetter(InventoryEventsConfig::inventoryOpen), (App)Codec.BOOL.fieldOf("inventoryClose").forGetter(InventoryEventsConfig::inventoryClose)).apply((Applicative)instance, InventoryEventsConfig::new));

        public static InventoryEventsConfig getDefault() {
            return new InventoryEventsConfig(false, false);
        }
    }

    public record ItemEventsConfig(boolean itemDrop, boolean itemPickup) {
        public static final Codec<ItemEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("itemDrop").forGetter(ItemEventsConfig::itemDrop), (App)Codec.BOOL.fieldOf("itemPickup").forGetter(ItemEventsConfig::itemPickup)).apply((Applicative)instance, ItemEventsConfig::new));

        public static ItemEventsConfig getDefault() {
            return new ItemEventsConfig(false, false);
        }
    }

    public record FishingEventsConfig(boolean fishingCast, boolean fishCaught) {
        public static final Codec<FishingEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("fishingCast").forGetter(FishingEventsConfig::fishingCast), (App)Codec.BOOL.fieldOf("fishCaught").forGetter(FishingEventsConfig::fishCaught)).apply((Applicative)instance, FishingEventsConfig::new));

        public static FishingEventsConfig getDefault() {
            return new FishingEventsConfig(false, false);
        }
    }

    public record InteractionEventsConfig(boolean playerInteractBlock, boolean playerInteractEntity) {
        public static final Codec<InteractionEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("playerInteractBlock").forGetter(InteractionEventsConfig::playerInteractBlock), (App)Codec.BOOL.fieldOf("playerInteractEntity").forGetter(InteractionEventsConfig::playerInteractEntity)).apply((Applicative)instance, InteractionEventsConfig::new));

        public static InteractionEventsConfig getDefault() {
            return new InteractionEventsConfig(false, false);
        }
    }

    public record WorldEventsConfig(boolean worldLoad, boolean worldUnload, boolean weatherChange) {
        public static final Codec<WorldEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("worldLoad").forGetter(WorldEventsConfig::worldLoad), (App)Codec.BOOL.fieldOf("worldUnload").forGetter(WorldEventsConfig::worldUnload), (App)Codec.BOOL.fieldOf("weatherChange").forGetter(WorldEventsConfig::weatherChange)).apply((Applicative)instance, WorldEventsConfig::new));

        public static WorldEventsConfig getDefault() {
            return new WorldEventsConfig(true, true, false);
        }
    }

    public record EntityEventsConfig(boolean entityDeath, boolean entityDamage, boolean entityMount, boolean entityBreeding) {
        public static final Codec<EntityEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("entityDeath").forGetter(EntityEventsConfig::entityDeath), (App)Codec.BOOL.fieldOf("entityDamage").forGetter(EntityEventsConfig::entityDamage), (App)Codec.BOOL.fieldOf("entityMount").forGetter(EntityEventsConfig::entityMount), (App)Codec.BOOL.fieldOf("entityBreeding").forGetter(EntityEventsConfig::entityBreeding)).apply((Applicative)instance, EntityEventsConfig::new));

        public static EntityEventsConfig getDefault() {
            return new EntityEventsConfig(true, false, true, true);
        }
    }

    public record BlockEventsConfig(boolean playerBreakBlock, boolean playerPlaceBlock) {
        public static final Codec<BlockEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("playerBreakBlock").forGetter(BlockEventsConfig::playerBreakBlock), (App)Codec.BOOL.fieldOf("playerPlaceBlock").forGetter(BlockEventsConfig::playerPlaceBlock)).apply((Applicative)instance, BlockEventsConfig::new));

        public static BlockEventsConfig getDefault() {
            return new BlockEventsConfig(true, true);
        }
    }

    public record PlayerMovementConfig(boolean enabled, int throttleTicks, double minimumDistance, boolean trackDimensionChanges, boolean trackTeleportation, List<String> excludedDimensions) {
        public static final Codec<PlayerMovementConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(PlayerMovementConfig::enabled), (App)Codec.INT.fieldOf("throttleTicks").forGetter(PlayerMovementConfig::throttleTicks), (App)Codec.DOUBLE.fieldOf("minimumDistance").forGetter(PlayerMovementConfig::minimumDistance), (App)Codec.BOOL.fieldOf("trackDimensionChanges").forGetter(PlayerMovementConfig::trackDimensionChanges), (App)Codec.BOOL.fieldOf("trackTeleportation").forGetter(PlayerMovementConfig::trackTeleportation), (App)Codec.STRING.listOf().fieldOf("excludedDimensions").forGetter(PlayerMovementConfig::excludedDimensions)).apply((Applicative)instance, PlayerMovementConfig::new));

        public static PlayerMovementConfig getDefault() {
            return new PlayerMovementConfig(false, 20, 0.1, true, true, new ArrayList<String>());
        }
    }

    public record PlayerEventsConfig(boolean playerRespawn, boolean playerGameModeChange, PlayerMovementConfig playerMovement, boolean playerToggleSneak, boolean playerToggleSprint, boolean playerToggleFlight, boolean playerWorldChange) {
        public static final Codec<PlayerEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("playerRespawn").forGetter(PlayerEventsConfig::playerRespawn), (App)Codec.BOOL.fieldOf("playerGameModeChange").forGetter(PlayerEventsConfig::playerGameModeChange), (App)PlayerMovementConfig.CODEC.fieldOf("playerMovement").forGetter(PlayerEventsConfig::playerMovement), (App)Codec.BOOL.fieldOf("playerToggleSneak").forGetter(PlayerEventsConfig::playerToggleSneak), (App)Codec.BOOL.fieldOf("playerToggleSprint").forGetter(PlayerEventsConfig::playerToggleSprint), (App)Codec.BOOL.fieldOf("playerToggleFlight").forGetter(PlayerEventsConfig::playerToggleFlight), (App)Codec.BOOL.fieldOf("playerWorldChange").forGetter(PlayerEventsConfig::playerWorldChange)).apply((Applicative)instance, PlayerEventsConfig::new));

        public static PlayerEventsConfig getDefault() {
            return new PlayerEventsConfig(true, true, PlayerMovementConfig.getDefault(), false, false, false, true);
        }
    }

    public record ServerEventsConfig(boolean serverStarting, boolean serverStarted, boolean serverStopping, boolean serverStopped, boolean dataPackReload) {
        public static final Codec<ServerEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("serverStarting").forGetter(ServerEventsConfig::serverStarting), (App)Codec.BOOL.fieldOf("serverStarted").forGetter(ServerEventsConfig::serverStarted), (App)Codec.BOOL.fieldOf("serverStopping").forGetter(ServerEventsConfig::serverStopping), (App)Codec.BOOL.fieldOf("serverStopped").forGetter(ServerEventsConfig::serverStopped), (App)Codec.BOOL.fieldOf("dataPackReload").forGetter(ServerEventsConfig::dataPackReload)).apply((Applicative)instance, ServerEventsConfig::new));

        public static ServerEventsConfig getDefault() {
            return new ServerEventsConfig(true, true, true, true, true);
        }
    }

    public record CoreEventsConfig(boolean playerChat, boolean playerDeath, boolean playerAdvancement, boolean playerJoined, boolean playerLeft, boolean customNotifications) {
        public static final Codec<CoreEventsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("playerChat").forGetter(CoreEventsConfig::playerChat), (App)Codec.BOOL.fieldOf("playerDeath").forGetter(CoreEventsConfig::playerDeath), (App)Codec.BOOL.fieldOf("playerAdvancement").forGetter(CoreEventsConfig::playerAdvancement), (App)Codec.BOOL.fieldOf("playerJoined").forGetter(CoreEventsConfig::playerJoined), (App)Codec.BOOL.fieldOf("playerLeft").forGetter(CoreEventsConfig::playerLeft), (App)Codec.BOOL.fieldOf("customNotifications").forGetter(CoreEventsConfig::customNotifications)).apply((Applicative)instance, CoreEventsConfig::new));

        public static CoreEventsConfig getDefault() {
            return new CoreEventsConfig(true, true, true, true, true, true);
        }
    }
}

