/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.events;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import msmp.plus.MsmplusMod;
import msmp.plus.config.ConfigManager;
import msmp.plus.events.EventProcessor;
import msmp.plus.events.EventType;
import msmp.plus.management.ModOutgoingRpcMethods;
import msmp.plus.management.RpcDynamicNotification;
import msmp.plus.mixin.ManagementServerAccessor;
import msmp.plus.mixin.MinecraftDedicatedServerAccessor;
import net.minecraft.class_11807;
import net.minecraft.class_11808;
import net.minecraft.class_3176;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class EventBroadcaster {
    private static final Gson GSON = new GsonBuilder().create();
    private static class_3176 dedicatedServer;

    public static void initialize(MinecraftServer server) {
        if (server instanceof class_3176) {
            class_3176 dedicatedServer;
            EventBroadcaster.dedicatedServer = dedicatedServer = (class_3176)server;
            MsmplusMod.LOGGER.info("EventBroadcaster initialized with dedicated server");
        } else {
            MsmplusMod.LOGGER.error("EventBroadcaster: Server is not a MinecraftDedicatedServer!");
        }
    }

    public static void broadcast(EventType type, List<EventProcessor.EventInstance> events) {
        boolean logRpcCalls = ConfigManager.getConfig().debug().logRpcCalls();
        if (logRpcCalls) {
            System.out.println("[DEBUG] EventBroadcaster.broadcast() called with " + events.size() + " events of type: " + type.getEventName());
        }
        if (events == null || events.isEmpty()) {
            return;
        }
        boolean logDetails = ConfigManager.getConfig().debug().logEventDetails();
        for (EventProcessor.EventInstance event : events) {
            try {
                if (logRpcCalls) {
                    System.out.println("[DEBUG] Broadcasting event: " + type.getEventName() + " for player: " + event.playerUuid());
                }
                boolean shouldBroadcast = false;
                shouldBroadcast = event.playerUuid() != null ? type.isEnabledForPlayer(event.playerUuid()) : type.isEnabled();
                if (!shouldBroadcast) {
                    if (!logDetails) continue;
                    MsmplusMod.LOGGER.debug("Event {} skipped (disabled for player {})", (Object)type.getEventName(), (Object)event.playerUuid());
                    continue;
                }
                EventBroadcaster.broadcastEvent(type, event);
                if (!logDetails) continue;
                MsmplusMod.LOGGER.debug("Broadcasted event: {} (player: {})", (Object)type.getEventName(), (Object)event.playerUuid());
            }
            catch (Exception e) {
                MsmplusMod.LOGGER.error("Error broadcasting event {} for player {}", new Object[]{type.getEventName(), event.playerUuid(), e});
            }
        }
    }

    private static void broadcastEvent(EventType type, EventProcessor.EventInstance event) {
        boolean logRpcCalls = ConfigManager.getConfig().debug().logRpcCalls();
        class_6880.class_6883<class_11808<RpcDynamicNotification, ?>> method = ModOutgoingRpcMethods.getEventMethod(type);
        if (method == null) {
            MsmplusMod.LOGGER.warn("No RPC method registered for event type: {}", (Object)type.getEventName());
            return;
        }
        if (dedicatedServer == null) {
            if (logRpcCalls) {
                System.out.println("[DEBUG] EventBroadcaster: dedicatedServer is null!");
            }
            MsmplusMod.LOGGER.error("EventBroadcaster: dedicatedServer is null for event {}", (Object)type.getEventName());
            return;
        }
        try {
            RpcDynamicNotification notification = new RpcDynamicNotification(EventBroadcaster.formatEventData(type, event), event.timestamp(), type.getMsmpMethod());
            class_11807 managementServer = ((MinecraftDedicatedServerAccessor)dedicatedServer).getManagementServer();
            if (managementServer != null) {
                if (logRpcCalls) {
                    System.out.println("[DEBUG] EventBroadcaster: ManagementServer found, sending notification");
                }
                ((ManagementServerAccessor)managementServer).invokeForEachConnection(connection -> {
                    try {
                        if (logRpcCalls) {
                            System.out.println("[DEBUG] EventBroadcaster: Attempting to send notification " + type.getEventName() + " via method " + method.method_40230().toString());
                            System.out.println("[DEBUG] EventBroadcaster: Notification data: " + notification.data());
                        }
                        connection.method_73609(method, (Object)notification);
                        if (logRpcCalls) {
                            System.out.println("[DEBUG] EventBroadcaster: Successfully sent notification " + type.getEventName());
                        }
                    }
                    catch (Exception e) {
                        if (logRpcCalls) {
                            System.out.println("[DEBUG] EventBroadcaster: Failed to send notification " + type.getEventName() + ": " + e.getMessage());
                            e.printStackTrace();
                        }
                        MsmplusMod.LOGGER.error("Failed to send {} notification: {}", (Object)type.getEventName(), (Object)e.getMessage());
                    }
                });
            } else if (logRpcCalls) {
                System.out.println("[DEBUG] EventBroadcaster: ManagementServer is null!");
            }
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to broadcast event {}: {}", (Object)type.getEventName(), (Object)e.getMessage());
        }
    }

    private static String formatEventData(EventType type, EventProcessor.EventInstance event) {
        Object data = event.data();
        if (data instanceof Map) {
            Map originalMap = (Map)data;
            HashMap<String, Object> dataMap = new HashMap<String, Object>(originalMap);
            dataMap.put("eventType", type.getEventName());
            dataMap.put("category", type.getCategory().name());
            if (!dataMap.containsKey("timestamp")) {
                dataMap.put("timestamp", event.timestamp());
            }
            return GSON.toJson(dataMap);
        }
        if (data instanceof String) {
            return (String)data;
        }
        Map<String, Object> envelope = Map.of("eventType", type.getEventName(), "category", type.getCategory().name(), "timestamp", event.timestamp(), "playerUuid", event.playerUuid() != null ? event.playerUuid() : "", "data", data);
        return GSON.toJson(envelope);
    }

    public static void broadcastPlayerMoveEvent(EventProcessor.EventInstance event) {
        EventBroadcaster.broadcastEvent(EventType.PLAYER_MOVE, event);
    }

    public static void broadcastBlockBreakEvent(EventProcessor.EventInstance event) {
        EventBroadcaster.broadcastEvent(EventType.PLAYER_BREAK_BLOCK_AFTER, event);
    }

    public static void broadcastEntityDeathEvent(EventProcessor.EventInstance event) {
        EventBroadcaster.broadcastEvent(EventType.ENTITY_DEATH, event);
    }
}

