/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.events;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import msmp.plus.events.EventCategory;
import msmp.plus.events.EventType;

public class EventMetrics {
    private static final Map<EventType, AtomicLong> processedCounts = new ConcurrentHashMap<EventType, AtomicLong>();
    private static final Map<EventType, AtomicLong> droppedCounts = new ConcurrentHashMap<EventType, AtomicLong>();
    private static final Map<EventType, AtomicLong> failedCounts = new ConcurrentHashMap<EventType, AtomicLong>();
    private static final Map<EventType, LongAdder> processingTimes = new ConcurrentHashMap<EventType, LongAdder>();
    private static final LongAdder totalBatchProcessingTime = new LongAdder();
    private static final AtomicLong totalBatchesProcessed = new AtomicLong();
    private static final AtomicLong totalEventsProcessed = new AtomicLong();

    public static void incrementProcessed(EventType type, int count) {
        processedCounts.computeIfAbsent(type, k -> new AtomicLong()).addAndGet(count);
        totalEventsProcessed.addAndGet(count);
    }

    public static void incrementDropped(EventType type) {
        droppedCounts.computeIfAbsent(type, k -> new AtomicLong()).incrementAndGet();
    }

    public static void incrementFailed(EventType type, int count) {
        failedCounts.computeIfAbsent(type, k -> new AtomicLong()).addAndGet(count);
    }

    public static void recordProcessingTime(EventType type, long timeMs) {
        processingTimes.computeIfAbsent(type, k -> new LongAdder()).add(timeMs);
    }

    public static void recordBatchProcessingTime(long timeMs, int eventCount) {
        totalBatchProcessingTime.add(timeMs);
        totalBatchesProcessed.incrementAndGet();
    }

    public static EventMetricsSnapshot getSnapshot() {
        HashMap<EventType, Long> processed = new HashMap<EventType, Long>();
        HashMap<EventType, Long> dropped = new HashMap<EventType, Long>();
        HashMap<EventType, Long> failed = new HashMap<EventType, Long>();
        HashMap<EventType, Long> totalTimes = new HashMap<EventType, Long>();
        for (EventType type : EventType.values()) {
            processed.put(type, processedCounts.getOrDefault((Object)type, new AtomicLong()).get());
            dropped.put(type, droppedCounts.getOrDefault((Object)type, new AtomicLong()).get());
            failed.put(type, failedCounts.getOrDefault((Object)type, new AtomicLong()).get());
            totalTimes.put(type, processingTimes.getOrDefault((Object)type, new LongAdder()).sum());
        }
        return new EventMetricsSnapshot(processed, dropped, failed, totalTimes, totalEventsProcessed.get(), totalBatchesProcessed.get(), totalBatchProcessingTime.sum());
    }

    public static long getProcessedCount(EventType type) {
        return processedCounts.getOrDefault((Object)type, new AtomicLong()).get();
    }

    public static long getDroppedCount(EventType type) {
        return droppedCounts.getOrDefault((Object)type, new AtomicLong()).get();
    }

    public static long getFailedCount(EventType type) {
        return failedCounts.getOrDefault((Object)type, new AtomicLong()).get();
    }

    public static void reset() {
        processedCounts.clear();
        droppedCounts.clear();
        failedCounts.clear();
        processingTimes.clear();
        totalBatchProcessingTime.reset();
        totalBatchesProcessed.set(0L);
        totalEventsProcessed.set(0L);
    }

    public static void resetForType(EventType type) {
        processedCounts.remove((Object)type);
        droppedCounts.remove((Object)type);
        failedCounts.remove((Object)type);
        processingTimes.remove((Object)type);
    }

    public record EventMetricsSnapshot(Map<EventType, Long> processedCounts, Map<EventType, Long> droppedCounts, Map<EventType, Long> failedCounts, Map<EventType, Long> totalProcessingTimes, long totalEventsProcessed, long totalBatchesProcessed, long totalBatchProcessingTime) {
        public double getSuccessRate(EventType type) {
            long failed;
            long processed = this.processedCounts.getOrDefault((Object)type, 0L);
            long total = processed + (failed = this.failedCounts.getOrDefault((Object)type, 0L).longValue());
            return total > 0L ? (double)processed / (double)total : 1.0;
        }

        public double getAverageProcessingTime(EventType type) {
            long totalTime = this.totalProcessingTimes.getOrDefault((Object)type, 0L);
            long count = this.processedCounts.getOrDefault((Object)type, 0L);
            return count > 0L ? (double)totalTime / (double)count : 0.0;
        }

        public double getAverageBatchProcessingTime() {
            return this.totalBatchesProcessed > 0L ? (double)this.totalBatchProcessingTime / (double)this.totalBatchesProcessed : 0.0;
        }

        public double getAverageBatchSize() {
            return this.totalBatchesProcessed > 0L ? (double)this.totalEventsProcessed / (double)this.totalBatchesProcessed : 0.0;
        }

        public long getTotalDropped() {
            return this.droppedCounts.values().stream().mapToLong(Long::longValue).sum();
        }

        public long getTotalFailed() {
            return this.failedCounts.values().stream().mapToLong(Long::longValue).sum();
        }

        public double getOverallSuccessRate() {
            long total = this.totalEventsProcessed + this.getTotalFailed();
            return total > 0L ? (double)this.totalEventsProcessed / (double)total : 1.0;
        }

        public Map<EventCategory, CategoryMetrics> getMetricsByCategory() {
            HashMap<EventCategory, CategoryMetrics> categoryMetrics = new HashMap<EventCategory, CategoryMetrics>();
            for (EventType type : EventType.values()) {
                EventCategory category = type.getCategory();
                CategoryMetrics metrics = categoryMetrics.getOrDefault((Object)category, new CategoryMetrics(0L, 0L, 0L, 0L));
                long processed = this.processedCounts.getOrDefault((Object)type, 0L);
                long dropped = this.droppedCounts.getOrDefault((Object)type, 0L);
                long failed = this.failedCounts.getOrDefault((Object)type, 0L);
                long time = this.totalProcessingTimes.getOrDefault((Object)type, 0L);
                categoryMetrics.put(category, new CategoryMetrics(metrics.processed() + processed, metrics.dropped() + dropped, metrics.failed() + failed, metrics.totalProcessingTime() + time));
            }
            return categoryMetrics;
        }

        public record CategoryMetrics(long processed, long dropped, long failed, long totalProcessingTime) {
            public double getSuccessRate() {
                long total = this.processed + this.failed;
                return total > 0L ? (double)this.processed / (double)total : 1.0;
            }

            public double getAverageProcessingTime() {
                return this.processed > 0L ? (double)this.totalProcessingTime / (double)this.processed : 0.0;
            }
        }
    }
}

