/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import msmp.plus.MsmplusMod;
import msmp.plus.config.ConfigManager;
import msmp.plus.config.EnhancedConfig;
import msmp.plus.events.EventBroadcaster;
import msmp.plus.events.EventMetrics;
import msmp.plus.events.EventType;

public class EventProcessor {
    private static final Map<EventType, BlockingQueue<EventInstance>> eventQueues = new ConcurrentHashMap<EventType, BlockingQueue<EventInstance>>();
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "MSMPlus-EventProcessor");
        t.setDaemon(true);
        return t;
    });
    private static volatile boolean initialized = false;
    private static ScheduledFuture<?> processorTask;

    public static void initialize() {
        if (initialized) {
            return;
        }
        EnhancedConfig.NotificationConfig notifConfig = ConfigManager.getConfig().performance().notifications();
        long delayMs = notifConfig.batchDelayMs();
        processorTask = scheduler.scheduleAtFixedRate(EventProcessor::processQueuedEvents, delayMs, delayMs, TimeUnit.MILLISECONDS);
        ConfigManager.addListener(event -> {
            if (event.hasPerformanceConfigChanged()) {
                EventProcessor.restartProcessor();
            }
        });
        initialized = true;
        MsmplusMod.LOGGER.info("Event processor initialized with {}ms batch delay", (Object)delayMs);
    }

    public static void shutdown() {
        if (processorTask != null) {
            processorTask.cancel(false);
        }
        scheduler.shutdown();
        initialized = false;
    }

    private static void restartProcessor() {
        if (processorTask != null) {
            processorTask.cancel(false);
        }
        EnhancedConfig.NotificationConfig notifConfig = ConfigManager.getConfig().performance().notifications();
        long delayMs = notifConfig.batchDelayMs();
        processorTask = scheduler.scheduleAtFixedRate(EventProcessor::processQueuedEvents, delayMs, delayMs, TimeUnit.MILLISECONDS);
        MsmplusMod.LOGGER.info("Event processor restarted with {}ms batch delay", (Object)delayMs);
    }

    public static void submit(EventType type, Object eventData) {
        EventProcessor.submit(type, eventData, null);
    }

    public static void submit(EventType type, Object eventData, String playerUuid) {
        if (!initialized) {
            EventProcessor.initialize();
        }
        EnhancedConfig.NotificationConfig notifConfig = ConfigManager.getConfig().performance().notifications();
        EventInstance instance = new EventInstance(type, eventData, System.currentTimeMillis(), playerUuid);
        if (ConfigManager.getConfig().debug().logEventDetails()) {
            System.out.println("[DEBUG] EventProcessor.submit() - Creating event: " + type.getEventName() + " for player: " + playerUuid);
        }
        BlockingQueue queue = eventQueues.computeIfAbsent(type, k -> new ArrayBlockingQueue(notifConfig.maxQueuedNotifications()));
        boolean offered = queue.offer(instance);
        if (ConfigManager.getConfig().debug().logEventDetails()) {
            System.out.println("[DEBUG] EventProcessor.submit() - Event queued: " + offered + " (queue size: " + queue.size() + ")");
        }
        if (!offered) {
            MsmplusMod.LOGGER.warn("Event queue full for type: {} (dropped event)", (Object)type.getEventName());
            EventMetrics.incrementDropped(type);
        }
    }

    private static void processQueuedEvents() {
        try {
            EnhancedConfig.NotificationConfig notifConfig = ConfigManager.getConfig().performance().notifications();
            int batchSize = notifConfig.batchSize();
            boolean enableBatching = notifConfig.enableBatching();
            if (!enableBatching) {
                batchSize = 1;
            }
            ArrayList<EventInstance> batch = new ArrayList<EventInstance>();
            for (Map.Entry<EventType, BlockingQueue<EventInstance>> entry : eventQueues.entrySet()) {
                BlockingQueue<EventInstance> queue = entry.getValue();
                int toTake = Math.min(batchSize - batch.size(), queue.size());
                for (int i = 0; i < toTake; ++i) {
                    EventInstance event = (EventInstance)queue.poll();
                    if (event == null) continue;
                    batch.add(event);
                }
                if (batch.size() < batchSize) continue;
                break;
            }
            if (!batch.isEmpty()) {
                if (ConfigManager.getConfig().debug().logEventDetails()) {
                    System.out.println("[DEBUG] processQueuedEvents() - Processing batch of " + batch.size() + " events");
                    for (EventInstance event : batch) {
                        System.out.println("[DEBUG] - Event in batch: " + event.type().getEventName());
                    }
                }
                EventProcessor.processBatch(batch);
            }
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Error processing event queue", (Throwable)e);
        }
    }

    private static void processBatch(List<EventInstance> batch) {
        long startTime = System.currentTimeMillis();
        HashMap<EventType, List> groupedEvents = new HashMap<EventType, List>();
        for (EventInstance eventInstance : batch) {
            groupedEvents.computeIfAbsent(eventInstance.type(), k -> new ArrayList()).add(eventInstance);
        }
        for (Map.Entry entry : groupedEvents.entrySet()) {
            EventType type = (EventType)((Object)entry.getKey());
            List events = (List)entry.getValue();
            try {
                EventBroadcaster.broadcast(type, events);
                EventMetrics.incrementProcessed(type, events.size());
            }
            catch (Exception e) {
                MsmplusMod.LOGGER.error("Failed to broadcast events of type: {}", (Object)type.getEventName(), (Object)e);
                EventMetrics.incrementFailed(type, events.size());
            }
        }
        long processingTime = System.currentTimeMillis() - startTime;
        EventMetrics.recordBatchProcessingTime(processingTime, batch.size());
        if (ConfigManager.getConfig().debug().logPerformanceMetrics() && processingTime > 100L) {
            MsmplusMod.LOGGER.debug("Processed batch of {} events in {}ms", (Object)batch.size(), (Object)processingTime);
        }
    }

    public static int getQueueSize(EventType type) {
        BlockingQueue<EventInstance> queue = eventQueues.get((Object)type);
        return queue != null ? queue.size() : 0;
    }

    public static int getTotalQueueSize() {
        return eventQueues.values().stream().mapToInt(Collection::size).sum();
    }

    public static Map<EventType, Integer> getQueueSizes() {
        HashMap<EventType, Integer> sizes = new HashMap<EventType, Integer>();
        for (Map.Entry<EventType, BlockingQueue<EventInstance>> entry : eventQueues.entrySet()) {
            sizes.put(entry.getKey(), entry.getValue().size());
        }
        return sizes;
    }

    public static void clearQueue(EventType type) {
        BlockingQueue<EventInstance> queue = eventQueues.get((Object)type);
        if (queue != null) {
            int cleared = queue.size();
            queue.clear();
            MsmplusMod.LOGGER.info("Cleared {} events from queue for type: {}", (Object)cleared, (Object)type.getEventName());
        }
    }

    public static void clearAllQueues() {
        int totalCleared = 0;
        for (BlockingQueue<EventInstance> queue : eventQueues.values()) {
            totalCleared += queue.size();
            queue.clear();
        }
        MsmplusMod.LOGGER.info("Cleared {} total events from all queues", (Object)totalCleared);
    }

    public record EventInstance(EventType type, Object data, long timestamp, String playerUuid) {
    }
}

