/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.events;

import msmp.plus.config.ConfigManager;
import msmp.plus.events.EventCategory;

public enum EventType {
    SERVER_STARTING("server_starting", "plus:notification/server/starting", EventCategory.SERVER),
    SERVER_STARTED("server_started", "minecraft:notification/server/started", EventCategory.SERVER),
    SERVER_STOPPING("server_stopping", "plus:notification/server/stopping", EventCategory.SERVER),
    SERVER_STOPPED("server_stopped", "minecraft:notification/server/stopping", EventCategory.SERVER),
    DATA_PACK_RELOAD("data_pack_reload", "plus:notification/server/datapack", EventCategory.SERVER),
    PLAYER_CHAT("player_chat", "plus:notification/chat/message", EventCategory.PLAYER),
    PLAYER_DEATH("player_death", "plus:notification/player/death", EventCategory.PLAYER),
    PLAYER_ADVANCEMENT("player_advancement", "plus:notification/player/advancement", EventCategory.PLAYER),
    PLAYER_JOINED("player_joined", "minecraft:notification/players/joined", EventCategory.PLAYER),
    PLAYER_LEFT("player_left", "minecraft:notification/players/left", EventCategory.PLAYER),
    CUSTOM_NOTIFICATION("custom_notifications", "plus:notification/custom_event", EventCategory.PLAYER),
    PLAYER_RESPAWNED("player_respawn", "plus:notification/player/respawn", EventCategory.PLAYER),
    PLAYER_MOVE("player_move", "plus:notification/player/move", EventCategory.PLAYER),
    PLAYER_GAME_MODE_CHANGE("player_game_mode_change", "plus:notification/player/gamemode", EventCategory.PLAYER),
    PLAYER_TOGGLE_SNEAK("player_toggle_sneak", "plus:notification/player/sneak", EventCategory.PLAYER),
    PLAYER_TOGGLE_SPRINT("player_toggle_sprint", "plus:notification/player/sprint", EventCategory.PLAYER),
    PLAYER_TOGGLE_FLIGHT("player_toggle_flight", "plus:notification/player/flight", EventCategory.PLAYER),
    PLAYER_WORLD_CHANGE("player_world_change", "plus:notification/player/world_change", EventCategory.PLAYER),
    PLAYER_BREAK_BLOCK_BEFORE("player_break_block_before", "plus:notification/block/break_before", EventCategory.BLOCK),
    PLAYER_BREAK_BLOCK_AFTER("player_break_block_after", "plus:notification/block/break_after", EventCategory.BLOCK),
    PLAYER_PLACE_BLOCK_BEFORE("player_place_block_before", "plus:notification/block/place_before", EventCategory.BLOCK),
    PLAYER_PLACE_BLOCK_AFTER("player_place_block_after", "plus:notification/block/place_after", EventCategory.BLOCK),
    ENTITY_DEATH("entity_death", "plus:notification/entity/death", EventCategory.ENTITY),
    ENTITY_DAMAGE("entity_damage", "plus:notification/entity/damage", EventCategory.ENTITY),
    ENTITY_MOUNT("entity_mount", "plus:notification/entity/mount", EventCategory.ENTITY),
    ENTITY_DISMOUNT("entity_dismount", "plus:notification/entity/dismount", EventCategory.ENTITY),
    ENTITY_BREEDING("entity_breeding", "plus:notification/entity/breeding", EventCategory.ENTITY),
    WORLD_LOAD("world_load", "plus:notification/world/loaded", EventCategory.WORLD),
    WORLD_UNLOAD("world_unload", "plus:notification/world/unloaded", EventCategory.WORLD),
    WEATHER_CHANGE("weather_change", "plus:notification/world/weather", EventCategory.WORLD),
    TIME_CHANGE("time_change", "plus:notification/world/time", EventCategory.WORLD),
    EXPLOSION("explosion", "plus:notification/world/explosion", EventCategory.WORLD),
    PLAYER_INTERACT_BLOCK("player_interact_block", "plus:notification/interaction/block", EventCategory.INTERACTION),
    PLAYER_INTERACT_ENTITY("player_interact_entity", "plus:notification/interaction/entity", EventCategory.INTERACTION),
    PLAYER_INTERACT_AIR("player_interact_air", "plus:notification/interaction/air", EventCategory.INTERACTION),
    PLAYER_BED_ENTER("player_bed_enter", "plus:notification/interaction/bed_enter", EventCategory.INTERACTION),
    PLAYER_BED_LEAVE("player_bed_leave", "plus:notification/interaction/bed_leave", EventCategory.INTERACTION),
    PLAYER_FISHING_CAST("fishing_cast", "plus:notification/fishing/cast", EventCategory.FISHING),
    PLAYER_FISH_CAUGHT("fish_caught", "plus:notification/fishing/caught", EventCategory.FISHING),
    PLAYER_FISH_ESCAPE("player_fish_escape", "plus:notification/fishing/escape", EventCategory.FISHING),
    PLAYER_FISHING_REEL_IN("player_fishing_reel_in", "plus:notification/fishing/reel", EventCategory.FISHING),
    PLAYER_FISH_BITE("player_fish_bite", "plus:notification/fishing/bite", EventCategory.FISHING),
    PLAYER_ITEM_DROP("item_drop", "plus:notification/item/drop", EventCategory.ITEM),
    PLAYER_ITEM_PICKUP("item_pickup", "plus:notification/item/pickup", EventCategory.ITEM),
    PLAYER_USE_ITEM("player_use_item", "plus:notification/item/use", EventCategory.ITEM),
    PLAYER_CONSUME_ITEM("player_consume_item", "plus:notification/item/consume", EventCategory.ITEM),
    PLAYER_ITEM_BREAK("player_item_break", "plus:notification/item/break", EventCategory.ITEM),
    PLAYER_SWAP_HAND_ITEMS("player_swap_hand_items", "plus:notification/item/swap", EventCategory.ITEM),
    PLAYER_HELD_ITEM_CHANGE("player_held_item_change", "plus:notification/item/held_change", EventCategory.ITEM),
    PLAYER_INVENTORY_OPEN("inventory_open", "plus:notification/inventory/open", EventCategory.INVENTORY),
    PLAYER_INVENTORY_CLOSE("inventory_close", "plus:notification/inventory/close", EventCategory.INVENTORY),
    PLAYER_INVENTORY_CLICK("player_inventory_click", "plus:notification/inventory/click", EventCategory.INVENTORY),
    PLAYER_INVENTORY_DRAG("player_inventory_drag", "plus:notification/inventory/drag", EventCategory.INVENTORY),
    FURNACE_SMELT("furnace_smelt", "plus:notification/furnace/smelt", EventCategory.FURNACE),
    FURNACE_BURN("furnace_burn", "plus:notification/furnace/burn", EventCategory.FURNACE),
    FURNACE_EXTRACT("furnace_extract", "plus:notification/furnace/extract", EventCategory.FURNACE),
    FURNACE_START_SMELT("furnace_start_smelt", "plus:notification/furnace/start", EventCategory.FURNACE),
    PLAYER_EXP_CHANGE("exp_change", "plus:notification/experience/exp", EventCategory.EXPERIENCE),
    PLAYER_LEVEL_CHANGE("level_change", "plus:notification/experience/level", EventCategory.EXPERIENCE),
    PLAYER_KILL_PLAYER("player_kill_player", "plus:notification/pvp/kill", EventCategory.PVP),
    PLAYER_COMMAND("player_command", "plus:notification/command/execute", EventCategory.COMMAND),
    COMMAND_MESSAGE("command_message", "plus:notification/command/message", EventCategory.COMMAND),
    PLAYER_TAB_COMPLETE("player_tab_complete", "plus:notification/command/complete", EventCategory.COMMAND),
    PLAYER_PORTAL_CREATE("portal_create", "plus:notification/portal/create", EventCategory.PORTAL),
    PLAYER_PORTAL_USE("portal_use", "plus:notification/portal/use", EventCategory.PORTAL),
    LOOT_GENERATE("loot_generate", "plus:notification/advanced/loot", EventCategory.ADVANCED),
    REDSTONE_UPDATE("redstone_update", "plus:notification/advanced/redstone", EventCategory.ADVANCED),
    PROJECTILE_KILL("projectile_kill", "plus:notification/advanced/projectile", EventCategory.ADVANCED),
    ENTITY_HEAL("entity_heal", "plus:notification/advanced/heal", EventCategory.ADVANCED),
    MERCHANT_INTERACTION("merchant_interaction", "plus:notification/advanced/merchant", EventCategory.ADVANCED),
    CHUNK_LOAD("chunk_load", "plus:notification/advanced/chunk_load", EventCategory.ADVANCED),
    CHUNK_UNLOAD("chunk_unload", "plus:notification/advanced/chunk_unload", EventCategory.ADVANCED);

    private final String eventName;
    private final String msmpMethod;
    private final EventCategory category;

    private EventType(String eventName, String msmpMethod, EventCategory category) {
        this.eventName = eventName;
        this.msmpMethod = msmpMethod;
        this.category = category;
    }

    public boolean isEnabled() {
        return ConfigManager.isEventEnabled(this.eventName);
    }

    public boolean isEnabledForPlayer(String playerUuid) {
        return ConfigManager.isEventEnabledForPlayer(this.eventName, playerUuid);
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getMsmpMethod() {
        return this.msmpMethod;
    }

    public EventCategory getCategory() {
        return this.category;
    }

    public static EventType fromName(String name) {
        for (EventType type : EventType.values()) {
            if (!type.eventName.equals(name)) continue;
            return type;
        }
        return null;
    }
}

