/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.management;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import msmp.plus.MsmplusMod;
import msmp.plus.events.EventCategory;
import msmp.plus.events.EventType;
import msmp.plus.management.ModRpcSchema;
import msmp.plus.management.RpcChatMessage;
import msmp.plus.management.RpcDynamicNotification;
import msmp.plus.management.RpcPlayerAdvancementMessage;
import msmp.plus.management.RpcPlayerDeathMessage;
import net.minecraft.class_11808;
import net.minecraft.class_11817;
import net.minecraft.class_11818;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class ModOutgoingRpcMethods {
    public static class_6880.class_6883<class_11808<RpcChatMessage, ?>> CHAT_MESSAGE_NOTIFICATION;
    public static class_6880.class_6883<class_11808<RpcPlayerDeathMessage, ?>> PLAYER_DEATH_NOTIFICATION;
    public static class_6880.class_6883<class_11808<RpcPlayerAdvancementMessage, ?>> PLAYER_ADVANCEMENT_NOTIFICATION;
    public static class_6880.class_6883<class_11808<RpcDynamicNotification, ?>> DYNAMIC_NOTIFICATION;
    private static final Map<EventType, class_6880.class_6883<class_11808<RpcDynamicNotification, ?>>> EVENT_METHODS;

    public static void initialize() {
        ModOutgoingRpcMethods.registerDynamicNotification();
        ModOutgoingRpcMethods.registerAllEventTypes();
        MsmplusMod.LOGGER.info("MSMPlus notification methods initialized ({} individual event methods)", (Object)EVENT_METHODS.size());
    }

    private static void registerAllEventTypes() {
        for (EventType eventType : EventType.values()) {
            ModOutgoingRpcMethods.registerEventType(eventType);
        }
    }

    private static void registerEventType(EventType eventType) {
        if (eventType.getMsmpMethod().startsWith("minecraft:")) {
            MsmplusMod.LOGGER.debug("Skipping minecraft: namespace event: {}", (Object)eventType.getEventName());
            return;
        }
        if (!eventType.isEnabled()) {
            MsmplusMod.LOGGER.debug("Skipping disabled event: {}", (Object)eventType.getEventName());
            return;
        }
        String description = ModOutgoingRpcMethods.getEventDescription(eventType);
        class_11817 methodInfo = new class_11817(description, Optional.of(new class_11818("notification", ModRpcSchema.DYNAMIC_NOTIFICATION.method_73727())), Optional.empty());
        class_11808.class_12055 attributes = new class_11808.class_12055(true);
        class_11808.class_11810 method = new class_11808.class_11810(methodInfo, attributes, RpcDynamicNotification.CODEC);
        class_2960 id = ModOutgoingRpcMethods.parseIdentifier(eventType.getMsmpMethod());
        class_2378.method_10230((class_2378)class_7923.field_62491, (class_2960)id, (Object)method);
        class_6880.class_6883 reference = class_7923.field_62491.method_10223(id).orElse(null);
        if (reference != null) {
            EVENT_METHODS.put(eventType, reference);
        } else {
            MsmplusMod.LOGGER.error("Failed to register event type: {}", (Object)eventType.getEventName());
        }
    }

    private static String getEventDescription(EventType eventType) {
        return (switch (eventType.getCategory()) {
            default -> throw new MatchException(null, null);
            case EventCategory.SERVER -> "Server " + eventType.getEventName().replace("_", " ");
            case EventCategory.PLAYER -> "Player " + eventType.getEventName().replace("_", " ").replace("player ", "");
            case EventCategory.BLOCK -> "Block " + eventType.getEventName().replace("_", " ").replace("player ", "");
            case EventCategory.ENTITY -> "Entity " + eventType.getEventName().replace("_", " ");
            case EventCategory.WORLD -> "World " + eventType.getEventName().replace("_", " ");
            case EventCategory.INTERACTION -> "Player " + eventType.getEventName().replace("_", " ").replace("player ", "");
            case EventCategory.FISHING -> "Fishing " + eventType.getEventName().replace("_", " ");
            case EventCategory.ITEM -> "Item " + eventType.getEventName().replace("_", " ").replace("player ", "");
            case EventCategory.INVENTORY -> "Inventory " + eventType.getEventName().replace("_", " ").replace("player ", "");
            case EventCategory.FURNACE -> "Furnace " + eventType.getEventName().replace("_", " ");
            case EventCategory.EXPERIENCE -> "Experience " + eventType.getEventName().replace("_", " ").replace("player ", "");
            case EventCategory.PVP -> "PvP " + eventType.getEventName().replace("_", " ");
            case EventCategory.COMMAND -> "Command " + eventType.getEventName().replace("_", " ");
            case EventCategory.PORTAL -> "Portal " + eventType.getEventName().replace("_", " ").replace("player ", "");
            case EventCategory.ADVANCED -> "Advanced " + eventType.getEventName().replace("_", " ");
        }) + " event notification";
    }

    private static class_2960 parseIdentifier(String msmpMethod) {
        if (msmpMethod.startsWith("minecraft:")) {
            String path = msmpMethod.substring("minecraft:".length());
            return class_2960.method_60655((String)"minecraft", (String)path);
        }
        if (msmpMethod.startsWith("plus:")) {
            String path = msmpMethod.substring("plus:".length());
            return class_2960.method_60655((String)"plus", (String)path);
        }
        return class_2960.method_60655((String)"plus", (String)msmpMethod);
    }

    public static class_6880.class_6883<class_11808<RpcDynamicNotification, ?>> getEventMethod(EventType eventType) {
        if (eventType.getMsmpMethod().startsWith("minecraft:")) {
            return DYNAMIC_NOTIFICATION;
        }
        class_6880.class_6883<class_11808<RpcDynamicNotification, ?>> method = EVENT_METHODS.get((Object)eventType);
        if (method != null) {
            return method;
        }
        return DYNAMIC_NOTIFICATION;
    }

    private static void registerChatNotification() {
        class_11817 methodInfo = new class_11817("Player chat message notification", Optional.of(new class_11818("message", ModRpcSchema.CHAT_MESSAGE.method_73727())), Optional.empty());
        class_11808.class_12055 attributes = new class_11808.class_12055(true);
        class_11808.class_11810 method = new class_11808.class_11810(methodInfo, attributes, RpcChatMessage.CODEC);
        class_2960 id = class_2960.method_60655((String)"plus", (String)"notification/chat/message");
        class_2378.method_10230((class_2378)class_7923.field_62491, (class_2960)id, (Object)method);
        CHAT_MESSAGE_NOTIFICATION = class_7923.field_62491.method_10223(id).orElse(null);
        if (CHAT_MESSAGE_NOTIFICATION == null) {
            MsmplusMod.LOGGER.error("Failed to initialize chat message notification RPC method");
        }
    }

    private static void registerPlayerDeathNotification() {
        class_11817 methodInfo = new class_11817("Player death notification", Optional.of(new class_11818("death", ModRpcSchema.PLAYER_DEATH_MESSAGE.method_73727())), Optional.empty());
        class_11808.class_12055 attributes = new class_11808.class_12055(true);
        class_11808.class_11810 method = new class_11808.class_11810(methodInfo, attributes, RpcPlayerDeathMessage.CODEC);
        class_2960 id = class_2960.method_60655((String)"plus", (String)"notification/player/death");
        class_2378.method_10230((class_2378)class_7923.field_62491, (class_2960)id, (Object)method);
        PLAYER_DEATH_NOTIFICATION = class_7923.field_62491.method_10223(id).orElse(null);
    }

    private static void registerPlayerAdvancementNotification() {
        class_11817 methodInfo = new class_11817("Player advancement notification", Optional.of(new class_11818("advancement", ModRpcSchema.PLAYER_ADVANCEMENT_MESSAGE.method_73727())), Optional.empty());
        class_11808.class_12055 attributes = new class_11808.class_12055(true);
        class_11808.class_11810 method = new class_11808.class_11810(methodInfo, attributes, RpcPlayerAdvancementMessage.CODEC);
        class_2960 id = class_2960.method_60655((String)"plus", (String)"notification/player/advancement");
        class_2378.method_10230((class_2378)class_7923.field_62491, (class_2960)id, (Object)method);
        PLAYER_ADVANCEMENT_NOTIFICATION = class_7923.field_62491.method_10223(id).orElse(null);
    }

    private static void registerDynamicNotification() {
        class_11817 methodInfo = new class_11817("Dynamic notification", Optional.of(new class_11818("notification", ModRpcSchema.DYNAMIC_NOTIFICATION.method_73727())), Optional.empty());
        class_11808.class_12055 attributes = new class_11808.class_12055(true);
        class_11808.class_11810 method = new class_11808.class_11810(methodInfo, attributes, RpcDynamicNotification.CODEC);
        class_2960 id = class_2960.method_60655((String)"plus", (String)"notification/custom");
        class_2378.method_10230((class_2378)class_7923.field_62491, (class_2960)id, (Object)method);
        DYNAMIC_NOTIFICATION = class_7923.field_62491.method_10223(id).orElse(null);
    }

    static {
        EVENT_METHODS = new HashMap();
    }
}

