/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.management.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import msmp.plus.config.ConfigManager;
import msmp.plus.events.EventCategory;
import msmp.plus.events.EventType;

public class EventRpcHandler {
    public static JsonObject listEvents(String category) {
        JsonObject response = new JsonObject();
        JsonArray events = new JsonArray();
        EventCategory filterCategory = null;
        if (category != null && !category.isEmpty()) {
            try {
                filterCategory = EventCategory.valueOf(category.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                response.addProperty("error", "Invalid category: " + category);
                return response;
            }
        }
        for (EventType type : EventType.values()) {
            if (filterCategory != null && type.getCategory() != filterCategory) continue;
            JsonObject eventObj = new JsonObject();
            eventObj.addProperty("name", type.getEventName());
            eventObj.addProperty("category", type.getCategory().name());
            eventObj.addProperty("msmpMethod", type.getMsmpMethod());
            eventObj.addProperty("enabled", Boolean.valueOf(type.isEnabled()));
            events.add((JsonElement)eventObj);
        }
        response.add("events", (JsonElement)events);
        response.addProperty("totalCount", (Number)events.size());
        return response;
    }

    public static JsonObject getEventStatus(String eventName) {
        JsonObject response = new JsonObject();
        EventType type = EventRpcHandler.findEventByName(eventName);
        if (type == null) {
            response.addProperty("error", "Event not found: " + eventName);
            return response;
        }
        response.addProperty("name", type.getEventName());
        response.addProperty("category", type.getCategory().name());
        response.addProperty("enabled", Boolean.valueOf(type.isEnabled()));
        response.addProperty("msmpMethod", type.getMsmpMethod());
        return response;
    }

    public static JsonObject toggleEvent(String eventName, boolean enabled) {
        JsonObject response = new JsonObject();
        EventType type = EventRpcHandler.findEventByName(eventName);
        if (type == null) {
            response.addProperty("error", "Event not found: " + eventName);
            return response;
        }
        ConfigManager.setEventEnabled(eventName, enabled);
        response.addProperty("success", Boolean.valueOf(true));
        response.addProperty("event", eventName);
        response.addProperty("enabled", Boolean.valueOf(enabled));
        response.addProperty("message", "Event " + eventName + " " + (enabled ? "enabled" : "disabled"));
        return response;
    }

    public static JsonObject setPlayerEventOverride(String playerUuid, String eventName, boolean enabled) {
        JsonObject response = new JsonObject();
        EventType type = EventRpcHandler.findEventByName(eventName);
        if (type == null) {
            response.addProperty("error", "Event not found: " + eventName);
            return response;
        }
        ConfigManager.setEventEnabledForPlayer(playerUuid, eventName, enabled);
        response.addProperty("success", Boolean.valueOf(true));
        response.addProperty("playerUuid", playerUuid);
        response.addProperty("event", eventName);
        response.addProperty("enabled", Boolean.valueOf(enabled));
        response.addProperty("message", "Event " + eventName + " " + (enabled ? "enabled" : "disabled") + " for player " + playerUuid);
        return response;
    }

    public static JsonObject getPlayerEventOverrides(String playerUuid) {
        JsonObject response = new JsonObject();
        Map<String, Boolean> overrides = ConfigManager.getPlayerEventOverrides(playerUuid);
        JsonObject overridesObj = new JsonObject();
        for (Map.Entry<String, Boolean> entry : overrides.entrySet()) {
            overridesObj.addProperty(entry.getKey(), entry.getValue());
        }
        response.add("overrides", (JsonElement)overridesObj);
        response.addProperty("playerUuid", playerUuid);
        response.addProperty("count", (Number)overrides.size());
        return response;
    }

    public static JsonObject clearPlayerEventOverrides(String playerUuid) {
        JsonObject response = new JsonObject();
        ConfigManager.clearPlayerEventOverrides(playerUuid);
        response.addProperty("success", Boolean.valueOf(true));
        response.addProperty("playerUuid", playerUuid);
        response.addProperty("message", "Cleared all event overrides for player " + playerUuid);
        return response;
    }

    public static JsonObject listCategories() {
        JsonObject response = new JsonObject();
        JsonArray categories = new JsonArray();
        for (EventCategory category : EventCategory.values()) {
            JsonObject categoryObj = new JsonObject();
            categoryObj.addProperty("name", category.name());
            categoryObj.addProperty("description", category.getDescription());
            int eventCount = 0;
            for (EventType type : EventType.values()) {
                if (type.getCategory() != category) continue;
                ++eventCount;
            }
            categoryObj.addProperty("eventCount", (Number)eventCount);
            categories.add((JsonElement)categoryObj);
        }
        response.add("categories", (JsonElement)categories);
        response.addProperty("totalCount", (Number)categories.size());
        return response;
    }

    private static EventType findEventByName(String name) {
        for (EventType type : EventType.values()) {
            if (!type.getEventName().equals(name)) continue;
            return type;
        }
        return null;
    }
}

