/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.management.handler;

import msmp.plus.MsmplusMod;
import msmp.plus.management.ModOutgoingRpcMethods;
import msmp.plus.management.RpcChatMessage;
import msmp.plus.management.RpcDynamicNotification;
import msmp.plus.management.RpcPlayerAdvancementMessage;
import msmp.plus.management.RpcPlayerDeathMessage;
import msmp.plus.mixin.ManagementServerAccessor;
import msmp.plus.mixin.MinecraftDedicatedServerAccessor;
import net.minecraft.class_11807;
import net.minecraft.class_11808;
import net.minecraft.class_2561;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class NotificationBroadcaster {
    private static class_3176 dedicatedServer;

    public static void initialize(MinecraftServer server) {
        if (server instanceof class_3176) {
            class_3176 dedicatedServer;
            NotificationBroadcaster.dedicatedServer = dedicatedServer = (class_3176)server;
            MsmplusMod.LOGGER.info("MSMPlus notification broadcaster initialized");
        }
    }

    public static void broadcastChatMessage(class_3222 player, String message) {
        if (dedicatedServer == null || ModOutgoingRpcMethods.CHAT_MESSAGE_NOTIFICATION == null) {
            return;
        }
        RpcChatMessage chatMessage = new RpcChatMessage(player.method_7334().name(), message, System.currentTimeMillis(), player.method_5667().toString());
        NotificationBroadcaster.sendNotification(ModOutgoingRpcMethods.CHAT_MESSAGE_NOTIFICATION, chatMessage, "chat message");
    }

    public static void broadcastPlayerDeath(class_3222 player, class_2561 deathMessage, class_3222 killer, String cause) {
        if (dedicatedServer == null || ModOutgoingRpcMethods.PLAYER_DEATH_NOTIFICATION == null) {
            return;
        }
        RpcPlayerDeathMessage deathMsg = new RpcPlayerDeathMessage(player.method_7334().name(), deathMessage.getString(), System.currentTimeMillis(), player.method_5667().toString(), killer != null ? killer.method_7334().name() : "", cause != null ? cause : "");
        NotificationBroadcaster.sendNotification(ModOutgoingRpcMethods.PLAYER_DEATH_NOTIFICATION, deathMsg, "player death");
    }

    public static void broadcastPlayerAdvancement(class_3222 player, String advancementId, String title, String description, String type) {
        if (dedicatedServer == null || ModOutgoingRpcMethods.PLAYER_ADVANCEMENT_NOTIFICATION == null) {
            return;
        }
        RpcPlayerAdvancementMessage advMsg = new RpcPlayerAdvancementMessage(player.method_7334().name(), advancementId, title, description, System.currentTimeMillis(), player.method_5667().toString(), type);
        NotificationBroadcaster.sendNotification(ModOutgoingRpcMethods.PLAYER_ADVANCEMENT_NOTIFICATION, advMsg, "player advancement");
    }

    public static void broadcastCustomNotification(String type, String title, String message, String source, String level) {
        if (dedicatedServer == null || ModOutgoingRpcMethods.DYNAMIC_NOTIFICATION == null) {
            return;
        }
        String jsonData = String.format("{\"type\":\"%s\",\"title\":\"%s\",\"message\":\"%s\",\"level\":\"%s\"}", type.replace("\"", "\\\""), title.replace("\"", "\\\""), message.replace("\"", "\\\""), level.replace("\"", "\\\""));
        RpcDynamicNotification notification = new RpcDynamicNotification(jsonData, System.currentTimeMillis(), source);
        NotificationBroadcaster.sendNotification(ModOutgoingRpcMethods.DYNAMIC_NOTIFICATION, notification, "custom notification");
    }

    public static void broadcastDynamicNotification(String jsonData, String source) {
        if (dedicatedServer == null || ModOutgoingRpcMethods.DYNAMIC_NOTIFICATION == null) {
            return;
        }
        RpcDynamicNotification notification = new RpcDynamicNotification(jsonData, System.currentTimeMillis(), source);
        NotificationBroadcaster.sendNotification(ModOutgoingRpcMethods.DYNAMIC_NOTIFICATION, notification, "dynamic notification");
    }

    private static <T> void sendNotification(class_6880.class_6883<class_11808<T, ?>> method, T payload, String notificationType) {
        try {
            class_11807 managementServer = ((MinecraftDedicatedServerAccessor)dedicatedServer).getManagementServer();
            if (managementServer != null) {
                ((ManagementServerAccessor)managementServer).invokeForEachConnection(connection -> {
                    try {
                        connection.method_73609(method, payload);
                    }
                    catch (Exception e) {
                        MsmplusMod.LOGGER.error("Failed to send {} notification: {}", (Object)notificationType, (Object)e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            MsmplusMod.LOGGER.error("Failed to send {} notification: {}", (Object)notificationType, (Object)e.getMessage());
        }
    }
}

