/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.mixin;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.epoll.EpollEventLoopGroup;
import msmp.plus.Config;
import msmp.plus.MsmplusMod;
import net.minecraft.class_11807;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_11807.class})
public abstract class ManagementServerMixin {
    @Unique
    private Config config;
    @Unique
    @Nullable
    private EpollEventLoopGroup epollEventLoopGroup;

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    void constructor(CallbackInfo ci) {
        this.config = MsmplusMod.getConfig();
        if (this.config.unixSocketEnabled()) {
            this.epollEventLoopGroup = new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Management server IO #%d").setDaemon(true).build());
        }
    }

    @Inject(method={"stop"}, at={@At(value="TAIL")})
    void stop(boolean shutdownEventLoop, CallbackInfo ci) throws InterruptedException {
        if (this.epollEventLoopGroup != null && shutdownEventLoop) {
            this.epollEventLoopGroup.shutdownGracefully().sync();
        }
    }

    @Inject(method={"getPort"}, at={@At(value="HEAD")}, cancellable=true)
    void getPort(CallbackInfoReturnable<Integer> cir) {
        if (this.config.unixSocketEnabled()) {
            cir.setReturnValue((Object)-1);
        }
    }
}

