/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.mixin;

import java.util.Map;
import msmp.plus.config.ConfigManager;
import msmp.plus.events.EventProcessor;
import msmp.plus.events.EventType;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3225.class})
public abstract class PlayerBlockBreakMixin {
    @Shadow
    public class_3222 field_14008;

    @Inject(method={"tryBreakBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onBroken(Lnet/minecraft/world/WorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V")})
    private void onBlockBroken(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        boolean debugMode = ConfigManager.getConfig().debug().debugMode();
        if (debugMode) {
            System.out.println("[DEBUG] PlayerBlockBreakMixin.onBlockBroken called at " + String.valueOf(pos));
        }
        if (this.field_14008 == null) {
            if (debugMode) {
                System.out.println("[DEBUG] PlayerBlockBreakMixin: player is null!");
            }
            return;
        }
        String playerUuid = this.field_14008.method_5667().toString();
        if (debugMode) {
            System.out.println("[DEBUG] PlayerBlockBreakMixin: player " + this.field_14008.method_7334().name() + " broke block at " + String.valueOf(pos));
        }
        boolean enabled = EventType.PLAYER_BREAK_BLOCK_AFTER.isEnabledForPlayer(playerUuid);
        if (debugMode) {
            System.out.println("[DEBUG] PLAYER_BREAK_BLOCK_AFTER enabled: " + enabled);
        }
        if (!enabled) {
            return;
        }
        Map<String, Long> eventData = Map.of("player", this.field_14008.method_7334().name(), "uuid", playerUuid, "x", pos.method_10263(), "y", pos.method_10264(), "z", pos.method_10260(), "dimension", this.field_14008.method_51469().method_27983().method_29177().toString(), "timestamp", System.currentTimeMillis());
        EventProcessor.submit(EventType.PLAYER_BREAK_BLOCK_AFTER, eventData, playerUuid);
    }
}

