/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.mixin;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import msmp.plus.config.ConfigManager;
import msmp.plus.config.EnhancedConfig;
import msmp.plus.events.EventProcessor;
import msmp.plus.events.EventType;
import msmp.plus.util.PlayerMovementData;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class PlayerMovementMixin {
    @Unique
    private static final Map<UUID, PlayerMovementData> lastMovementData = new ConcurrentHashMap<UUID, PlayerMovementData>();

    @Inject(method={"playerTick"}, at={@At(value="TAIL")})
    private void onPlayerTick(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        UUID playerUuid = player.method_5667();
        boolean debugMode = ConfigManager.getConfig().debug().debugMode();
        if (debugMode && System.currentTimeMillis() % 2000L < 50L) {
            System.out.println("[DEBUG] PlayerMovementMixin.onPlayerTick called for " + player.method_7334().name());
        }
        boolean enabled = EventType.PLAYER_MOVE.isEnabledForPlayer(playerUuid.toString());
        if (debugMode && System.currentTimeMillis() % 2000L < 50L) {
            System.out.println("[DEBUG] PLAYER_MOVE enabled for " + player.method_7334().name() + ": " + enabled);
        }
        if (!enabled) {
            return;
        }
        class_243 currentPos = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
        String currentDimension = player.method_51469().method_27983().method_29177().toString();
        long currentTime = System.currentTimeMillis();
        EnhancedConfig.PlayerMovementConfig movementConfig = ConfigManager.getConfig().events().player().playerMovement();
        PlayerMovementData lastData = lastMovementData.get(playerUuid);
        boolean shouldBroadcast = false;
        if (lastData == null) {
            shouldBroadcast = true;
        } else {
            long throttleMs;
            long timeSinceLastBroadcast;
            double distance;
            if (!lastData.lastDimension.equals(currentDimension) && movementConfig.trackDimensionChanges()) {
                shouldBroadcast = true;
            }
            if ((distance = currentPos.method_1022(lastData.lastPosition)) >= movementConfig.minimumDistance() && (timeSinceLastBroadcast = currentTime - lastData.lastBroadcastTime) >= (throttleMs = (long)movementConfig.throttleTicks() * 50L)) {
                shouldBroadcast = true;
            }
        }
        if (shouldBroadcast) {
            Map<String, Float> eventData = Map.of("player", player.method_7334().name(), "uuid", playerUuid.toString(), "x", currentPos.field_1352, "y", currentPos.field_1351, "z", currentPos.field_1350, "dimension", currentDimension, "yaw", Float.valueOf(player.method_36454()), "pitch", Float.valueOf(player.method_36455()));
            EventProcessor.submit(EventType.PLAYER_MOVE, eventData, playerUuid.toString());
            lastMovementData.put(playerUuid, new PlayerMovementData(currentPos, currentTime, currentDimension));
        }
    }

    @Inject(method={"onDisconnect"}, at={@At(value="TAIL")})
    private void onPlayerDisconnect(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        lastMovementData.remove(player.method_5667());
    }
}

