/*
 * Decompiled with CFR 0.152.
 */
package msmp.plus.mixin;

import java.util.Map;
import msmp.plus.events.EventProcessor;
import msmp.plus.events.EventType;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class WorldWeatherMixin {
    @Unique
    private boolean wasRaining = false;
    @Unique
    private boolean wasThundering = false;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onWorldTick(CallbackInfo ci) {
        boolean weatherChanged;
        if (!EventType.WEATHER_CHANGE.isEnabled()) {
            return;
        }
        class_3218 world = (class_3218)this;
        boolean isRaining = world.method_8419();
        boolean isThundering = world.method_8546();
        boolean bl = weatherChanged = isRaining != this.wasRaining || isThundering != this.wasThundering;
        if (weatherChanged) {
            String newWeather = isThundering ? "thunder" : (isRaining ? "rain" : "clear");
            Map<String, Long> eventData = Map.of("dimension", world.method_27983().method_29177().toString(), "weather", newWeather, "raining", isRaining, "thundering", isThundering, "timestamp", System.currentTimeMillis());
            EventProcessor.submit(EventType.WEATHER_CHANGE, eventData, null);
            this.wasRaining = isRaining;
            this.wasThundering = isThundering;
        }
    }
}

