/*
 * Decompiled with CFR 0.152.
 */
package coathier.scalingmobs;

import coathier.scalingmobs.ScalingValue;
import coathier.scalingmobs.Scalingmobs;
import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ScalingMobsConfig {
    public static ScalingMobsConfig INSTANCE;
    public List<ScalingValue> health;
    public List<ScalingValue> damage;
    public List<ScalingValue> speed;
    public Boolean healthAddOnTopOfDefault = false;
    public Boolean damageAddOnTopOfDefault = false;
    public Boolean speedAddOnTopOfDefault = false;

    public void load() {
        this.health = new LinkedList<ScalingValue>();
        this.damage = new LinkedList<ScalingValue>();
        this.speed = new LinkedList<ScalingValue>();
        File file = new File("config/scalingmobs.toml");
        if (!file.exists()) {
            try {
                File dir = new File("config");
                if (!dir.exists()) {
                    dir.mkdir();
                }
                file.createNewFile();
                FileWriter writer = new FileWriter(file);
                writer.write("# EDIT THIS FILE, IT'S ONLY A EXAMPLE!\n# This is a example config. Each comment describes what the\n# setting/modifier under it does\n\n# All health modifiers get applied on top of vanilla/default\n# attributes if this variable is set to true\nhealthAddOnTopOfDefault = true\n\n# All damage and speed modifiers will be applied from 0, without the\n# vanilla attributes\ndamageAddOnTopOfDefault = false\nspeedAddOnTopOfDefault = false\n\n# Modifiers where \"timeWhenActive\" isn't set are only\n# active at night because that variables default value is \"NIGHT\"\n# and is set implicitly.\n\n# For every block below Y=63 mobs gain hearts exponentially\n# This health modifier follows the formula:\n# health = start * (increaseFactor ^ blocksBelowSeaLevel)\n# health = 1 * (1.04 ^ blocksBelowSeaLevel)\n[[health]]\nstart = 1\nscalingFactor = \"DEPTH\"\nscalingType = \"EXPONENTIAL\"\nincreaseFactor = 1.04\n\n# https://minecraft.fandom.com/wiki/Moon\n# At new moon the scaling is 0, at full moon it's 4\n# You probably want to limit this to the overworld\n# since there no actual moon in the nether or end dimension\n[[speed]]\ndimensionFilterType = \"INCLUDE\"\ndimensionFilter = [ \"minecraft:overworld\" ]\nstart = 0.15\nscalingFactor = \"LUNAR_PHASE\"\nscalingType = \"LINEAR\"\nincreaseFactor = 0.05\n\n# As you can see below one attribute can have as many different\n# scaling modifiers as you want, here damage is both changed\n# by days passed and the mobs distance from spawn\n\n# Everyday mobs do +0.5 more damage starting from 3 damage.\n# This scaling will at most only make mobs do 10 extra damage.\n# The scaling is only active every other day i.e day 1,3,5...\n# This damage modifier follows the formula:\n# damage = start + daysPassed * increaseFactor\n# damage = 3.0 + daysPassed * 0.5\n# Don't forget that this damage is added to the mobs default\n# damage attribute because we set the \"damageAddOnTopOfDefault\" variable to true\n[[damage]]\nactiveNth = 2\nstart = 3.0\nmax = 10.0\nscalingFactor = \"DAYS\"\nscalingType = \"LINEAR\"\nincreaseFactor = 0.5\n\n# Beyond 500 blocks from spawn (X=0, Z=0) mobs do 10 extra damage\n# both day and night\n[[damage]]\nscalingFactor = \"DISTANCE_FROM_SPAWN\"\nscalingType = \"CONSTANT\"\nincreaseFactor = 10\nstartingFrom = 500\ntimeWhenActive = \"BOTH\"\n\n# Makes zombies and creepers move quite fast, 0.4 is\n# already ridiculously fast\n[[speed]]\nmobFilterType = \"INCLUDE\"\nmobFilter = [ \"minecraft:zombie\", \"minecraft:creeper\" ]\nscalingType = \"CONSTANT\"\nincreaseFactor = 0.2\ntimeWhenActive = \"BOTH\"\n\n# Makes mobs stand still in all dimensions except for the overworld.\n# Since scalingFactor and activeNth default to \"DAYS\" and 1 this will\n# always be active\n[[speed]]\ndimensionFilterType = \"EXCLUDE\"\ndimensionFilter = [ \"minecraft:overworld\" ]\nscalingType = \"CONSTANT\"\nscalingFactor = \"DAYS\"\nincreaseFactor = 0\ntimeWhenActive = \"BOTH\" # This value can be \"DAY\" or \"NIGHT\". \"NIGHT\" is default\n");
                writer.close();
            }
            catch (IOException e) {
                Scalingmobs.LOGGER.error(e.toString());
                Scalingmobs.LOGGER.error("Error while writing trying to write default config");
            }
        }
        Toml config = new Toml().read(file);
        this.healthAddOnTopOfDefault = config.getBoolean("healthAddOnTopOfDefault", Boolean.valueOf(false));
        this.damageAddOnTopOfDefault = config.getBoolean("damageAddOnTopOfDefault", Boolean.valueOf(false));
        this.speedAddOnTopOfDefault = config.getBoolean("speedAddOnTopOfDefault", Boolean.valueOf(false));
        try {
            ScalingValue scalingValue;
            List tables = config.getTables("health");
            if (tables != null) {
                for (Toml table : tables) {
                    scalingValue = (ScalingValue)table.to(ScalingValue.class);
                    scalingValue.setDefaults();
                    this.health.add(scalingValue);
                }
            }
            if ((tables = config.getTables("damage")) != null) {
                for (Toml table : tables) {
                    scalingValue = (ScalingValue)table.to(ScalingValue.class);
                    scalingValue.setDefaults();
                    this.damage.add(scalingValue);
                }
            }
            if ((tables = config.getTables("speed")) != null) {
                for (Toml table : tables) {
                    scalingValue = (ScalingValue)table.to(ScalingValue.class);
                    scalingValue.setDefaults();
                    this.speed.add(scalingValue);
                }
            }
        }
        catch (Exception e) {
            Scalingmobs.LOGGER.error(e.toString());
            Scalingmobs.LOGGER.error("Error reading config file, something is probably formatted incorrectly.");
        }
        INSTANCE = this;
    }
}

