/*
 * Decompiled with CFR 0.152.
 */
package coathier.scalingmobs;

import coathier.scalingmobs.Scalingmobs;
import coathier.scalingmobs.Util;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_243;

public class ScalingValue {
    private static final int WATER_LEVEL = 63;
    public Float start;
    public Float max;
    public Float min;
    public ScalingFactor scalingFactor;
    public ScalingType scalingType;
    public Float increaseFactor;
    public Integer startingFrom;
    public Integer activeNth;
    public Time timeWhenActive;
    public FilterType dimensionFilterType;
    public List<String> dimensionFilter;
    public FilterType mobFilterType;
    public List<String> mobFilter;

    public Optional<Float> calculateValue(class_243 position, long time, String dimension, String mob) {
        Boolean isInFilter = this.dimensionFilter.contains(dimension);
        switch (this.dimensionFilterType.ordinal()) {
            case 0: {
                if (!isInFilter.booleanValue()) break;
                return Optional.empty();
            }
            case 1: {
                if (isInFilter.booleanValue()) break;
                return Optional.empty();
            }
        }
        isInFilter = this.mobFilter.contains(mob);
        switch (this.mobFilterType.ordinal()) {
            case 0: {
                if (!isInFilter.booleanValue()) break;
                return Optional.empty();
            }
            case 1: {
                if (isInFilter.booleanValue()) break;
                return Optional.empty();
            }
        }
        switch (this.timeWhenActive.ordinal()) {
            case 0: {
                if (!Util.isNight(time)) break;
                return Optional.empty();
            }
            case 1: {
                if (Util.isNight(time)) break;
                return Optional.empty();
            }
        }
        int scalingValue = 1;
        switch (this.scalingFactor.ordinal()) {
            case 0: {
                scalingValue = Util.daysPassed(time);
                break;
            }
            case 1: {
                scalingValue = (int)Math.sqrt(position.field_1352 * position.field_1352 + position.field_1350 * position.field_1350);
                break;
            }
            case 2: {
                scalingValue = Math.abs(Util.daysPassed(time) % 8 - 4);
                break;
            }
            case 3: {
                if ((int)position.field_1351 < 63) {
                    scalingValue = Math.abs((int)position.field_1351 - 63);
                    break;
                }
                return Optional.empty();
            }
            case 4: {
                if ((int)position.field_1351 > 63) {
                    scalingValue = (int)position.field_1351 - 63;
                    break;
                }
                return Optional.empty();
            }
        }
        if (scalingValue % this.activeNth != 0) {
            return Optional.empty();
        }
        if (scalingValue < this.startingFrom) {
            return Optional.empty();
        }
        scalingValue -= this.startingFrom.intValue();
        float value = this.start.floatValue();
        switch (this.scalingType.ordinal()) {
            case 0: {
                value = this.start.floatValue() + this.increaseFactor.floatValue() * (float)scalingValue;
                break;
            }
            case 1: {
                value = this.start.floatValue() * (float)Math.pow(this.increaseFactor.floatValue(), scalingValue);
                break;
            }
            case 2: {
                value = this.increaseFactor.floatValue();
            }
        }
        if (value > this.max.floatValue()) {
            return Optional.of(this.max);
        }
        if (value < this.min.floatValue()) {
            return Optional.of(this.min);
        }
        return Optional.of(Float.valueOf(value));
    }

    public void setDefaults() {
        if (this.scalingType == null) {
            this.scalingType = ScalingType.LINEAR;
            Scalingmobs.LOGGER.info("scalingType is either not set or incorrectly configured! (defaulting to \"LINEAR\")");
        }
        if (this.activeNth == null) {
            this.activeNth = 1;
        }
        if (this.activeNth == 0) {
            this.activeNth = 1;
            Scalingmobs.LOGGER.info("activeNth is incorrectly configured, it can't be \"0\"! (defaulting to \"1\")");
        }
        if (this.scalingFactor == null) {
            this.scalingFactor = ScalingFactor.DAYS;
            Scalingmobs.LOGGER.info("scalingFactor is either not set or incorrectly configured! (defaulting to \"DAYS\")");
        }
        if (this.dimensionFilterType == null) {
            this.dimensionFilterType = FilterType.EXCLUDE;
        }
        if (this.dimensionFilter == null) {
            this.dimensionFilter = new LinkedList<String>();
        }
        if (this.mobFilter == null) {
            this.mobFilter = new LinkedList<String>();
        }
        if (this.mobFilterType == null) {
            this.mobFilterType = FilterType.EXCLUDE;
        }
        if (this.timeWhenActive == null) {
            this.timeWhenActive = Time.NIGHT;
            Scalingmobs.LOGGER.info("timeWhenActive is either not set or incorrectly configured! (defaulting to \"NIGHT\")");
        }
        if (this.start == null) {
            this.start = Float.valueOf(0.0f);
        }
        if (this.max == null) {
            this.max = Float.valueOf(Float.MAX_VALUE);
        }
        if (this.min == null) {
            this.min = Float.valueOf(0.0f);
        }
        if (this.startingFrom == null) {
            this.startingFrom = 0;
        }
        if (this.increaseFactor == null) {
            this.increaseFactor = Float.valueOf(1.1f);
        }
    }

    public static enum FilterType {
        EXCLUDE,
        INCLUDE;

    }

    public static enum Time {
        DAY,
        NIGHT,
        BOTH;

    }

    public static enum ScalingFactor {
        DAYS,
        DISTANCE_FROM_SPAWN,
        LUNAR_PHASE,
        DEPTH,
        HEIGHT;

    }

    public static enum ScalingType {
        LINEAR,
        EXPONENTIAL,
        CONSTANT;

    }
}

