package io.github.adelinam17n.skippacks.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.adelinam17n.skippacks.client.ducks.SkippedRequiredPackGetter;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.net.URL;
import java.util.UUID;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2720;
import net.minecraft.class_2856;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_641;
import net.minecraft.class_642;
import net.minecraft.class_8673;

@Mixin(class_8673.class)
public abstract class ClientCommonPacketListenerImplMixin {
    @Shadow
    @Final
    protected class_2535 connection;

    @Shadow
    @Final
    @Nullable
    protected class_642 serverData;

    @Shadow
    @Final
    protected class_310 minecraft;

    @Shadow
    protected abstract class_437 addOrUpdatePackPrompt(UUID uUID, URL uRL, String string, boolean bl, @Nullable class_2561 component);

    @Inject(
            method = "handleResourcePackPush",
            at = @At(
                    target = "net/minecraft/client/multiplayer/ClientCommonPacketListenerImpl.parseResourcePackUrl (Ljava/lang/String;)Ljava/net/URL;",
                    shift = At.Shift.AFTER,
                    value = "INVOKE"
            ),
            cancellable = true
    )
    private void injectAfterParseUrl$handleResourcePackPush(class_2720 clientboundResourcePackPushPacket, CallbackInfo ci, @Local UUID uUID){
        if(this.serverData != null && ((SkippedRequiredPackGetter) this.serverData).getRequiredPackSkipped$skipserverpacks()){
           sendLiesAndPrayers(uUID);
           ci.cancel();
        }
    }

    @Inject(
            method = "handleResourcePackPush",
            at = @At(
                    target = "Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V",
                    value = "INVOKE"
            ),
            cancellable = true
    )
    private void injectBeforeScreen(class_2720 clientboundResourcePackPushPacket, CallbackInfo ci, @Local UUID uUID, @Local URL uRL, @Local String string, @Local boolean bl){
        if(bl){
            class_437 oldScreen = this.minecraft.field_1755;
            this.minecraft.method_1507(
                    new class_410(
                    accepted ->
                    {
                        minecraft.method_1507(oldScreen);
                        if(!accepted){
                            assert serverData != null;
                            this.sendLiesAndPrayers(uUID);
                            ((SkippedRequiredPackGetter) this.serverData).setRequiredPackSkipped$skipserverpacks(true);
                            class_641.method_2986(this.serverData);
                        }else {
                            this.minecraft.method_1507(this.addOrUpdatePackPrompt(uUID, uRL, string, bl, clientboundResourcePackPushPacket.comp_2162().orElse(null)));
                        }
                    },
                    class_2561.method_43470("To lie or to not lie?"),
                    class_2561.method_43470(
                            """
                                   This server requires you to use their custom resource-pack, with SkipServerResourcepacks mod, you can decline it and still join the server.
                                   
                                   If you want to join the server without downloading the resource-pack, click "Decline".
                                   Be Warned! The server intends you to have this resource-pack, things might not look or function correctly without it!
                                   
                                   Clicking on "Proceed" will redirect you to the vanilla prompt screen, where you can accept the pack or disconnect.
                                   """
                    ),
                    class_2561.method_43470("Proceed"),
                    class_2561.method_43470("Decline")
            ));
            ci.cancel();
        }
    }

    @Unique
    private void sendLiesAndPrayers(UUID uUID){
        this.connection.method_10743(new class_2856(uUID, class_2856.class_2857.field_13016));
        this.connection.method_10743(new class_2856(uUID, class_2856.class_2857.field_47704));
        this.connection.method_10743(new class_2856(uUID, class_2856.class_2857.field_13017));
    }
}
