package io.github.adelinam17n.skippacks.client.mixin;


import com.llamalad7.mixinextras.sugar.Local;
import io.github.adelinam17n.skippacks.client.ducks.SkippedRequiredPackGetter;
import net.minecraft.class_2487;
import net.minecraft.class_642;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_642.class)
public class ServerDataMixin implements SkippedRequiredPackGetter {
    @Unique
    private boolean requiredPackSkipped = false;

    @Inject(
            method = "read",
            at = @At(
                    "TAIL"
            )
    )
    private static void injectTail$read$skipserverpacks(class_2487 nbtCompound, CallbackInfoReturnable<class_642> cir, @Local class_642 serverData) {
        if (nbtCompound.method_10545("requiredPackSkipped")) {
            ((SkippedRequiredPackGetter) serverData).setRequiredPackSkipped$skipserverpacks(
                    nbtCompound.method_10577("requiredPackSkipped")
            );
        }
    }

    @Inject(
            method = "setResourcePackStatus",
            at = @At("HEAD")
    )
    private void changeSkipStatusOnPackStusChange(class_642.class_643 serverPackStatus, CallbackInfo ci){
        setRequiredPackSkipped$skipserverpacks(false);
    }

    @Inject(
            method = "write",
            at = @At(
                    "TAIL"
            )
    )
    private void injectTail$write$skipserverpacks(CallbackInfoReturnable<class_2487> cir, @Local class_2487 compoundTag) {
        compoundTag.method_10556("requiredPackSkipped", requiredPackSkipped);
    }

    @Override
    public boolean getRequiredPackSkipped$skipserverpacks() {
        return requiredPackSkipped;
    }

    @Override
    public void setRequiredPackSkipped$skipserverpacks(boolean value) {
        this.requiredPackSkipped = value;
    }
}